/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.BossBarConfig;
import com.astrelion.worldlevels.config.ConfigData;
import com.astrelion.worldlevels.config.ConfigDataKt;
import com.astrelion.worldlevels.config.ConfigurationKt;
import com.astrelion.worldlevels.config.CustomXPSourceData;
import com.astrelion.worldlevels.config.CustomXPSources;
import com.astrelion.worldlevels.config.LevelData;
import com.astrelion.worldlevels.config.Pos2;
import com.astrelion.worldlevels.config.ProceduralStep;
import com.astrelion.worldlevels.config.WorldBorder;
import com.astrelion.worldlevels.util.Parser;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.ExperienceOrb;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 V2\u00020\u0001:\u0001VB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020FJ\u001a\u0010H\u001a\u00020F2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00010#J\u0006\u0010J\u001a\u00020FJ\u0006\u0010K\u001a\u00020\u0019J\u0006\u0010L\u001a\u00020\u000bJ\u000e\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u000bJ\u000e\u0010O\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u000bJ\u0006\u0010P\u001a\u00020\u000bJ\u000e\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020SJ\u001e\u0010T\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020\u00110#0#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u001f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R6\u0010%\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b0#2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b0#@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001e\u0010)\u001a\u00020(2\u0006\u0010\n\u001a\u00020(@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R*\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150,2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00150,@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R*\u00101\u001a\b\u0012\u0004\u0012\u00020\u0015002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u001500@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R*\u00104\u001a\b\u0012\u0004\u0012\u00020\u0015002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u001500@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00103R\u001e\u00106\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001cR\u001e\u00109\u001a\u0002082\u0006\u0010\n\u001a\u000208@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R*\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00150,2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00150,@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010/R*\u0010?\u001a\b\u0012\u0004\u0012\u00020>0,2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020>0,@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010/R\u001e\u0010A\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u001cR\u001e\u0010C\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u001c\u00a8\u0006W"}, d2={"Lcom/astrelion/worldlevels/config/Configuration;", "", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "getPlugin", "()Lcom/astrelion/worldlevels/WorldLevels;", "data", "Lcom/astrelion/worldlevels/config/ConfigData;", "value", "", "relativeXP", "getRelativeXP", "()D", "neededXP", "getNeededXP", "", "currentLevel", "getCurrentLevel", "()I", "", "currentLevelKey", "getCurrentLevelKey", "()Ljava/lang/String;", "", "allowNether", "getAllowNether", "()Z", "allowEnd", "getAllowEnd", "Lcom/astrelion/worldlevels/config/WorldBorder;", "worldBorder", "getWorldBorder", "()Lcom/astrelion/worldlevels/config/WorldBorder;", "", "Lorg/bukkit/entity/ExperienceOrb$SpawnReason;", "xpWeights", "getXpWeights", "()Ljava/util/Map;", "Lcom/astrelion/worldlevels/config/CustomXPSources;", "customXPSources", "getCustomXPSources", "()Lcom/astrelion/worldlevels/config/CustomXPSources;", "", "commands", "getCommands", "()Ljava/util/List;", "", "permissions", "getPermissions", "()Ljava/util/Set;", "groups", "getGroups", "enabled", "getEnabled", "Lcom/astrelion/worldlevels/config/BossBarConfig;", "bossBar", "getBossBar", "()Lcom/astrelion/worldlevels/config/BossBarConfig;", "worldDenylist", "getWorldDenylist", "Lorg/bukkit/GameMode;", "gamemodeDenylist", "getGamemodeDenylist", "rewardOfflinePlayers", "getRewardOfflinePlayers", "rewardNewPlayers", "getRewardNewPlayers", "reload", "", "load", "migrate", "oldMap", "init", "apply", "levelMin", "setExperience", "xp", "addExperience", "getProgress", "worldEnabled", "world", "Lorg/bukkit/World;", "getItemRewards", "Lorg/bukkit/Material;", "Companion", "WorldLevels"})
@SourceDebugExtension(value={"SMAP\nConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Configuration.kt\ncom/astrelion/worldlevels/config/Configuration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,521:1\n1563#2:522\n1634#2,3:523\n360#2,7:526\n774#2:533\n865#2,2:534\n*S KotlinDebug\n*F\n+ 1 Configuration.kt\ncom/astrelion/worldlevels/config/Configuration\n*L\n204#1:522\n204#1:523,3\n396#1:526,7\n398#1:533\n398#1:534,2\n*E\n"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldLevels plugin;
    private ConfigData data;
    private double relativeXP;
    private double neededXP;
    private int currentLevel;
    @Nullable
    private String currentLevelKey;
    private boolean allowNether;
    private boolean allowEnd;
    private WorldBorder worldBorder;
    private Map<ExperienceOrb.SpawnReason, Double> xpWeights;
    private CustomXPSources customXPSources;
    private List<String> commands;
    private Set<String> permissions;
    private Set<String> groups;
    private boolean enabled;
    private BossBarConfig bossBar;
    private List<String> worldDenylist;
    private List<? extends GameMode> gamemodeDenylist;
    private boolean rewardOfflinePlayers;
    private boolean rewardNewPlayers;
    @NotNull
    public static final String FILE_NAME = "config.yml";

    @NotNull
    public final WorldLevels getPlugin() {
        return this.plugin;
    }

    public final double getRelativeXP() {
        return this.relativeXP;
    }

    public final double getNeededXP() {
        return this.neededXP;
    }

    public final int getCurrentLevel() {
        return this.currentLevel;
    }

    @Nullable
    public final String getCurrentLevelKey() {
        return this.currentLevelKey;
    }

    public final boolean getAllowNether() {
        return this.allowNether;
    }

    public final boolean getAllowEnd() {
        return this.allowEnd;
    }

    @NotNull
    public final WorldBorder getWorldBorder() {
        WorldBorder worldBorder = this.worldBorder;
        if (worldBorder != null) {
            return worldBorder;
        }
        Intrinsics.throwUninitializedPropertyAccessException("worldBorder");
        return null;
    }

    @NotNull
    public final Map<ExperienceOrb.SpawnReason, Double> getXpWeights() {
        Map<ExperienceOrb.SpawnReason, Double> map = this.xpWeights;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException("xpWeights");
        return null;
    }

    @NotNull
    public final CustomXPSources getCustomXPSources() {
        CustomXPSources customXPSources = this.customXPSources;
        if (customXPSources != null) {
            return customXPSources;
        }
        Intrinsics.throwUninitializedPropertyAccessException("customXPSources");
        return null;
    }

    @NotNull
    public final List<String> getCommands() {
        List<String> list = this.commands;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("commands");
        return null;
    }

    @NotNull
    public final Set<String> getPermissions() {
        Set<String> set = this.permissions;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException("permissions");
        return null;
    }

    @NotNull
    public final Set<String> getGroups() {
        Set<String> set = this.groups;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException("groups");
        return null;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final BossBarConfig getBossBar() {
        BossBarConfig bossBarConfig = this.bossBar;
        if (bossBarConfig != null) {
            return bossBarConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException("bossBar");
        return null;
    }

    @NotNull
    public final List<String> getWorldDenylist() {
        List<String> list = this.worldDenylist;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("worldDenylist");
        return null;
    }

    @NotNull
    public final List<GameMode> getGamemodeDenylist() {
        List<GameMode> list = this.gamemodeDenylist;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gamemodeDenylist");
        return null;
    }

    public final boolean getRewardOfflinePlayers() {
        return this.rewardOfflinePlayers;
    }

    public final boolean getRewardNewPlayers() {
        return this.rewardNewPlayers;
    }

    public Configuration(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.allowNether = true;
        this.allowEnd = true;
        this.enabled = true;
        this.rewardOfflinePlayers = true;
        this.plugin = plugin;
        this.reload();
    }

    public final void reload() {
        this.load();
        this.init();
        this.apply();
    }

    public final void load() {
        File file = new File(this.plugin.getDataFolder(), FILE_NAME);
        Gson gson = Parser.INSTANCE.getGson();
        Yaml yaml = Parser.INSTANCE.getYaml();
        ConfigData defaultConfig = new ConfigData(0, false, null, null, null, false, false, false, null, null, null, 2047, null);
        Map defaultMap = (Map)gson.fromJson(gson.toJson((Object)defaultConfig), Map.class);
        if (file.exists()) {
            Map yamlMap = (Map)yaml.load(FilesKt.readText$default(file, null, 1, null));
            Intrinsics.checkNotNull(defaultMap);
            for (Map.Entry defaultEntry : defaultMap.entrySet()) {
                Object v;
                Intrinsics.checkNotNull(yamlMap);
                if (yamlMap.containsKey(defaultEntry.getKey())) continue;
                Map map = yamlMap;
                Object k = defaultEntry.getKey();
                Intrinsics.checkNotNull(k, "null cannot be cast to non-null type kotlin.String");
                String string = (String)k;
                Intrinsics.checkNotNull(defaultEntry.getValue(), "null cannot be cast to non-null type kotlin.Any");
                map.put(string, v);
                this.plugin.getLogger().log(Level.WARNING, "Missing config key " + defaultEntry.getKey() + ", default inserted");
            }
            Object newYaml = "# yaml-language-server: $schema=https://gitlab.com/ASTRELION/worldlevels/-/raw/main/src/main/resources/schema.json\n\n";
            newYaml = (String)newYaml + yaml.dump((Object)yamlMap);
            FilesKt.writeText$default(file, (String)newYaml, null, 2, null);
            String json = gson.toJson((Object)yamlMap);
            ConfigData newConfig = (ConfigData)gson.fromJson(json.toString(), ConfigData.class);
            Intrinsics.checkNotNull(newConfig);
            this.data = newConfig;
        } else {
            this.plugin.saveDefaultConfig();
            this.load();
        }
    }

    public final void migrate(@NotNull Map<String, ? extends Object> oldMap) {
        Intrinsics.checkNotNullParameter(oldMap, "oldMap");
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        char[] cArray;
        String string;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<String, LevelData> level;
        ConfigData configData = this.data;
        if (configData == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData = null;
        }
        if (configData.getLevels().isEmpty()) {
            this.plugin.getLogger().log(Level.WARNING, "No levels defined, this plugin won't do much!");
        }
        int l22 = 0;
        ConfigData configData2 = this.data;
        if (configData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData2 = null;
        }
        int n = configData2.getLevels().size();
        while (l22 < n) {
            Regex lastLevelRegex;
            ConfigData configData3;
            ConfigData configData4 = this.data;
            if (configData4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("data");
                configData4 = null;
            }
            level = MapsKt.toList(configData4.getLevels()).get(l22);
            if (l22 == 0) {
                Regex firstLevelRegex = new Regex("1(-\\d+)?");
                if (!firstLevelRegex.matches(level.getFirst())) {
                    this.plugin.getLogger().log(Level.SEVERE, "Level pattern '" + level.getFirst() + "' is invalid for first level");
                }
                if (!Intrinsics.areEqual(level.getSecond().getXp(), 0.0)) {
                    this.plugin.getLogger().log(Level.SEVERE, "First level should define 'xp: 0'");
                }
                ProceduralStep proceduralStep = level.getSecond().getXpStep();
                if ((proceduralStep != null ? proceduralStep.getMult() : null) != null) {
                    this.plugin.getLogger().log(Level.SEVERE, "First level should not use 'mult' in 'xpStep'");
                }
            } else {
                Regex levelRegex = new Regex("\\d+(-\\d*)?");
                if (!levelRegex.matches(level.getFirst())) {
                    this.plugin.getLogger().log(Level.SEVERE, "Level pattern '" + level.getFirst() + "' is invalid");
                }
            }
            if ((configData3 = this.data) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("data");
                configData3 = null;
            }
            if (l22 < configData3.getLevels().size() - 1 && (lastLevelRegex = new Regex("\\d+-")).matches(level.getFirst())) {
                this.plugin.getLogger().log(Level.SEVERE, "Only the last level can use pattern '" + level.getFirst() + "'");
            }
            if (level.getSecond().getXp() == null && level.getSecond().getXpStep() == null) {
                this.plugin.getLogger().log(Level.SEVERE, "Unable to determine XP requirements for level '" + level.getFirst() + "'");
            }
            ++l22;
        }
        ConfigData configData5 = this.data;
        if (configData5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData5 = null;
        }
        this.enabled = configData5.getEnabled();
        ConfigData configData6 = this.data;
        if (configData6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData6 = null;
        }
        this.rewardNewPlayers = configData6.getRewardNewPlayers();
        ConfigData configData7 = this.data;
        if (configData7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData7 = null;
        }
        this.rewardOfflinePlayers = configData7.getRewardOfflinePlayers();
        ConfigData configData8 = this.data;
        if (configData8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData8 = null;
        }
        this.xpWeights = ConfigurationKt.weightsToBukkitMap(configData8.getWeights());
        ConfigData configData9 = this.data;
        if (configData9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData9 = null;
        }
        this.customXPSources = ConfigurationKt.toBukkitMaps(configData9.getCustomXPSources());
        ConfigData configData10 = this.data;
        if (configData10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData10 = null;
        }
        this.worldDenylist = configData10.getWorldDenylist();
        ConfigData configData11 = this.data;
        if (configData11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData11 = null;
        }
        this.bossBar = ConfigurationKt.toBukkitMaps(configData11.getBossBar());
        this.commands = CollectionsKt.emptyList();
        this.permissions = new LinkedHashSet();
        this.groups = new LinkedHashSet();
        this.worldBorder = new WorldBorder(null, null, 3, null);
        this.allowNether = this.plugin.getServer().getAllowNether();
        this.allowEnd = this.plugin.getServer().getAllowEnd();
        ConfigData configData12 = this.data;
        if (configData12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData12 = null;
        }
        Iterable l22 = configData12.getGamemodeDenylist();
        Configuration configuration = this;
        boolean $i$f$map = false;
        level = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GameMode.valueOf((String)it));
        }
        configuration.gamemodeDenylist = (List)destination$iv$iv;
        ConfigData configData13 = this.data;
        if (configData13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData13 = null;
        }
        this.currentLevel = (string = (String)CollectionsKt.firstOrNull((Iterable)configData13.getLevels().keySet())) != null && (string = (String)StringsKt.split$default((CharSequence)string, cArray = new char[]{'-'}, false, 0, 6, null).get(0)) != null ? Integer.parseInt(string) : 0;
        this.neededXP = 0.0;
        this.relativeXP = 0.0;
    }

    public final boolean apply() {
        int oldLevel = this.currentLevel;
        double xpToApply = this.plugin.getSave().getXP();
        double xpRequirement = 0.0;
        int levelStart = 0;
        int levelEnd = 0;
        ConfigData configData = this.data;
        if (configData == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData = null;
        }
        String lastKey = (String)CollectionsKt.firstOrNull((Iterable)configData.getLevels().keySet());
        ConfigData configData2 = this.data;
        if (configData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData2 = null;
        }
        for (Map.Entry<String, LevelData> levelEntry : configData2.getLevels().entrySet()) {
            double d;
            LevelData level = levelEntry.getValue();
            Pair<Integer, Integer> range = ConfigDataKt.parseLevelRange(levelEntry.getKey());
            levelStart = ((Number)range.getFirst()).intValue();
            levelEnd = ((Number)range.getSecond()).intValue();
            Double d2 = level.getXp();
            if (d2 != null) {
                d = d2;
            } else {
                ProceduralStep proceduralStep = level.getXpStep();
                Intrinsics.checkNotNull(proceduralStep);
                d = ConfigurationKt.apply(proceduralStep, xpRequirement);
            }
            this.neededXP = xpRequirement = d;
            for (int levelNum = levelStart; levelEnd == 0 || levelNum <= levelEnd; ++levelNum) {
                List<String> list;
                Map<String, Double> map;
                Object object;
                if (levelNum > levelStart) {
                    double d3;
                    if (level.getXp() != null && level.getXpStep() == null) {
                        d3 = level.getXp();
                    } else {
                        ProceduralStep proceduralStep = level.getXpStep();
                        Intrinsics.checkNotNull(proceduralStep);
                        d3 = ConfigurationKt.apply(proceduralStep, xpRequirement);
                    }
                    xpRequirement = d3;
                }
                this.neededXP = xpRequirement;
                if (xpRequirement > xpToApply) {
                    String string = lastKey;
                    Intrinsics.checkNotNull(string);
                    this.currentLevelKey = string;
                    this.relativeXP = xpToApply;
                    return this.currentLevel > oldLevel;
                }
                xpToApply -= xpRequirement;
                this.currentLevel = levelNum;
                Boolean bl = level.getAllowNether();
                this.allowNether = bl != null ? bl : this.allowNether;
                Boolean bl2 = level.getAllowEnd();
                boolean bl3 = this.allowEnd = bl2 != null ? bl2 : this.allowEnd;
                if (level.getWorldBorder() != null) {
                    WorldBorder worldBorder = this.getWorldBorder();
                    Pos2 pos2 = level.getWorldBorder().getCenter();
                    if (pos2 == null) {
                        pos2 = this.getWorldBorder().getCenter();
                    }
                    worldBorder.setCenter(pos2);
                    if (levelNum == levelStart) {
                        if (level.getWorldBorder().getRadius() != null) {
                            this.getWorldBorder().setRadius(level.getWorldBorder().getRadius());
                        } else if (this.getWorldBorder().getRadius() != null) {
                            WorldBorder worldBorder2 = this.getWorldBorder();
                            ProceduralStep proceduralStep = level.getWorldBorder().getRadiusStep();
                            Intrinsics.checkNotNull(proceduralStep);
                            Double d4 = this.getWorldBorder().getRadius();
                            Intrinsics.checkNotNull(d4);
                            worldBorder2.setRadius(ConfigurationKt.apply(proceduralStep, d4));
                        }
                    } else if (level.getWorldBorder().getRadius() != null && level.getWorldBorder().getRadiusStep() == null) {
                        this.getWorldBorder().setRadius(level.getWorldBorder().getRadius());
                    } else if (this.getWorldBorder().getRadius() != null) {
                        WorldBorder worldBorder3 = this.getWorldBorder();
                        ProceduralStep proceduralStep = level.getWorldBorder().getRadiusStep();
                        Intrinsics.checkNotNull(proceduralStep);
                        Double d5 = this.getWorldBorder().getRadius();
                        Intrinsics.checkNotNull(d5);
                        worldBorder3.setRadius(ConfigurationKt.apply(proceduralStep, d5));
                    }
                }
                if ((object = level.getCustomXPSources()) == null || (object = ConfigurationKt.toBukkitMaps((CustomXPSourceData)object)) == null) {
                    ConfigData configData3 = this.data;
                    if (configData3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("data");
                        configData3 = null;
                    }
                    object = this.customXPSources = ConfigurationKt.toBukkitMaps(configData3.getCustomXPSources());
                }
                if ((map = level.getXpWeights()) == null || (map = ConfigurationKt.weightsToBukkitMap(map)) == null) {
                    ConfigData configData4 = this.data;
                    if (configData4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("data");
                        configData4 = null;
                    }
                    map = this.xpWeights = ConfigurationKt.weightsToBukkitMap(configData4.getWeights());
                }
                if ((list = level.getCommands()) == null) {
                    list = CollectionsKt.emptyList();
                }
                this.commands = list;
                Set<String> set = level.getPermissions();
                this.getPermissions().addAll(set != null ? (Collection)set : (Collection)SetsKt.emptySet());
                Set<String> set2 = level.getGroups();
                this.getGroups().addAll(set2 != null ? (Collection)set2 : (Collection)SetsKt.emptySet());
            }
            lastKey = levelEntry.getKey();
        }
        this.currentLevelKey = lastKey;
        ConfigData configData5 = this.data;
        if (configData5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData5 = null;
        }
        this.relativeXP = Intrinsics.areEqual(this.currentLevelKey, CollectionsKt.last((Iterable)configData5.getLevels().keySet())) && this.currentLevel == levelEnd ? this.neededXP : xpToApply;
        return this.currentLevel > oldLevel;
    }

    public final double levelMin() {
        double xpToApply = this.plugin.getSave().getXP();
        double xpRequirement = 0.0;
        double totalXPRequirement = 0.0;
        int levelStart = 0;
        int levelEnd = 0;
        ConfigData configData = this.data;
        if (configData == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData = null;
        }
        String lastKey = (String)CollectionsKt.firstOrNull((Iterable)configData.getLevels().keySet());
        ConfigData configData2 = this.data;
        if (configData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData2 = null;
        }
        int startIndex = CollectionsKt.indexOf((Iterable)configData2.getLevels().keySet(), lastKey);
        ConfigData configData3 = this.data;
        if (configData3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData3 = null;
        }
        List list = CollectionsKt.toList((Iterable)configData3.getLevels().entrySet());
        ConfigData configData4 = this.data;
        if (configData4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("data");
            configData4 = null;
        }
        for (Map.Entry levelEntry : list.subList(startIndex, configData4.getLevels().entrySet().size())) {
            double d;
            LevelData level = (LevelData)levelEntry.getValue();
            Pair<Integer, Integer> range = ConfigDataKt.parseLevelRange((String)levelEntry.getKey());
            levelStart = ((Number)range.getFirst()).intValue();
            levelEnd = ((Number)range.getSecond()).intValue();
            Double d2 = level.getXp();
            if (d2 != null) {
                d = d2;
            } else {
                ProceduralStep proceduralStep = level.getXpStep();
                Intrinsics.checkNotNull(proceduralStep);
                d = ConfigurationKt.apply(proceduralStep, xpRequirement);
            }
            xpRequirement = d;
            totalXPRequirement += xpRequirement;
            this.neededXP = xpRequirement;
            for (int levelNum = levelStart; levelEnd == 0 || levelNum <= levelEnd; ++levelNum) {
                if (levelNum > levelStart) {
                    double d3;
                    if (level.getXp() != null && level.getXpStep() == null) {
                        d3 = level.getXp();
                    } else {
                        ProceduralStep proceduralStep = level.getXpStep();
                        Intrinsics.checkNotNull(proceduralStep);
                        d3 = ConfigurationKt.apply(proceduralStep, xpRequirement);
                    }
                    xpRequirement = d3;
                    totalXPRequirement += xpRequirement;
                }
                if (levelNum == this.currentLevel) {
                    return totalXPRequirement;
                }
                xpToApply -= xpRequirement;
            }
        }
        return xpRequirement;
    }

    public final boolean setExperience(double xp) {
        double newXP;
        double d = newXP = xp > 0.0 ? xp : 0.0;
        if (xp < 0.0) {
            ConfigData configData = this.data;
            if (configData == null) {
                Intrinsics.throwUninitializedPropertyAccessException("data");
                configData = null;
            }
            if (!configData.getAllowDeleveling()) {
                double minXP = this.levelMin();
                newXP = RangesKt.coerceAtLeast(newXP, minXP);
            }
            this.currentLevelKey = null;
        }
        this.plugin.getSave().setXP(newXP);
        return this.apply();
    }

    public final boolean addExperience(double xp) {
        return this.setExperience(this.plugin.getSave().getXP() + xp);
    }

    public final double getProgress() {
        return Math.clamp(this.relativeXP / this.neededXP, 0.0, 1.0);
    }

    public final boolean worldEnabled(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return !this.getWorldDenylist().contains(world.getName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<Material, Integer>> getItemRewards() {
        void $this$filterTo$iv$iv;
        int n;
        Object item$iv2;
        List list;
        int n2;
        block5: {
            void $this$indexOfFirst$iv;
            List levelList;
            ConfigData configData = this.data;
            if (configData == null) {
                Intrinsics.throwUninitializedPropertyAccessException("data");
                configData = null;
            }
            List list2 = levelList = CollectionsKt.toList((Iterable)configData.getLevels().entrySet());
            n2 = 0;
            list = levelList;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv2 : $this$indexOfFirst$iv) {
                Map.Entry it = (Map.Entry)item$iv2;
                boolean bl = false;
                if (Intrinsics.areEqual(it.getKey(), this.currentLevelKey)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n3 = n;
        List pastLevels = list.subList(n2, n3 + 1);
        Map map = new LinkedHashMap();
        Iterable $this$filter$iv = pastLevels;
        boolean $i$f$filter = false;
        item$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((LevelData)it.getValue()).getItems() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry level : (List)destination$iv$iv) {
            Object k = level.getKey();
            Map<String, Integer> map2 = ((LevelData)level.getValue()).getItems();
            Intrinsics.checkNotNull(map2);
            map.put(k, ConfigurationKt.itemToBukkitMap(map2));
        }
        return map;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/astrelion/worldlevels/config/Configuration$Companion;", "", "<init>", "()V", "FILE_NAME", "", "WorldLevels"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

