/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.SaveData;
import com.astrelion.worldlevels.util.Parser;
import com.google.gson.Gson;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/astrelion/worldlevels/config/Save;", "", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "data", "Lcom/astrelion/worldlevels/config/SaveData;", "load", "", "reload", "save", "getXP", "", "setXP", "xp", "Companion", "WorldLevels"})
public final class Save {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldLevels plugin;
    @NotNull
    private SaveData data;
    @NotNull
    public static final String FILE_NAME = "save.yml";

    public Save(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.data = new SaveData(0.0);
        this.load();
    }

    public final void load() {
        File file = new File(this.plugin.getDataFolder(), FILE_NAME);
        Yaml yaml = Parser.INSTANCE.getYaml();
        Gson gson = Parser.INSTANCE.getGson();
        SaveData defaultSave = new SaveData(0.0);
        Map defaultMap = (Map)gson.fromJson(gson.toJson((Object)defaultSave), Map.class);
        if (file.exists()) {
            Map yamlMap = (Map)yaml.load(FilesKt.readText$default(file, null, 1, null));
            Intrinsics.checkNotNull(defaultMap);
            for (Map.Entry defaultEntry : defaultMap.entrySet()) {
                Object v;
                Intrinsics.checkNotNull(yamlMap);
                if (yamlMap.containsKey(defaultEntry.getKey())) continue;
                Map map = yamlMap;
                Object k = defaultEntry.getKey();
                Intrinsics.checkNotNull(k, "null cannot be cast to non-null type kotlin.String");
                String string = (String)k;
                Intrinsics.checkNotNull(defaultEntry.getValue(), "null cannot be cast to non-null type kotlin.Any");
                map.put(string, v);
                this.plugin.getLogger().log(Level.WARNING, "Missing save key " + defaultEntry.getKey() + ", default inserted");
            }
            String string = yaml.dump((Object)yamlMap);
            Intrinsics.checkNotNullExpressionValue(string, "dump(...)");
            FilesKt.writeText$default(file, string, null, 2, null);
            String json = gson.toJson((Object)yamlMap);
            SaveData newSave = (SaveData)gson.fromJson(json.toString(), SaveData.class);
            Intrinsics.checkNotNull(newSave);
            this.data = newSave;
        } else {
            this.data = defaultSave;
            String newYaml = yaml.dump((Object)defaultMap);
            file.getParentFile().mkdirs();
            Intrinsics.checkNotNull(newYaml);
            FilesKt.writeText$default(file, newYaml, null, 2, null);
        }
    }

    public final void reload() {
        this.load();
    }

    public final void save() {
        Yaml yaml = Parser.INSTANCE.getYaml();
        Gson gson = Parser.INSTANCE.getGson();
        Map map = (Map)gson.fromJson(gson.toJson((Object)this.data), Map.class);
        String yamlString = yaml.dump((Object)map);
        File file = new File(this.plugin.getDataFolder(), FILE_NAME);
        Intrinsics.checkNotNull(yamlString);
        FilesKt.writeText$default(file, yamlString, null, 2, null);
    }

    public final double getXP() {
        return this.data.getXp();
    }

    public final void setXP(double xp) {
        this.data = this.data.copy(xp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/astrelion/worldlevels/config/Save$Companion;", "", "<init>", "()V", "FILE_NAME", "", "WorldLevels"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

