/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.listener;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.Configuration;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/astrelion/worldlevels/listener/PortalEnter;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "getPlugin", "()Lcom/astrelion/worldlevels/WorldLevels;", "onPortalEnterEvent", "", "event", "Lorg/bukkit/event/entity/EntityPortalEnterEvent;", "WorldLevels"})
public final class PortalEnter
implements Listener {
    @NotNull
    private final WorldLevels plugin;

    @NotNull
    public final WorldLevels getPlugin() {
        return this.plugin;
    }

    public PortalEnter(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public final void onPortalEnterEvent(@NotNull EntityPortalEnterEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Configuration configuration = this.plugin.getConfig();
        World world = event.getLocation().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!configuration.worldEnabled(world)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event.getPortalType().ordinal()]) {
            case 1: 
            case 2: {
                if (this.plugin.getConfig().getAllowEnd()) break;
                event.setCancelled(true);
                break;
            }
            case 3: {
                if (this.plugin.getConfig().getAllowNether()) break;
                event.setCancelled(true);
                break;
            }
            default: {
                this.plugin.getLogger().log(Level.FINER, "Unknown portal, skipping checks");
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortalType.values().length];
            try {
                nArray[PortalType.ENDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortalType.END_GATEWAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortalType.NETHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

