/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.listener;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.Configuration;
import com.astrelion.worldlevels.config.Messages;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/astrelion/worldlevels/listener/EventDenial;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "getPlugin", "()Lcom/astrelion/worldlevels/WorldLevels;", "onPortalCreateEvent", "", "event", "Lorg/bukkit/event/world/PortalCreateEvent;", "onCraftItemEvent", "Lorg/bukkit/event/inventory/CraftItemEvent;", "onBlockBreakEvent", "Lorg/bukkit/event/block/BlockBreakEvent;", "onBlockPlaceEvent", "Lorg/bukkit/event/block/BlockPlaceEvent;", "validatePlayer", "", "player", "Lorg/bukkit/entity/Player;", "WorldLevels"})
public final class EventDenial
implements Listener {
    @NotNull
    private final WorldLevels plugin;

    @NotNull
    public final WorldLevels getPlugin() {
        return this.plugin;
    }

    public EventDenial(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public final void onPortalCreateEvent(@NotNull PortalCreateEvent event) {
        block6: {
            Intrinsics.checkNotNullParameter(event, "event");
            Configuration configuration = this.plugin.getConfig();
            World world = event.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            if (!configuration.worldEnabled(world)) {
                return;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[event.getReason().ordinal()]) {
                case 1: {
                    if (this.plugin.getConfig().getAllowEnd()) break;
                    event.setCancelled(true);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.plugin.getConfig().getAllowNether()) break;
                    event.setCancelled(true);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (!event.isCancelled() || !(event.getEntity() instanceof Player) || !this.plugin.getConfig().getDoPortalDenyChat()) break block6;
            Component denyMessage = Messages.parse$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getPortalDeny(), false, 2, null);
            Entity entity = event.getEntity();
            if (entity != null) {
                entity.sendMessage(denyMessage);
            }
        }
    }

    @EventHandler
    public final void onCraftItemEvent(@NotNull CraftItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getInventory().getHolder() == null || !(event.getInventory().getHolder() instanceof Player)) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        Intrinsics.checkNotNull(inventoryHolder, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)inventoryHolder;
        if (!this.validatePlayer(player)) {
            return;
        }
        Material material = event.getRecipe().getResult().getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material item = material;
        if (Intrinsics.areEqual(this.plugin.getConfig().getCrafting().get(item), false)) {
            event.setCancelled(true);
            Component denyMessage = Messages.parse$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getCraftingDeny(), false, 2, null);
            player.sendMessage(denyMessage);
        }
    }

    @EventHandler
    public final void onBlockBreakEvent(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.validatePlayer(player)) {
            return;
        }
        Material material = event.getBlock().getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material block = material;
        if (Intrinsics.areEqual(this.plugin.getConfig().getMining().get(block), false)) {
            event.setCancelled(true);
            Component denyMessage = Messages.parse$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getMiningDeny(), false, 2, null);
            event.getPlayer().sendMessage(denyMessage);
        }
    }

    @EventHandler
    public final void onBlockPlaceEvent(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.validatePlayer(player)) {
            return;
        }
        Material material = event.getBlock().getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material block = material;
        if (Intrinsics.areEqual(this.plugin.getConfig().getPlacing().get(block), false)) {
            event.setCancelled(true);
            Component denyMessage = Messages.parse$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getPlacingDeny(), false, 2, null);
            event.getPlayer().sendMessage(denyMessage);
        }
    }

    private final boolean validatePlayer(Player player) {
        Configuration configuration = this.plugin.getConfig();
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        return configuration.worldEnabled(world) && !this.plugin.getConfig().getGamemodeDenylist().contains(player.getGameMode());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortalCreateEvent.CreateReason.values().length];
            try {
                nArray[PortalCreateEvent.CreateReason.END_PLATFORM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortalCreateEvent.CreateReason.NETHER_PAIR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortalCreateEvent.CreateReason.FIRE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

