/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.listener;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.ApplyResult;
import com.astrelion.worldlevels.config.ConfigDataKt;
import com.astrelion.worldlevels.config.Configuration;
import com.astrelion.worldlevels.config.Messages;
import com.astrelion.worldlevels.config.Pos2;
import com.astrelion.worldlevels.config.TitleData;
import com.astrelion.worldlevels.listener.ExperienceKt;
import com.astrelion.worldlevels.util.Env;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020\u0014J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\"J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(J\b\u0010+\u001a\u00020\u0014H\u0002J\b\u0010,\u001a\u00020\u0014H\u0002J\u0015\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020.H\u0002J\u000e\u00101\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$J\u001b\u00102\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020$04H\u0002\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\u0014H\u0002J\u001b\u00107\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020$04H\u0002\u00a2\u0006\u0002\u00105J\b\u00108\u001a\u00020\u0014H\u0002J \u00109\u001a\u00020\u00142\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\b\b\u0002\u0010=\u001a\u00020.H\u0002J\u0010\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006A"}, d2={"Lcom/astrelion/worldlevels/listener/Experience;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "getPlugin", "()Lcom/astrelion/worldlevels/WorldLevels;", "bossBar", "Lorg/bukkit/boss/KeyedBossBar;", "getBossBar", "()Lorg/bukkit/boss/KeyedBossBar;", "value", "Lio/papermc/paper/threadedregions/scheduler/ScheduledTask;", "bossBarHideTask", "getBossBarHideTask", "()Lio/papermc/paper/threadedregions/scheduler/ScheduledTask;", "saveTask", "getSaveTask", "onPlayerJoinEvent", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerDeathEvent", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onEntityDeathEvent", "Lorg/bukkit/event/entity/EntityDeathEvent;", "onBlockBreakEvent", "Lorg/bukkit/event/block/BlockBreakEvent;", "onPlayerPickupExperienceEvent", "Lcom/destroystokyo/paper/event/player/PlayerPickupExperienceEvent;", "onPlayerAdvancementDoneEvent", "Lorg/bukkit/event/player/PlayerAdvancementDoneEvent;", "validatePlayer", "", "player", "Lorg/bukkit/entity/Player;", "reload", "setExperience", "xp", "", "force", "addExperience", "queueSave", "updateBossBar", "getProcessKey", "", "(Lorg/bukkit/entity/Player;)Ljava/lang/Integer;", "setProcessKey", "removeProcessKey", "rewardItems", "players", "", "([Lorg/bukkit/entity/Player;)V", "runCommands", "ensurePermissions", "updateWorldBorder", "showTitles", "titles", "", "Lcom/astrelion/worldlevels/config/TitleData;", "index", "levelUp", "result", "Lcom/astrelion/worldlevels/config/ApplyResult;", "WorldLevels"})
@SourceDebugExtension(value={"SMAP\nExperience.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Experience.kt\ncom/astrelion/worldlevels/listener/Experience\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,465:1\n188#2,3:466\n360#3,7:469\n37#4,2:476\n*S KotlinDebug\n*F\n+ 1 Experience.kt\ncom/astrelion/worldlevels/listener/Experience\n*L\n141#1:466,3\n323#1:469,7\n449#1:476,2\n*E\n"})
public final class Experience
implements Listener {
    @NotNull
    private final WorldLevels plugin;
    @NotNull
    private final KeyedBossBar bossBar;
    @Nullable
    private ScheduledTask bossBarHideTask;
    @Nullable
    private ScheduledTask saveTask;

    @NotNull
    public final WorldLevels getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final KeyedBossBar getBossBar() {
        return this.bossBar;
    }

    @Nullable
    public final ScheduledTask getBossBarHideTask() {
        return this.bossBarHideTask;
    }

    @Nullable
    public final ScheduledTask getSaveTask() {
        return this.saveTask;
    }

    public Experience(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        KeyedBossBar keyedBossBar = plugin.getServer().createBossBar(new NamespacedKey((Plugin)plugin, "worldBossBar"), "Level 1", plugin.getConfig().getBossBar().getColor(), plugin.getConfig().getBossBar().getStyle(), new BarFlag[0]);
        Intrinsics.checkNotNullExpressionValue(keyedBossBar, "createBossBar(...)");
        this.bossBar = keyedBossBar;
        this.reload();
    }

    @EventHandler
    public final void onPlayerJoinEvent(@NotNull PlayerJoinEvent event) {
        Player[] playerArray;
        boolean newPlayer;
        Intrinsics.checkNotNullParameter(event, "event");
        this.bossBar.addPlayer(event.getPlayer());
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Integer processKey = this.getProcessKey(player);
        boolean bl = newPlayer = processKey == null;
        if (newPlayer && this.plugin.getConfig().getRewardNewPlayers()) {
            playerArray = new Player[1];
            Intrinsics.checkNotNullExpressionValue(event.getPlayer(), "getPlayer(...)");
            this.ensurePermissions(playerArray);
            playerArray = new Player[1];
            Intrinsics.checkNotNullExpressionValue(event.getPlayer(), "getPlayer(...)");
            this.rewardItems(playerArray);
        }
        if (!newPlayer && this.plugin.getConfig().getRewardOfflinePlayers()) {
            playerArray = new Player[1];
            Intrinsics.checkNotNullExpressionValue(event.getPlayer(), "getPlayer(...)");
            this.ensurePermissions(playerArray);
            playerArray = new Player[1];
            Intrinsics.checkNotNullExpressionValue(event.getPlayer(), "getPlayer(...)");
            this.rewardItems(playerArray);
        }
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        this.setProcessKey(player2, this.plugin.getConfig().getCurrentLevel());
        if (this.plugin.getUpdateAvailable() && event.getPlayer().hasPermission("worldlevels.update")) {
            event.getPlayer().sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnUpdateAvailable(), true));
        }
    }

    @EventHandler
    public final void onPlayerDeathEvent(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.validatePlayer(player)) {
            return;
        }
        double experience = this.plugin.getConfig().getCustomXPSources().getPlayerDeath();
        if (!(experience == 0.0)) {
            this.addExperience(experience);
        }
    }

    @EventHandler
    public final void onEntityDeathEvent(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Configuration configuration = this.plugin.getConfig();
        World world = event.getEntity().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        if (!configuration.worldEnabled(world)) {
            return;
        }
        Entity entity = event.getDamageSource().getCausingEntity();
        if ((entity != null ? entity.getType() : null) != EntityType.PLAYER) {
            return;
        }
        Entity entity2 = event.getDamageSource().getCausingEntity();
        Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.Player");
        if (!this.validatePlayer((Player)entity2)) {
            return;
        }
        Double experience = this.plugin.getConfig().getCustomXPSources().getPlayerKill().get(event.getEntity().getType());
        if (experience != null && experience > 0.0) {
            this.addExperience(experience);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onBlockBreakEvent(@NotNull BlockBreakEvent event) {
        Double experience;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.validatePlayer(player)) {
            return;
        }
        if (this.plugin.getConfig().getCustomXPSources().getMineIgnoresSilkTouch()) {
            boolean hasSilkTouch;
            block7: {
                ItemStack itemStack = event.getPlayer().getEquipment().getItemInMainHand();
                Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
                ItemStack tool = itemStack;
                Map map = tool.getEnchantments();
                Intrinsics.checkNotNullExpressionValue(map, "getEnchantments(...)");
                Map $this$any$iv = map;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    v3 = false;
                } else {
                    Iterator iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator2.next();
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getKey(), Enchantment.SILK_TOUCH)) continue;
                        v3 = true;
                        break block7;
                    }
                    v3 = hasSilkTouch = false;
                }
            }
            if (hasSilkTouch) {
                return;
            }
        }
        if ((experience = this.plugin.getConfig().getCustomXPSources().getPlayerMine().get(event.getBlock().getType())) != null && experience > 0.0) {
            this.addExperience(experience);
        }
    }

    @EventHandler
    public final void onPlayerPickupExperienceEvent(@NotNull PlayerPickupExperienceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.validatePlayer(player)) {
            return;
        }
        double experience = event.getExperienceOrb().getExperience();
        Double d = this.plugin.getConfig().getXpWeights().get(event.getExperienceOrb().getSpawnReason());
        this.addExperience(experience *= d != null ? d : 1.0);
    }

    @EventHandler
    public final void onPlayerAdvancementDoneEvent(@NotNull PlayerAdvancementDoneEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.validatePlayer(player)) {
            return;
        }
        Key key = event.getAdvancement().key();
        Intrinsics.checkNotNullExpressionValue(key, "key(...)");
        Key key2 = key;
        Double amount = this.plugin.getConfig().getCustomXPSources().getPlayerAdvancement().get(key2.toString());
        if (amount == null) {
            amount = this.plugin.getConfig().getCustomXPSources().getPlayerAdvancement().get("DEFAULT");
        }
        if (amount != null) {
            this.addExperience(amount);
        }
    }

    private final boolean validatePlayer(Player player) {
        Configuration configuration = this.plugin.getConfig();
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        return configuration.worldEnabled(world) && !this.plugin.getConfig().getGamemodeDenylist().contains(player.getGameMode()) && !player.hasPermission("worldlevels.earn.exempt");
    }

    public final void reload() {
        this.bossBar.setColor(this.plugin.getConfig().getBossBar().getColor());
        this.bossBar.setStyle(this.plugin.getConfig().getBossBar().getStyle());
        this.updateBossBar();
        this.updateWorldBorder();
    }

    public final void setExperience(double xp, boolean force) {
        ApplyResult levelUp = this.plugin.getConfig().setExperience(xp, force);
        this.updateBossBar();
        if (levelUp.getLeveledUp()) {
            this.levelUp(levelUp);
        }
        if (xp < 0.0) {
            this.updateWorldBorder();
        }
        this.queueSave();
    }

    public static /* synthetic */ void setExperience$default(Experience experience, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        experience.setExperience(d, bl);
    }

    public final void addExperience(double xp) {
        ApplyResult levelUp = this.plugin.getConfig().addExperience(xp);
        this.updateBossBar();
        if (levelUp.getLeveledUp()) {
            this.levelUp(levelUp);
        }
        if (xp < 0.0) {
            this.updateWorldBorder();
        }
        this.queueSave();
    }

    private final void queueSave() {
        if (Env.INSTANCE.isTest()) {
            this.plugin.getSave().save();
            this.saveTask = null;
            return;
        }
        if (this.saveTask == null) {
            this.saveTask = this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, arg_0 -> Experience.queueSave$lambda$0(this, arg_0), 20L);
        }
    }

    private final void updateBossBar() {
        String text = Messages.parsePlain$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getBossBar(), false, 2, null);
        this.bossBar.setTitle(text);
        this.bossBar.setProgress(this.plugin.getConfig().getProgress());
        boolean shouldShow = this.bossBar.getProgress() >= this.plugin.getConfig().getBossBar().getShowThreshold();
        this.bossBar.setVisible(shouldShow && this.plugin.getConfig().getBossBar().getEnabled());
        if (this.plugin.getConfig().getBossBar().getInactiveHideDelay() > 0.0) {
            ScheduledTask scheduledTask = this.bossBarHideTask;
            if (scheduledTask != null) {
                scheduledTask.cancel();
            }
            this.bossBarHideTask = this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, arg_0 -> Experience.updateBossBar$lambda$0(this, arg_0), (long)(this.plugin.getConfig().getBossBar().getInactiveHideDelay() * (double)20));
        }
    }

    @Nullable
    public final Integer getProcessKey(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        NamespacedKey processKey = new NamespacedKey((Plugin)this.plugin, "level");
        return (Integer)player.getPersistentDataContainer().get(processKey, PersistentDataType.INTEGER);
    }

    private final void setProcessKey(Player player, int value) {
        NamespacedKey processKey = new NamespacedKey((Plugin)this.plugin, "level");
        player.getPersistentDataContainer().set(processKey, PersistentDataType.INTEGER, (Object)value);
    }

    public final void removeProcessKey(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        NamespacedKey processKey = new NamespacedKey((Plugin)this.plugin, "level");
        player.getPersistentDataContainer().remove(processKey);
    }

    private final void rewardItems(Player[] players) {
        List rewards = CollectionsKt.toList((Iterable)this.plugin.getConfig().getItemRewards().entrySet());
        for (Player player : players) {
            int lastReward;
            block8: {
                Integer levelKey = this.getProcessKey(player);
                if (levelKey == null) {
                    v0 = 0;
                } else {
                    List $this$indexOfFirst$iv = rewards;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object t : $this$indexOfFirst$iv) {
                        Map.Entry m = (Map.Entry)t;
                        boolean bl = false;
                        if (ConfigDataKt.withinLevelRange((String)m.getKey(), levelKey)) {
                            v0 = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    v0 = lastReward = -1;
                }
            }
            if (lastReward >= 0 && lastReward < rewards.size()) {
                for (Map.Entry diff : rewards.subList(lastReward + 1, rewards.size())) {
                    Map items = (Map)diff.getValue();
                    for (Map.Entry entry : items.entrySet()) {
                        Item item2;
                        ItemStack itemStack;
                        Intrinsics.checkNotNullExpressionValue(ItemStack.of((Material)((Material)entry.getKey()), (int)((Number)entry.getValue()).intValue()), "of(...)");
                        Intrinsics.checkNotNullExpressionValue(player.getWorld().dropItem(player.getLocation().add(new Vector(0, 1, 0)), itemStack), "dropItem(...)");
                        item2.setPickupDelay(0);
                    }
                }
            }
            this.setProcessKey(player, this.plugin.getConfig().getCurrentLevel());
        }
    }

    private final void runCommands() {
        for (String command : this.plugin.getConfig().getCommands()) {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command);
        }
    }

    private final void ensurePermissions(Player[] players) {
        if (!this.plugin.hasVault()) {
            return;
        }
        for (Player player : players) {
            for (String permission : this.plugin.getConfig().getPermissions()) {
                Permission permission2 = this.plugin.getVaultPermissions();
                if (permission2 != null ? permission2.has(player, permission) : false) continue;
                Permission permission3 = this.plugin.getVaultPermissions();
                if (permission3 == null) continue;
                permission3.playerAdd(null, (OfflinePlayer)player, permission);
            }
            for (String group : this.plugin.getConfig().getGroups()) {
                Permission permission = this.plugin.getVaultPermissions();
                if (permission != null ? permission.playerInGroup(player, group) : false) continue;
                Permission permission4 = this.plugin.getVaultPermissions();
                if (permission4 == null) continue;
                permission4.playerAddGroup(null, (OfflinePlayer)player, group);
            }
        }
    }

    private final void updateWorldBorder() {
        for (World world : this.plugin.getServer().getWorlds()) {
            if (this.plugin.getConfig().getWorldBorder().getRadius() != null) {
                WorldBorder worldBorder = world.getWorldBorder();
                Double d = this.plugin.getConfig().getWorldBorder().getRadius();
                Intrinsics.checkNotNull(d);
                worldBorder.setSize(d * 2.0, 1L);
            }
            if (this.plugin.getConfig().getWorldBorder().getCenter() == null) continue;
            WorldBorder worldBorder = world.getWorldBorder();
            Pos2 pos2 = this.plugin.getConfig().getWorldBorder().getCenter();
            Intrinsics.checkNotNull(pos2);
            double d = pos2.getX();
            Pos2 pos22 = this.plugin.getConfig().getWorldBorder().getCenter();
            Intrinsics.checkNotNull(pos22);
            worldBorder.setCenter(d, pos22.getZ());
        }
    }

    private final void showTitles(List<TitleData> titles, int index) {
        Component component;
        Component title;
        if (titles.get(index).getTitle() != null) {
            Messages messages = this.plugin.getMessages();
            String string = titles.get(index).getTitle();
            Intrinsics.checkNotNull(string);
            v2 = Messages.parse$default(messages, string, false, 2, null);
        } else {
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
            v2 = title = (Component)textComponent;
        }
        if (titles.get(index).getSubtitle() != null) {
            Messages messages = this.plugin.getMessages();
            String string = titles.get(index).getSubtitle();
            Intrinsics.checkNotNull(string);
            component = Messages.parse$default(messages, string, false, 2, null);
        } else {
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
            component = (Component)textComponent;
        }
        Component subtitle = component;
        Title title2 = Title.title((Component)title, (Component)subtitle);
        Intrinsics.checkNotNullExpressionValue(title2, "title(...)");
        Title adventureTitle = title2;
        this.plugin.getServer().showTitle(adventureTitle);
        if (index < titles.size() - 1) {
            Title.Times times = adventureTitle.times();
            this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, arg_0 -> Experience.showTitles$lambda$0(this, titles, index, arg_0), times != null ? ExperienceKt.access$ticks(times) : 0L);
        }
    }

    static /* synthetic */ void showTitles$default(Experience experience, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        experience.showTitles(list, n);
    }

    private final void levelUp(ApplyResult result) {
        List titles;
        if (this.plugin.getConfig().getDoLevelUpChat()) {
            Component chat = this.plugin.getMessages().parse(this.plugin.getMessages().getData().getLevelUpChat(), true);
            this.plugin.getServer().sendMessage(chat);
        }
        long titleDelay = 0L;
        if (this.plugin.getConfig().getDoLevelUpTitle()) {
            Component title = Messages.parse$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getLevelUpTitle(), false, 2, null);
            Component subtitle = Messages.parse$default(this.plugin.getMessages(), this.plugin.getMessages().getData().getLevelUpSubtitle(), false, 2, null);
            Title title2 = Title.title((Component)title, (Component)subtitle);
            Intrinsics.checkNotNullExpressionValue(title2, "title(...)");
            Title adventureTitle = title2;
            if (!Env.INSTANCE.isTest()) {
                this.plugin.getServer().showTitle(adventureTitle);
            }
            Title.Times times = adventureTitle.times();
            titleDelay = times != null ? ExperienceKt.access$ticks(times) : 0L;
        }
        if (!((Collection)(titles = CollectionsKt.toList((Iterable)this.plugin.getConfig().getTitles()))).isEmpty()) {
            this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, arg_0 -> Experience.levelUp$lambda$0(this, titles, arg_0), titleDelay);
        }
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Player[] onlinePlayers = thisCollection$iv.toArray(new Player[0]);
        this.updateWorldBorder();
        this.runCommands();
        this.rewardItems(onlinePlayers);
        this.ensurePermissions(onlinePlayers);
    }

    private static final void queueSave$lambda$0(Experience this$0, ScheduledTask it) {
        this$0.plugin.getSave().save();
        this$0.saveTask = null;
    }

    private static final void updateBossBar$lambda$0(Experience this$0, ScheduledTask it) {
        this$0.bossBar.setVisible(false);
        this$0.bossBarHideTask = null;
    }

    private static final void showTitles$lambda$0(Experience this$0, List $titles, int $index, ScheduledTask it) {
        this$0.showTitles($titles, $index + 1);
    }

    private static final void levelUp$lambda$0(Experience this$0, List $titles, ScheduledTask it) {
        Experience.showTitles$default(this$0, $titles, 0, 2, null);
    }
}

