/*
 * Decompiled with CFR 0.152.
 */
package build.worldlevels.acf.lib.util;

import build.worldlevels.acf.lib.util.DelegatingMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public class Table<R, C, V>
implements Iterable<Entry<R, C, V>> {
    private final Map<R, Map<C, V>> rowMap;
    private final Function<R, Map<C, V>> colMapSupplier;

    public Table() {
        this(new HashMap(), HashMap::new);
    }

    public Table(Supplier<Map<C, V>> columnMapSupplier) {
        this(new HashMap(), columnMapSupplier);
    }

    public Table(Map<R, Map<C, V>> backingRowMap, Supplier<Map<C, V>> columnMapSupplier) {
        this(backingRowMap, (R r) -> (Map)columnMapSupplier.get());
    }

    public Table(Map<R, Map<C, V>> backingRowMap, Function<R, Map<C, V>> columnMapSupplier) {
        this.rowMap = backingRowMap;
        this.colMapSupplier = columnMapSupplier;
    }

    public V get(R row, C col) {
        return this.getIfExists(row, col);
    }

    public V getOrDefault(R row, C col, V def) {
        Map<C, V> colMap = this.getColMapIfExists(row);
        if (colMap == null) {
            return def;
        }
        V v = colMap.get(col);
        if (v != null || colMap.containsKey(col)) {
            return v;
        }
        return def;
    }

    public boolean containsKey(R row, C col) {
        Map<C, V> colMap = this.getColMapIfExists(row);
        if (colMap == null) {
            return false;
        }
        return colMap.containsKey(col);
    }

    @Nullable
    public V put(R row, C col, V val) {
        return this.getColMapForWrite(row).put(col, val);
    }

    public void forEach(TableConsumer<R, C, V> consumer) {
        for (Entry<R, C, V> entry : this) {
            consumer.accept(entry.getRow(), entry.getCol(), entry.getValue());
        }
    }

    public void forEach(TablePredicate<R, C, V> predicate) {
        for (Entry<R, C, V> entry : this) {
            if (predicate.test(entry.getRow(), entry.getCol(), entry.getValue())) continue;
            return;
        }
    }

    public void removeIf(TablePredicate<R, C, V> predicate) {
        Iterator<Entry<R, C, V>> it = this.iterator();
        while (it.hasNext()) {
            Entry<R, C, V> entry = it.next();
            if (!predicate.test(entry.getRow(), entry.getCol(), entry.getValue())) continue;
            it.remove();
        }
    }

    public Stream<Entry<R, C, V>> stream() {
        return this.stream(false);
    }

    public Stream<Entry<R, C, V>> stream(boolean parallel) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), parallel);
    }

    @Override
    public Iterator<Entry<R, C, V>> iterator() {
        return new Iterator<Entry<R, C, V>>(){
            Iterator<Map.Entry<R, Map<C, V>>> rowIter;
            Iterator<Map.Entry<C, V>> colIter;
            private Map.Entry<R, Map<C, V>> rowEntry;
            private Map.Entry<C, V> colEntry;
            private Entry<R, C, V> next;
            {
                this.rowIter = Table.this.rowMap.entrySet().iterator();
                this.colIter = null;
                this.next = this.getNext();
            }

            private Entry<R, C, V> getNext() {
                if (this.colIter == null || !this.colIter.hasNext()) {
                    if (!this.rowIter.hasNext()) {
                        return null;
                    }
                    this.rowEntry = this.rowIter.next();
                    this.colIter = this.rowEntry.getValue().entrySet().iterator();
                }
                if (!this.colIter.hasNext()) {
                    return null;
                }
                this.colEntry = this.colIter.next();
                return new Node(this.rowEntry, this.colEntry);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Entry<R, C, V> next() {
                Entry entry = this.next;
                this.next = this.getNext();
                return entry;
            }

            @Override
            public void remove() {
                this.colIter.remove();
            }
        };
    }

    public void replaceAll(TableFunction<R, C, V, V> function) {
        for (Entry<R, C, V> entry : this) {
            entry.setValue(function.compose(entry.getRow(), entry.getCol(), entry.getValue()));
        }
    }

    public V remove(R row, C col) {
        Map<C, V> rowMap = this.rowMap.get(row);
        if (rowMap == null) {
            return null;
        }
        return rowMap.remove(col);
    }

    @Nullable
    public V replace(R row, C col, V val) {
        Map<C, V> rowMap = this.getColMapIfExists(row);
        if (rowMap == null) {
            return null;
        }
        if (rowMap.get(col) != null || rowMap.containsKey(col)) {
            return rowMap.put(col, val);
        }
        return null;
    }

    @Nullable
    public boolean replace(R row, C col, V old, V val) {
        Map<C, V> rowMap = this.getColMapIfExists(row);
        if (rowMap == null) {
            return false;
        }
        if (Objects.equals(rowMap.get(col), old)) {
            rowMap.put(col, val);
            return true;
        }
        return false;
    }

    public V computeIfAbsent(R row, C col, BiFunction<R, C, V> function) {
        return (V)this.getColMapForWrite(row).computeIfAbsent(col, c -> function.apply(row, col));
    }

    public V computeIfPresent(R row, C col, TableFunction<R, C, V, V> function) {
        Map<C, Object> colMap = this.getColMapForWrite(row);
        Object v = colMap.computeIfPresent(col, (c, old) -> function.compose(row, col, old));
        this.removeIfEmpty(row, colMap);
        return (V)v;
    }

    public V compute(R row, C col, TableFunction<R, C, V, V> function) {
        Map<C, Object> colMap = this.getColMapForWrite(row);
        Object v = colMap.compute(col, (c, old) -> function.compose(row, col, old));
        this.removeIfEmpty(row, colMap);
        return (V)v;
    }

    public V merge(R row, C col, V val, TableFunction<R, C, V, V> function) {
        Map<C, Object> colMap = this.getColMapForWrite(row);
        Object v = colMap.merge(col, val, (c, old) -> function.compose(row, col, old));
        this.removeIfEmpty(row, colMap);
        return (V)v;
    }

    public Map<C, V> row(final R row) {
        final HashMap EMPTY = new HashMap(0);
        return new DelegatingMap<C, V>(){

            @Override
            public Map<C, V> delegate(boolean readOnly) {
                if (readOnly) {
                    return Table.this.rowMap.getOrDefault(row, EMPTY);
                }
                return Table.this.getColMapForWrite(row);
            }

            @Override
            public V remove(Object key) {
                Map delegate = this.delegate(false);
                Object remove = delegate.remove(key);
                Table.this.removeIfEmpty(row, delegate);
                return remove;
            }
        };
    }

    private V getIfExists(R row, C col) {
        Map<C, V> colMap = this.getColMapIfExists(row);
        if (colMap == null) {
            return null;
        }
        return colMap.get(col);
    }

    private Map<C, V> getColMapIfExists(R row) {
        Map<C, V> colMap = this.rowMap.get(row);
        if (colMap != null && colMap.isEmpty()) {
            this.rowMap.remove(row);
            colMap = null;
        }
        return colMap;
    }

    private Map<C, V> getColMapForWrite(R row) {
        return this.rowMap.computeIfAbsent(row, this.colMapSupplier);
    }

    private void removeIfEmpty(R row, Map<C, V> colMap) {
        if (colMap.isEmpty()) {
            this.rowMap.remove(row);
        }
    }

    private class Node
    implements Entry<R, C, V> {
        private final Map.Entry<R, Map<C, V>> rowEntry;
        private final Map.Entry<C, V> colEntry;

        Node(Map.Entry<R, Map<C, V>> rowEntry, Map.Entry<C, V> entry) {
            this.rowEntry = rowEntry;
            this.colEntry = entry;
        }

        @Override
        public final R getRow() {
            return this.rowEntry.getKey();
        }

        @Override
        public final C getCol() {
            return this.colEntry.getKey();
        }

        @Override
        public final V getValue() {
            return this.colEntry.getValue();
        }

        @Override
        public final V setValue(V value) {
            return this.colEntry.setValue(value);
        }
    }

    public static interface Entry<R, C, V> {
        public R getRow();

        public C getCol();

        public V getValue();

        public V setValue(V var1);
    }

    public static interface TableConsumer<R, C, V> {
        public void accept(R var1, C var2, V var3);
    }

    public static interface TableFunction<R, C, V, RETURN> {
        public RETURN compose(R var1, C var2, V var3);
    }

    public static interface TablePredicate<R, C, V> {
        public boolean test(R var1, C var2, V var3);
    }
}

