/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.DataFile;
import com.astrelion.worldlevels.config.MessageData;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0011\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/astrelion/worldlevels/config/Messages;", "", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "dataFile", "Lcom/astrelion/worldlevels/config/DataFile;", "Lcom/astrelion/worldlevels/config/MessageData;", "getDataFile", "()Lcom/astrelion/worldlevels/config/DataFile;", "data", "getData", "()Lcom/astrelion/worldlevels/config/MessageData;", "mini", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "getMini", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "plain", "Lnet/kyori/adventure/text/serializer/plain/PlainTextComponentSerializer;", "getPlain", "()Lnet/kyori/adventure/text/serializer/plain/PlainTextComponentSerializer;", "load", "", "reload", "replacements", "", "Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "()[Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "parse", "Lnet/kyori/adventure/text/Component;", "message", "", "withPrefix", "", "parsePlain", "Companion", "WorldLevels"})
public final class Messages {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFile<MessageData> dataFile;
    @NotNull
    private final MiniMessage mini;
    @NotNull
    private final PlainTextComponentSerializer plain;
    @NotNull
    private final WorldLevels plugin;
    @NotNull
    public static final String FILE_NAME = "messages.yml";

    @NotNull
    public final DataFile<MessageData> getDataFile() {
        return this.dataFile;
    }

    @NotNull
    public final MessageData getData() {
        return this.dataFile.getData();
    }

    @NotNull
    public final MiniMessage getMini() {
        return this.mini;
    }

    @NotNull
    public final PlainTextComponentSerializer getPlain() {
        return this.plain;
    }

    public Messages(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
        this.mini = miniMessage;
        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
        Intrinsics.checkNotNullExpressionValue(plainTextComponentSerializer, "plainText(...)");
        this.plain = plainTextComponentSerializer;
        this.plugin = plugin;
        File file = new File(plugin.getDataFolder(), FILE_NAME);
        this.dataFile = new DataFile<MessageData>(MessageData.class, file);
        this.dataFile.setLeadingText("These messages utilize MiniMessage formatting: https://docs.papermc.io/adventure/minimessage");
        this.load();
    }

    public final void load() {
        if (this.dataFile.exists()) {
            this.dataFile.load(new MessageData(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null));
        } else {
            this.dataFile.save(new MessageData(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null));
        }
    }

    public final void reload() {
        this.load();
    }

    @NotNull
    public final TagResolver[] replacements() {
        TagResolver[] tagResolverArray = new TagResolver[7];
        Intrinsics.checkNotNullExpressionValue(Placeholder.component((String)"level", (ComponentLike)((ComponentLike)Component.text((String)String.valueOf(this.plugin.getConfig().getCurrentLevel())))), "component(...)");
        String string = "%.2f";
        Object[] objectArray = new Object[]{this.plugin.getConfig().getRelativeXP()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.component((String)"relative_xp", (ComponentLike)((ComponentLike)Component.text((String)string2))), "component(...)");
        string = "%.2f";
        objectArray = new Object[]{this.plugin.getConfig().getNeededXP()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.component((String)"level_xp", (ComponentLike)((ComponentLike)Component.text((String)string3))), "component(...)");
        string = "%.2f";
        objectArray = new Object[]{this.plugin.getSave().getXP()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.component((String)"total_xp", (ComponentLike)((ComponentLike)Component.text((String)string4))), "component(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.component((String)"version", (ComponentLike)((ComponentLike)Component.text((String)this.plugin.getPluginMeta().getVersion()))), "component(...)");
        Intrinsics.checkNotNullExpressionValue(Placeholder.component((String)"modrinth", (ComponentLike)((ComponentLike)Component.text((String)("https://modrinth.com/plugin/" + this.plugin.getModrinthSlug())))), "component(...)");
        Intrinsics.checkNotNullExpressionValue(TagResolver.resolver((String)"click-modrinth", (arg_0, arg_1) -> Messages.replacements$lambda$0(this, arg_0, arg_1)), "resolver(...)");
        return tagResolverArray;
    }

    @NotNull
    public final Component parse(@NotNull String message, boolean withPrefix) {
        Intrinsics.checkNotNullParameter(message, "message");
        TagResolver[] tagResolverArray = this.replacements();
        Component component = this.mini.deserialize(message, Arrays.copyOf(tagResolverArray, tagResolverArray.length));
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        Component deserialized = component;
        if (withPrefix) {
            tagResolverArray = this.replacements();
            Component component2 = this.mini.deserialize(this.getData().getPrefix(), Arrays.copyOf(tagResolverArray, tagResolverArray.length)).append(deserialized);
            Intrinsics.checkNotNullExpressionValue(component2, "append(...)");
            return component2;
        }
        return deserialized;
    }

    public static /* synthetic */ Component parse$default(Messages messages, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return messages.parse(string, bl);
    }

    @NotNull
    public final String parsePlain(@NotNull String message, boolean withPrefix) {
        Intrinsics.checkNotNullParameter(message, "message");
        Component component = this.parse(message, withPrefix);
        String string = this.plain.serialize(component);
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        return string;
    }

    public static /* synthetic */ String parsePlain$default(Messages messages, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return messages.parsePlain(string, bl);
    }

    private static final Tag replacements$lambda$0(Messages this$0, ArgumentQueue argumentQueue, Context context) {
        StyleBuilderApplicable[] styleBuilderApplicableArray = new StyleBuilderApplicable[]{ClickEvent.openUrl((String)("https://modrinth.com/plugin/" + this$0.plugin.getModrinthSlug()))};
        return Tag.styling((StyleBuilderApplicable[])styleBuilderApplicableArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/astrelion/worldlevels/config/Messages$Companion;", "", "<init>", "()V", "FILE_NAME", "", "WorldLevels"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

