/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import com.astrelion.worldlevels.config.Ref;
import io.github.smiley4.schemakenerator.core.annotations.Description;
import io.github.smiley4.schemakenerator.core.annotations.Min;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J;\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\bH\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u0012R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\r\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/astrelion/worldlevels/config/BossBarData;", "", "enabled", "", "showThreshold", "", "inactiveHideDelay", "color", "", "style", "<init>", "(ZDDLjava/lang/String;Ljava/lang/String;)V", "getEnabled$annotations", "()V", "getEnabled", "()Z", "getShowThreshold$annotations", "getShowThreshold", "()D", "getInactiveHideDelay$annotations", "getInactiveHideDelay", "getColor$annotations", "getColor", "()Ljava/lang/String;", "getStyle$annotations", "getStyle", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "WorldLevels"})
public final class BossBarData {
    private final boolean enabled;
    private final double showThreshold;
    private final double inactiveHideDelay;
    @Ref(ref="https://astrelion.gitlab.io/craft-schemas/latest/BarColor.json")
    @NotNull
    private final String color;
    @Ref(ref="https://astrelion.gitlab.io/craft-schemas/latest/BarStyle.json")
    @NotNull
    private final String style;

    public BossBarData(boolean enabled, double showThreshold, double inactiveHideDelay, @NotNull String color, @NotNull String style) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(style, "style");
        this.enabled = enabled;
        this.showThreshold = showThreshold;
        this.inactiveHideDelay = inactiveHideDelay;
        this.color = color;
        this.style = style;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @Description(description="Whether to enable the boss bar or not")
    public static /* synthetic */ void getEnabled$annotations() {
    }

    public final double getShowThreshold() {
        return this.showThreshold;
    }

    @Description(description="Percentage threshold before the boss bar should be shown. 0.0 = always shown")
    @Min(value=0L)
    public static /* synthetic */ void getShowThreshold$annotations() {
    }

    public final double getInactiveHideDelay() {
        return this.inactiveHideDelay;
    }

    @Description(description="Delay in seconds to hide the boss bar after it becomes inactive. 0.0 = never hide")
    @Min(value=0L)
    public static /* synthetic */ void getInactiveHideDelay$annotations() {
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    @Description(description="Boss bar color")
    public static /* synthetic */ void getColor$annotations() {
    }

    @NotNull
    public final String getStyle() {
        return this.style;
    }

    @Description(description="Boss bar style")
    public static /* synthetic */ void getStyle$annotations() {
    }

    public final boolean component1() {
        return this.enabled;
    }

    public final double component2() {
        return this.showThreshold;
    }

    public final double component3() {
        return this.inactiveHideDelay;
    }

    @NotNull
    public final String component4() {
        return this.color;
    }

    @NotNull
    public final String component5() {
        return this.style;
    }

    @NotNull
    public final BossBarData copy(boolean enabled, double showThreshold, double inactiveHideDelay, @NotNull String color, @NotNull String style) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(style, "style");
        return new BossBarData(enabled, showThreshold, inactiveHideDelay, color, style);
    }

    public static /* synthetic */ BossBarData copy$default(BossBarData bossBarData, boolean bl, double d, double d2, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bossBarData.enabled;
        }
        if ((n & 2) != 0) {
            d = bossBarData.showThreshold;
        }
        if ((n & 4) != 0) {
            d2 = bossBarData.inactiveHideDelay;
        }
        if ((n & 8) != 0) {
            string = bossBarData.color;
        }
        if ((n & 0x10) != 0) {
            string2 = bossBarData.style;
        }
        return bossBarData.copy(bl, d, d2, string, string2);
    }

    @NotNull
    public String toString() {
        return "BossBarData(enabled=" + this.enabled + ", showThreshold=" + this.showThreshold + ", inactiveHideDelay=" + this.inactiveHideDelay + ", color=" + this.color + ", style=" + this.style + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.enabled);
        result = result * 31 + Double.hashCode(this.showThreshold);
        result = result * 31 + Double.hashCode(this.inactiveHideDelay);
        result = result * 31 + this.color.hashCode();
        result = result * 31 + this.style.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BossBarData)) {
            return false;
        }
        BossBarData bossBarData = (BossBarData)other;
        if (this.enabled != bossBarData.enabled) {
            return false;
        }
        if (Double.compare(this.showThreshold, bossBarData.showThreshold) != 0) {
            return false;
        }
        if (Double.compare(this.inactiveHideDelay, bossBarData.inactiveHideDelay) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.color, bossBarData.color)) {
            return false;
        }
        return Intrinsics.areEqual(this.style, bossBarData.style);
    }
}

