/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u0001\u001a\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000*\"\u0010\u0003\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004*\"\u0010\u0006\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00042\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0004*\"\u0010\b\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u00042\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u0004*\n\u0010\n\"\u00020\u00012\u00020\u0001\u00a8\u0006\u0010"}, d2={"CONFIG_SCHEMA_URL", "", "SCHEMA_VERSION", "WeightsMap", "", "", "ItemMap", "", "CraftingMap", "", "LevelRange", "parseLevelRange", "Lkotlin/Pair;", "range", "withinLevelRange", "num", "WorldLevels"})
public final class ConfigDataKt {
    @NotNull
    public static final String CONFIG_SCHEMA_URL = "https://gitlab.com/ASTRELION/worldlevels/-/raw/main/src/main/resources/config-schema.json";
    @NotNull
    public static final String SCHEMA_VERSION = "latest";

    @NotNull
    public static final Pair<Integer, Integer> parseLevelRange(@NotNull String range) {
        int levelStart;
        Intrinsics.checkNotNullParameter(range, "range");
        char[] cArray = new char[]{'-'};
        List range2 = StringsKt.split$default((CharSequence)range, cArray, false, 0, 6, null);
        int levelEnd = levelStart = Integer.parseInt((String)range2.get(0));
        if (range2.size() > 1) {
            Integer n = StringsKt.toIntOrNull((String)range2.get(1));
            levelEnd = n != null ? n : Integer.MAX_VALUE;
        }
        return TuplesKt.to(levelStart, levelEnd);
    }

    public static final boolean withinLevelRange(@NotNull String range, int num) {
        Intrinsics.checkNotNullParameter(range, "range");
        Pair<Integer, Integer> pair = ConfigDataKt.parseLevelRange(range);
        int min = ((Number)pair.component1()).intValue();
        int max = ((Number)pair.component2()).intValue();
        return min <= num ? num <= max : false;
    }
}

