/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.command;

import build.worldlevels.acf.BaseCommand;
import build.worldlevels.acf.CommandHelp;
import build.worldlevels.acf.annotation.CommandAlias;
import build.worldlevels.acf.annotation.CommandPermission;
import build.worldlevels.acf.annotation.Default;
import build.worldlevels.acf.annotation.Description;
import build.worldlevels.acf.annotation.HelpCommand;
import build.worldlevels.acf.annotation.Subcommand;
import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.listener.Experience;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandAlias(value="%base")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/astrelion/worldlevels/command/WLBaseCommand;", "Lbuild/worldlevels/acf/BaseCommand;", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "getPlugin", "()Lcom/astrelion/worldlevels/WorldLevels;", "doHelp", "", "sender", "Lorg/bukkit/command/CommandSender;", "help", "Lbuild/worldlevels/acf/CommandHelp;", "doReload", "onXPGet", "onXPAdd", "xp", "", "onXPSet", "onUpdate", "onVersion", "onResetAll", "onResetRewards", "player", "Lorg/bukkit/entity/Player;", "WorldLevels"})
@SourceDebugExtension(value={"SMAP\nWLBaseCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WLBaseCommand.kt\ncom/astrelion/worldlevels/command/WLBaseCommand\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,164:1\n37#2,2:165\n37#2,2:167\n*S KotlinDebug\n*F\n+ 1 WLBaseCommand.kt\ncom/astrelion/worldlevels/command/WLBaseCommand\n*L\n129#1:165,2\n151#1:167,2\n*E\n"})
public final class WLBaseCommand
extends BaseCommand {
    @NotNull
    private final WorldLevels plugin;

    @NotNull
    public final WorldLevels getPlugin() {
        return this.plugin;
    }

    public WLBaseCommand(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @Default
    @HelpCommand
    @Description(value="Show help")
    @CommandPermission(value="worldlevels.help")
    public final void doHelp(@NotNull CommandSender sender, @NotNull CommandHelp help) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(help, "help");
        help.showHelp();
    }

    @Subcommand(value="reload")
    @Description(value="Reload plugin configuration")
    @CommandPermission(value="worldlevels.reload")
    public final void doReload(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        this.plugin.reload();
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnReload(), true));
    }

    @Subcommand(value="xp")
    @Description(value="Get XP")
    @CommandPermission(value="worldlevels.xp|worldlevels.xp.get")
    public final void onXPGet(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnXPGet(), true));
    }

    @Subcommand(value="xp add")
    @Description(value="Add XP")
    @CommandPermission(value="worldlevels.xp|worldlevels.xp.add")
    public final void onXPAdd(@NotNull CommandSender sender, double xp) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        this.plugin.getExperience().addExperience(xp);
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }

    @Subcommand(value="xp set")
    @Description(value="Add XP")
    @CommandPermission(value="worldlevels.xp|worldlevels.xp.set")
    public final void onXPSet(@NotNull CommandSender sender, double xp) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Experience.setExperience$default(this.plugin.getExperience(), xp, false, 2, null);
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }

    @Subcommand(value="update")
    @Description(value="Check for plugin updates")
    @CommandPermission(value="worldlevels.update")
    public final void onUpdate(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        boolean update = this.plugin.checkForUpdate();
        if (update) {
            sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnUpdateAvailable(), true));
        } else {
            sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnNoUpdateAvailable(), true));
        }
    }

    @Subcommand(value="version")
    @Description(value="Print the plugin version")
    @CommandPermission(value="worldlevels.version")
    public final void onVersion(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnVersion(), true));
    }

    @Subcommand(value="reset all")
    @Description(value="Sets XP back to 0 and resets all level-up rewards")
    @CommandPermission(value="worldlevels.reset.all")
    public final void onResetAll(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (Player player : thisCollection$iv.toArray(new Player[0])) {
            Experience experience = this.plugin.getExperience();
            Intrinsics.checkNotNull(player);
            experience.removeProcessKey(player);
        }
        this.plugin.getConfig().init();
        this.plugin.getExperience().setExperience(0.0, true);
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }

    @Subcommand(value="reset rewards")
    @Description(value="Resets level-up rewards, allowing players to get them again")
    @CommandPermission(value="worldlevels.reset.rewards")
    public final void onResetRewards(@NotNull CommandSender sender, @Nullable Player player) {
        Player[] playerArray;
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (player == null) {
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            playerArray = thisCollection$iv.toArray(new Player[0]);
        } else {
            Player[] playerArray2 = new Player[]{player};
            playerArray = playerArray2;
        }
        for (Player player2 : playerArray) {
            Experience experience = this.plugin.getExperience();
            Intrinsics.checkNotNull(player2);
            experience.removeProcessKey(player2);
        }
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }
}

