/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.BossBarConfig;
import com.astrelion.worldlevels.config.ConfigData;
import com.astrelion.worldlevels.config.ConfigDataKt;
import com.astrelion.worldlevels.config.ConfigurationKt;
import com.astrelion.worldlevels.config.CustomXPSourceData;
import com.astrelion.worldlevels.config.CustomXPSources;
import com.astrelion.worldlevels.config.DataFile;
import com.astrelion.worldlevels.config.LevelData;
import com.astrelion.worldlevels.config.Pos2;
import com.astrelion.worldlevels.config.ProceduralStep;
import com.astrelion.worldlevels.config.WorldBorder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ExperienceOrb;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020JJ\u0006\u0010L\u001a\u00020JJ\u0006\u0010M\u001a\u00020JJ\u0006\u0010N\u001a\u00020\u001dJ\u0006\u0010O\u001a\u00020\u000fJ\u0018\u0010P\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020\u000f2\b\b\u0002\u0010R\u001a\u00020\u001dJ\u000e\u0010S\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020\u000fJ\u0006\u0010T\u001a\u00020\u000fJ\u000e\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020WJ\u001e\u0010X\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u00150'0'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u001e\u0010$\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020#@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R6\u0010)\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u000f0'2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u000f0'@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010-\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020,@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R*\u00101\u001a\b\u0012\u0004\u0012\u00020\u0019002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u001900@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R*\u00105\u001a\b\u0012\u0004\u0012\u00020\u0019042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u001904@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R*\u00108\u001a\b\u0012\u0004\u0012\u00020\u0019042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u001904@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u001e\u0010:\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010 R\u001e\u0010=\u001a\u00020<2\u0006\u0010\u0006\u001a\u00020<@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R*\u0010@\u001a\b\u0012\u0004\u0012\u00020\u0019002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u001900@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00103R*\u0010C\u001a\b\u0012\u0004\u0012\u00020B002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020B00@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00103R\u001e\u0010E\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010 R\u001e\u0010G\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010 \u00a8\u0006["}, d2={"Lcom/astrelion/worldlevels/config/Configuration;", "", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "value", "Lcom/astrelion/worldlevels/config/DataFile;", "Lcom/astrelion/worldlevels/config/ConfigData;", "dataFile", "getDataFile", "()Lcom/astrelion/worldlevels/config/DataFile;", "data", "getData", "()Lcom/astrelion/worldlevels/config/ConfigData;", "", "relativeXP", "getRelativeXP", "()D", "neededXP", "getNeededXP", "", "currentLevel", "getCurrentLevel", "()I", "", "currentLevelKey", "getCurrentLevelKey", "()Ljava/lang/String;", "", "allowNether", "getAllowNether", "()Z", "allowEnd", "getAllowEnd", "Lcom/astrelion/worldlevels/config/WorldBorder;", "worldBorder", "getWorldBorder", "()Lcom/astrelion/worldlevels/config/WorldBorder;", "", "Lorg/bukkit/entity/ExperienceOrb$SpawnReason;", "xpWeights", "getXpWeights", "()Ljava/util/Map;", "Lcom/astrelion/worldlevels/config/CustomXPSources;", "customXPSources", "getCustomXPSources", "()Lcom/astrelion/worldlevels/config/CustomXPSources;", "", "commands", "getCommands", "()Ljava/util/List;", "", "permissions", "getPermissions", "()Ljava/util/Set;", "groups", "getGroups", "enabled", "getEnabled", "Lcom/astrelion/worldlevels/config/BossBarConfig;", "bossBar", "getBossBar", "()Lcom/astrelion/worldlevels/config/BossBarConfig;", "worldDenylist", "getWorldDenylist", "Lorg/bukkit/GameMode;", "gamemodeDenylist", "getGamemodeDenylist", "rewardOfflinePlayers", "getRewardOfflinePlayers", "rewardNewPlayers", "getRewardNewPlayers", "reload", "", "load", "migrate", "init", "apply", "levelMin", "setExperience", "xp", "force", "addExperience", "getProgress", "worldEnabled", "world", "Lorg/bukkit/World;", "getItemRewards", "Lorg/bukkit/Material;", "Companion", "WorldLevels"})
@SourceDebugExtension(value={"SMAP\nConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Configuration.kt\ncom/astrelion/worldlevels/config/Configuration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,555:1\n1563#2:556\n1634#2,3:557\n360#2,7:560\n*S KotlinDebug\n*F\n+ 1 Configuration.kt\ncom/astrelion/worldlevels/config/Configuration\n*L\n230#1:556\n230#1:557,3\n425#1:560,7\n*E\n"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldLevels plugin;
    @NotNull
    private DataFile<ConfigData> dataFile;
    private double relativeXP;
    private double neededXP;
    private int currentLevel;
    @Nullable
    private String currentLevelKey;
    private boolean allowNether;
    private boolean allowEnd;
    private WorldBorder worldBorder;
    private Map<ExperienceOrb.SpawnReason, Double> xpWeights;
    private CustomXPSources customXPSources;
    private List<String> commands;
    private Set<String> permissions;
    private Set<String> groups;
    private boolean enabled;
    private BossBarConfig bossBar;
    private List<String> worldDenylist;
    private List<? extends GameMode> gamemodeDenylist;
    private boolean rewardOfflinePlayers;
    private boolean rewardNewPlayers;
    @NotNull
    public static final String FILE_NAME = "config.yml";
    @NotNull
    private static final ConfigData DEFAULT_DATA = new ConfigData(0, false, null, null, null, false, false, false, null, null, null, 2047, null);

    @NotNull
    public final DataFile<ConfigData> getDataFile() {
        return this.dataFile;
    }

    private final ConfigData getData() {
        return this.dataFile.getData();
    }

    public final double getRelativeXP() {
        return this.relativeXP;
    }

    public final double getNeededXP() {
        return this.neededXP;
    }

    public final int getCurrentLevel() {
        return this.currentLevel;
    }

    @Nullable
    public final String getCurrentLevelKey() {
        return this.currentLevelKey;
    }

    public final boolean getAllowNether() {
        return this.allowNether;
    }

    public final boolean getAllowEnd() {
        return this.allowEnd;
    }

    @NotNull
    public final WorldBorder getWorldBorder() {
        WorldBorder worldBorder = this.worldBorder;
        if (worldBorder != null) {
            return worldBorder;
        }
        Intrinsics.throwUninitializedPropertyAccessException("worldBorder");
        return null;
    }

    @NotNull
    public final Map<ExperienceOrb.SpawnReason, Double> getXpWeights() {
        Map<ExperienceOrb.SpawnReason, Double> map = this.xpWeights;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException("xpWeights");
        return null;
    }

    @NotNull
    public final CustomXPSources getCustomXPSources() {
        CustomXPSources customXPSources = this.customXPSources;
        if (customXPSources != null) {
            return customXPSources;
        }
        Intrinsics.throwUninitializedPropertyAccessException("customXPSources");
        return null;
    }

    @NotNull
    public final List<String> getCommands() {
        List<String> list = this.commands;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("commands");
        return null;
    }

    @NotNull
    public final Set<String> getPermissions() {
        Set<String> set = this.permissions;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException("permissions");
        return null;
    }

    @NotNull
    public final Set<String> getGroups() {
        Set<String> set = this.groups;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException("groups");
        return null;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final BossBarConfig getBossBar() {
        BossBarConfig bossBarConfig = this.bossBar;
        if (bossBarConfig != null) {
            return bossBarConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException("bossBar");
        return null;
    }

    @NotNull
    public final List<String> getWorldDenylist() {
        List<String> list = this.worldDenylist;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("worldDenylist");
        return null;
    }

    @NotNull
    public final List<GameMode> getGamemodeDenylist() {
        List<GameMode> list = this.gamemodeDenylist;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gamemodeDenylist");
        return null;
    }

    public final boolean getRewardOfflinePlayers() {
        return this.rewardOfflinePlayers;
    }

    public final boolean getRewardNewPlayers() {
        return this.rewardNewPlayers;
    }

    public Configuration(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.allowNether = true;
        this.allowEnd = true;
        this.enabled = DEFAULT_DATA.getEnabled();
        this.rewardOfflinePlayers = DEFAULT_DATA.getRewardOfflinePlayers();
        this.rewardNewPlayers = DEFAULT_DATA.getRewardNewPlayers();
        this.plugin = plugin;
        File file = new File(plugin.getDataFolder(), FILE_NAME);
        this.dataFile = new DataFile<ConfigData>(ConfigData.class, file);
        this.dataFile.setLeadingText("# yaml-language-server: $schema=https://gitlab.com/ASTRELION/worldlevels/-/raw/main/src/main/resources/schema.json\n\n");
        this.reload();
    }

    public final void reload() {
        this.load();
        this.init();
        this.apply();
    }

    public final void load() {
        if (this.dataFile.exists()) {
            this.migrate();
            this.dataFile.load(new ConfigData(0, false, null, null, null, false, false, false, null, null, null, 2047, null));
        } else {
            this.dataFile.save(new ConfigData(0, false, null, null, null, false, false, false, null, null, null, 2047, null));
        }
    }

    public final void migrate() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.dataFile.getFile());
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration yamlConfig = yamlConfiguration;
        int oldVersion = yamlConfig.getInt("version");
        int thisVersion = new ConfigData(0, false, null, null, null, false, false, false, null, null, null, 2047, null).getVersion();
        if (oldVersion > thisVersion) {
            this.plugin.getLogger().log(Level.WARNING, "Config version newer than plugin version, skipping config migration");
            return;
        }
        if (oldVersion == thisVersion) {
            return;
        }
        this.plugin.getLogger().log(Level.WARNING, "Config outdated, migrating from v" + oldVersion + " to v" + thisVersion);
        File configBackup = FilesKt.copyTo$default(this.dataFile.getFile(), new File(this.dataFile.getFile().getParentFile(), "config.yml.old"), true, 0, 4, null);
        this.plugin.getLogger().log(Level.WARNING, "Backed up existing config to " + configBackup.getName());
        this.plugin.getLogger().log(Level.WARNING, "Migration complete!");
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        char[] cArray;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<String, LevelData> level;
        if (this.getData().getLevels().isEmpty()) {
            this.plugin.getLogger().log(Level.WARNING, "No levels defined, this plugin won't do much!");
        }
        int n = this.getData().getLevels().size();
        for (int l = 0; l < n; ++l) {
            Regex lastLevelRegex;
            level = MapsKt.toList(this.getData().getLevels()).get(l);
            if (l == 0) {
                Regex firstLevelRegex = new Regex("1(-\\d+)?");
                if (!firstLevelRegex.matches(level.getFirst())) {
                    this.plugin.getLogger().log(Level.SEVERE, "Level pattern '" + level.getFirst() + "' is invalid for first level");
                }
                if (!Intrinsics.areEqual(level.getSecond().getXp(), 0.0)) {
                    this.plugin.getLogger().log(Level.SEVERE, "First level should define 'xp: 0'");
                }
                ProceduralStep proceduralStep = level.getSecond().getXpStep();
                if ((proceduralStep != null ? proceduralStep.getMult() : null) != null) {
                    this.plugin.getLogger().log(Level.SEVERE, "First level should not use 'mult' in 'xpStep'");
                }
            } else {
                Regex levelRegex = new Regex("\\d+(-\\d*)?");
                if (!levelRegex.matches(level.getFirst())) {
                    this.plugin.getLogger().log(Level.SEVERE, "Level pattern '" + level.getFirst() + "' is invalid");
                }
            }
            if (l < this.getData().getLevels().size() - 1 && (lastLevelRegex = new Regex("\\d+-")).matches(level.getFirst())) {
                this.plugin.getLogger().log(Level.SEVERE, "Only the last level can use pattern '" + level.getFirst() + "'");
            }
            if (level.getSecond().getXp() != null || level.getSecond().getXpStep() != null) continue;
            this.plugin.getLogger().log(Level.SEVERE, "Unable to determine XP requirements for level '" + level.getFirst() + "'");
        }
        this.enabled = this.getData().getEnabled();
        this.rewardNewPlayers = this.getData().getRewardNewPlayers();
        this.rewardOfflinePlayers = this.getData().getRewardOfflinePlayers();
        this.xpWeights = ConfigurationKt.weightsToBukkitMap(this.getData().getWeights());
        this.customXPSources = ConfigurationKt.toBukkitMaps(this.getData().getCustomXPSources());
        this.worldDenylist = this.getData().getWorldDenylist();
        this.bossBar = ConfigurationKt.toBukkitMaps(this.getData().getBossBar());
        this.commands = CollectionsKt.emptyList();
        this.permissions = new LinkedHashSet();
        this.groups = new LinkedHashSet();
        this.worldBorder = new WorldBorder(null, null, 3, null);
        List list = this.plugin.getServer().getWorlds();
        Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
        if (!((Collection)list).isEmpty()) {
            List list2 = this.plugin.getServer().getWorlds();
            Intrinsics.checkNotNullExpressionValue(list2, "getWorlds(...)");
            org.bukkit.WorldBorder worldBorder = ((World)CollectionsKt.first(list2)).getWorldBorder();
            Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
            org.bukkit.WorldBorder existingBorder = worldBorder;
            this.worldBorder = new WorldBorder(existingBorder.getSize() / (double)2, new Pos2(existingBorder.getCenter().getX(), existingBorder.getCenter().getZ()));
        }
        this.allowNether = this.plugin.getServer().getAllowNether();
        this.allowEnd = this.plugin.getServer().getAllowEnd();
        Iterable existingBorder = this.getData().getGamemodeDenylist();
        Configuration configuration = this;
        boolean $i$f$map = false;
        level = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GameMode.valueOf((String)it));
        }
        configuration.gamemodeDenylist = (List)destination$iv$iv;
        String string = (String)CollectionsKt.firstOrNull((Iterable)this.getData().getLevels().keySet());
        this.currentLevel = string != null && (string = (String)StringsKt.split$default((CharSequence)string, cArray = new char[]{'-'}, false, 0, 6, null).get(0)) != null ? Integer.parseInt(string) : 0;
        this.neededXP = 0.0;
        this.relativeXP = 0.0;
    }

    public final boolean apply() {
        int oldLevel = this.currentLevel;
        double xpToApply = this.plugin.getSave().getXP();
        double xpRequirement = 0.0;
        int levelStart = 0;
        int levelEnd = 0;
        String lastKey = (String)CollectionsKt.firstOrNull((Iterable)this.getData().getLevels().keySet());
        for (Map.Entry<String, LevelData> levelEntry : this.getData().getLevels().entrySet()) {
            double d;
            LevelData level = levelEntry.getValue();
            Pair<Integer, Integer> range = ConfigDataKt.parseLevelRange(levelEntry.getKey());
            levelStart = ((Number)range.getFirst()).intValue();
            levelEnd = ((Number)range.getSecond()).intValue();
            Double d2 = level.getXp();
            if (d2 != null) {
                d = d2;
            } else {
                ProceduralStep proceduralStep = level.getXpStep();
                Intrinsics.checkNotNull(proceduralStep);
                d = ConfigurationKt.apply(proceduralStep, xpRequirement);
            }
            this.neededXP = xpRequirement = d;
            for (int levelNum = levelStart; levelEnd == 0 || levelNum <= levelEnd; ++levelNum) {
                List<String> list;
                Map<String, Double> map;
                Object object;
                if (levelNum > levelStart) {
                    double d3;
                    if (level.getXp() != null && level.getXpStep() == null) {
                        d3 = level.getXp();
                    } else {
                        ProceduralStep proceduralStep = level.getXpStep();
                        Intrinsics.checkNotNull(proceduralStep);
                        d3 = ConfigurationKt.apply(proceduralStep, xpRequirement);
                    }
                    xpRequirement = d3;
                }
                this.neededXP = xpRequirement;
                if (xpRequirement > xpToApply) {
                    this.relativeXP = xpToApply;
                    return this.currentLevel > oldLevel;
                }
                xpToApply -= xpRequirement;
                this.currentLevel = levelNum;
                this.currentLevelKey = levelEntry.getKey();
                Boolean bl = level.getAllowNether();
                this.allowNether = bl != null ? bl : this.allowNether;
                Boolean bl2 = level.getAllowEnd();
                boolean bl3 = this.allowEnd = bl2 != null ? bl2 : this.allowEnd;
                if (level.getWorldBorder() != null) {
                    WorldBorder worldBorder = this.getWorldBorder();
                    Pos2 pos2 = level.getWorldBorder().getCenter();
                    if (pos2 == null) {
                        pos2 = this.getWorldBorder().getCenter();
                    }
                    worldBorder.setCenter(pos2);
                    if (levelNum == levelStart) {
                        if (level.getWorldBorder().getRadius() != null) {
                            this.getWorldBorder().setRadius(level.getWorldBorder().getRadius());
                        } else if (this.getWorldBorder().getRadius() != null) {
                            WorldBorder worldBorder2 = this.getWorldBorder();
                            ProceduralStep proceduralStep = level.getWorldBorder().getRadiusStep();
                            Intrinsics.checkNotNull(proceduralStep);
                            Double d4 = this.getWorldBorder().getRadius();
                            Intrinsics.checkNotNull(d4);
                            worldBorder2.setRadius(ConfigurationKt.apply(proceduralStep, d4));
                        }
                    } else if (level.getWorldBorder().getRadius() != null && level.getWorldBorder().getRadiusStep() == null) {
                        this.getWorldBorder().setRadius(level.getWorldBorder().getRadius());
                    } else if (this.getWorldBorder().getRadius() != null) {
                        WorldBorder worldBorder3 = this.getWorldBorder();
                        ProceduralStep proceduralStep = level.getWorldBorder().getRadiusStep();
                        Intrinsics.checkNotNull(proceduralStep);
                        Double d5 = this.getWorldBorder().getRadius();
                        Intrinsics.checkNotNull(d5);
                        worldBorder3.setRadius(ConfigurationKt.apply(proceduralStep, d5));
                    }
                }
                if ((object = level.getCustomXPSources()) == null || (object = ConfigurationKt.toBukkitMaps((CustomXPSourceData)object)) == null) {
                    object = this.customXPSources = ConfigurationKt.toBukkitMaps(this.getData().getCustomXPSources());
                }
                if ((map = level.getXpWeights()) == null || (map = ConfigurationKt.weightsToBukkitMap(map)) == null) {
                    map = this.xpWeights = ConfigurationKt.weightsToBukkitMap(this.getData().getWeights());
                }
                if ((list = level.getCommands()) == null) {
                    list = CollectionsKt.emptyList();
                }
                this.commands = list;
                Set<String> set = level.getPermissions();
                this.getPermissions().addAll(set != null ? (Collection)set : (Collection)SetsKt.emptySet());
                Set<String> set2 = level.getGroups();
                this.getGroups().addAll(set2 != null ? (Collection)set2 : (Collection)SetsKt.emptySet());
            }
            lastKey = levelEntry.getKey();
        }
        this.currentLevelKey = lastKey;
        this.relativeXP = Intrinsics.areEqual(this.currentLevelKey, CollectionsKt.last((Iterable)this.getData().getLevels().keySet())) && this.currentLevel == levelEnd ? this.neededXP : xpToApply;
        return this.currentLevel > oldLevel;
    }

    public final double levelMin() {
        double xpToApply = this.plugin.getSave().getXP();
        double xpRequirement = 0.0;
        double totalXPRequirement = 0.0;
        int levelStart = 0;
        int levelEnd = 0;
        String lastKey = (String)CollectionsKt.firstOrNull((Iterable)this.getData().getLevels().keySet());
        int startIndex = CollectionsKt.indexOf((Iterable)this.getData().getLevels().keySet(), lastKey);
        for (Map.Entry levelEntry : CollectionsKt.toList((Iterable)this.getData().getLevels().entrySet()).subList(startIndex, this.getData().getLevels().entrySet().size())) {
            double d;
            LevelData level = (LevelData)levelEntry.getValue();
            Pair<Integer, Integer> range = ConfigDataKt.parseLevelRange((String)levelEntry.getKey());
            levelStart = ((Number)range.getFirst()).intValue();
            levelEnd = ((Number)range.getSecond()).intValue();
            Double d2 = level.getXp();
            if (d2 != null) {
                d = d2;
            } else {
                ProceduralStep proceduralStep = level.getXpStep();
                Intrinsics.checkNotNull(proceduralStep);
                d = ConfigurationKt.apply(proceduralStep, xpRequirement);
            }
            xpRequirement = d;
            totalXPRequirement += xpRequirement;
            this.neededXP = xpRequirement;
            for (int levelNum = levelStart; levelEnd == 0 || levelNum <= levelEnd; ++levelNum) {
                if (levelNum > levelStart) {
                    double d3;
                    if (level.getXp() != null && level.getXpStep() == null) {
                        d3 = level.getXp();
                    } else {
                        ProceduralStep proceduralStep = level.getXpStep();
                        Intrinsics.checkNotNull(proceduralStep);
                        d3 = ConfigurationKt.apply(proceduralStep, xpRequirement);
                    }
                    xpRequirement = d3;
                    totalXPRequirement += xpRequirement;
                }
                if (levelNum == this.currentLevel) {
                    return totalXPRequirement;
                }
                xpToApply -= xpRequirement;
            }
        }
        return xpRequirement;
    }

    public final boolean setExperience(double xp, boolean force) {
        double newXP;
        double d = newXP = xp > 0.0 ? xp : 0.0;
        if (xp < this.plugin.getSave().getXP()) {
            if (!this.getData().getAllowDeleveling() && !force) {
                double minXP = this.levelMin();
                newXP = RangesKt.coerceAtLeast(newXP, minXP);
            }
            this.currentLevelKey = null;
        }
        this.plugin.getSave().setXP(newXP);
        return this.apply();
    }

    public static /* synthetic */ boolean setExperience$default(Configuration configuration, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return configuration.setExperience(d, bl);
    }

    public final boolean addExperience(double xp) {
        return Configuration.setExperience$default(this, this.plugin.getSave().getXP() + xp, false, 2, null);
    }

    public final double getProgress() {
        return Math.clamp(this.relativeXP / this.neededXP, 0.0, 1.0);
    }

    public final boolean worldEnabled(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return !this.getWorldDenylist().contains(world.getName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<Material, Integer>> getItemRewards() {
        int n;
        List list;
        int n2;
        block5: {
            void $this$indexOfFirst$iv;
            List levelList;
            List list2 = levelList = CollectionsKt.toList((Iterable)this.getData().getLevels().entrySet());
            n2 = 0;
            list = levelList;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                Map.Entry it = (Map.Entry)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it.getKey(), this.currentLevelKey)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n3 = n;
        List pastLevels = list.subList(n2, n3 + 1);
        Map map = new LinkedHashMap();
        block1: for (Map.Entry level : pastLevels) {
            int end;
            int n4;
            Pair<Integer, Integer> pair = ConfigDataKt.parseLevelRange((String)level.getKey());
            int start = ((Number)pair.component1()).intValue();
            int l = start;
            if (l > (n4 = RangesKt.coerceAtMost(end = ((Number)pair.component2()).intValue(), this.currentLevel))) continue;
            while (true) {
                Map map2 = map;
                String string = String.valueOf(l);
                Map<String, Integer> map3 = ((LevelData)level.getValue()).getItems();
                if (map3 == null || (map3 = ConfigurationKt.itemToBukkitMap(map3)) == null) {
                    map3 = MapsKt.emptyMap();
                }
                Map<String, Integer> map4 = map3;
                map2.put(string, map4);
                if (l == n4) continue block1;
                ++l;
            }
        }
        return map;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/astrelion/worldlevels/config/Configuration$Companion;", "", "<init>", "()V", "FILE_NAME", "", "DEFAULT_DATA", "Lcom/astrelion/worldlevels/config/ConfigData;", "getDEFAULT_DATA", "()Lcom/astrelion/worldlevels/config/ConfigData;", "WorldLevels"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigData getDEFAULT_DATA() {
            return DEFAULT_DATA;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

