/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.config;

import com.astrelion.worldlevels.util.Parser;
import com.google.gson.Gson;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0017\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u00020\u001d2\n\b\u0002\u0010#\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010$\u001a\u00020%R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/astrelion/worldlevels/config/DataFile;", "T", "", "dataClass", "Ljava/lang/Class;", "path", "", "<init>", "(Ljava/lang/Class;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/lang/Class;Ljava/io/File;)V", "leadingText", "getLeadingText", "()Ljava/lang/String;", "setLeadingText", "(Ljava/lang/String;)V", "trailingText", "getTrailingText", "setTrailingText", "data", "getData", "()Ljava/lang/Object;", "value", "getFile", "()Ljava/io/File;", "_data", "Ljava/lang/Object;", "save", "", "(Ljava/lang/Object;)V", "asMap", "", "(Ljava/lang/Object;)Ljava/util/Map;", "load", "defaults", "exists", "", "WorldLevels"})
public final class DataFile<T> {
    @NotNull
    private String leadingText;
    @NotNull
    private String trailingText;
    @NotNull
    private File file;
    @Nullable
    private T _data;
    @NotNull
    private final Class<T> dataClass;

    @NotNull
    public final String getLeadingText() {
        return this.leadingText;
    }

    public final void setLeadingText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.leadingText = string;
    }

    @NotNull
    public final String getTrailingText() {
        return this.trailingText;
    }

    public final void setTrailingText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.trailingText = string;
    }

    @NotNull
    public final T getData() {
        T t = this._data;
        Intrinsics.checkNotNull(t);
        return t;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public DataFile(@NotNull Class<T> dataClass, @NotNull String path) {
        Intrinsics.checkNotNullParameter(dataClass, "dataClass");
        Intrinsics.checkNotNullParameter(path, "path");
        this.leadingText = "";
        this.trailingText = "";
        this.file = new File(path);
        this.dataClass = dataClass;
    }

    public DataFile(@NotNull Class<T> dataClass, @NotNull File file) {
        Intrinsics.checkNotNullParameter(dataClass, "dataClass");
        Intrinsics.checkNotNullParameter(file, "file");
        this.leadingText = "";
        this.trailingText = "";
        this.file = file;
        this.dataClass = dataClass;
    }

    public final void save(@Nullable T data) {
        Yaml yaml = Parser.INSTANCE.getYaml();
        this.file.getParentFile().mkdirs();
        Map<?, ?> dataMap = this.asMap(data);
        String yamlString = yaml.dump(dataMap);
        FilesKt.writeText$default(this.file, this.leadingText + yamlString + this.trailingText, null, 2, null);
        if (data != null) {
            this._data = data;
        }
    }

    public static /* synthetic */ void save$default(DataFile dataFile, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        dataFile.save(object);
    }

    @NotNull
    public final Map<?, ?> asMap(@Nullable T data) {
        Gson gson = Parser.INSTANCE.getGson();
        T t = data;
        if (t == null) {
            t = this._data;
        }
        Object object = gson.fromJson(gson.toJson(t), Map.class);
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        return (Map)object;
    }

    public static /* synthetic */ Map asMap$default(DataFile dataFile, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        return dataFile.asMap(object);
    }

    public final void load(@Nullable T defaults) {
        Map yamlMap;
        Yaml yaml = Parser.INSTANCE.getYaml();
        Gson gson = Parser.INSTANCE.getGson();
        String fileText = FilesKt.readText$default(this.file, null, 1, null);
        Map map = (Map)yaml.load(fileText);
        if (map == null) {
            map = yamlMap = (Map)new LinkedHashMap();
        }
        if (defaults != null) {
            Map defaultMap = (Map)gson.fromJson(gson.toJson(defaults), Map.class);
            Intrinsics.checkNotNull(defaultMap);
            for (Map.Entry defaultEntry : defaultMap.entrySet()) {
                Object v;
                if (yamlMap.containsKey(defaultEntry.getKey())) continue;
                Map map2 = yamlMap;
                Object k = defaultEntry.getKey();
                Intrinsics.checkNotNull(k, "null cannot be cast to non-null type kotlin.String");
                String string = (String)k;
                Intrinsics.checkNotNull(defaultEntry.getValue(), "null cannot be cast to non-null type kotlin.Any");
                map2.put(string, v);
            }
        }
        FilesKt.writeText$default(this.file, this.leadingText + yaml.dump((Object)yamlMap) + this.trailingText, null, 2, null);
        Object newData = gson.fromJson(gson.toJson((Object)yamlMap), this.dataClass);
        this._data = newData;
    }

    public static /* synthetic */ void load$default(DataFile dataFile, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        dataFile.load(object);
    }

    public final boolean exists() {
        return this.file.exists();
    }
}

