/*
 * Decompiled with CFR 0.152.
 */
package com.cloverclient.lwjgl3.implementation.glfw;

import com.cloverclient.lwjgl3.implementation.input.KeyboardImplementation;
import java.nio.ByteBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EventQueue;

public class GLFWKeyboardImplementation
implements KeyboardImplementation {
    private GLFWKeyCallback keyCallback;
    private GLFWCharCallback charCallback;
    private long windowHandle;
    private final byte[] key_down_buffer = new byte[349];
    private final EventQueue event_queue = new EventQueue(18);
    private final ByteBuffer tmp_event = ByteBuffer.allocate(18);
    private static final int[] GLFW2LWJGL = new int[349];

    @Override
    public void createKeyboard() {
        if (this.keyCallback != null) {
            return;
        }
        this.keyCallback = GLFWKeyCallback.create((window, glfwKey, scancode, action, mods) -> {
            int key = GLFWKeyboardImplementation.translateKeyFromGLFW(glfwKey);
            if (action == 1) {
                this.key_down_buffer[key] = 1;
            } else if (action == 0) {
                this.key_down_buffer[key] = 0;
            }
            this.putKeyboardEvent(key, this.key_down_buffer[key], 0, System.nanoTime(), action == 2);
        });
        this.charCallback = GLFWCharCallback.create((window, codepoint) -> this.putKeyboardEvent(-1, (byte)1, codepoint, System.nanoTime(), false));
        this.windowHandle = Display.getHandle();
        GLFW.glfwSetKeyCallback(this.windowHandle, this.keyCallback);
        GLFW.glfwSetCharCallback(this.windowHandle, this.charCallback);
    }

    private void putKeyboardEvent(int keycode, byte state, int ch, long nanos, boolean repeat) {
        this.tmp_event.clear();
        this.tmp_event.putInt(keycode).put(state).putInt(ch).putLong(nanos).put(repeat ? (byte)1 : 0);
        this.tmp_event.flip();
        this.event_queue.putEvent(this.tmp_event);
    }

    @Override
    public void destroyKeyboard() {
    }

    @Override
    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        int old_position = keyDownBuffer.position();
        keyDownBuffer.put(this.key_down_buffer);
        keyDownBuffer.position(old_position);
    }

    @Override
    public void readKeyboard(ByteBuffer readBuffer) {
        this.event_queue.copyEvents(readBuffer);
    }

    public static int translateKeyFromGLFW(int key) {
        if (key == -1) {
            return GLFW2LWJGL[0];
        }
        if (key < GLFW2LWJGL.length) {
            return GLFW2LWJGL[key];
        }
        return key;
    }

    static {
        GLFWKeyboardImplementation.GLFW2LWJGL[0] = Keyboard.KEY_NONE;
        GLFWKeyboardImplementation.GLFW2LWJGL[32] = Keyboard.KEY_SPACE;
        GLFWKeyboardImplementation.GLFW2LWJGL[39] = Keyboard.KEY_APOSTROPHE;
        GLFWKeyboardImplementation.GLFW2LWJGL[44] = Keyboard.KEY_COMMA;
        GLFWKeyboardImplementation.GLFW2LWJGL[45] = Keyboard.KEY_MINUS;
        GLFWKeyboardImplementation.GLFW2LWJGL[46] = Keyboard.KEY_PERIOD;
        GLFWKeyboardImplementation.GLFW2LWJGL[47] = Keyboard.KEY_SLASH;
        GLFWKeyboardImplementation.GLFW2LWJGL[48] = Keyboard.KEY_0;
        GLFWKeyboardImplementation.GLFW2LWJGL[49] = Keyboard.KEY_1;
        GLFWKeyboardImplementation.GLFW2LWJGL[50] = Keyboard.KEY_2;
        GLFWKeyboardImplementation.GLFW2LWJGL[51] = Keyboard.KEY_3;
        GLFWKeyboardImplementation.GLFW2LWJGL[52] = Keyboard.KEY_4;
        GLFWKeyboardImplementation.GLFW2LWJGL[53] = Keyboard.KEY_5;
        GLFWKeyboardImplementation.GLFW2LWJGL[54] = Keyboard.KEY_6;
        GLFWKeyboardImplementation.GLFW2LWJGL[55] = Keyboard.KEY_7;
        GLFWKeyboardImplementation.GLFW2LWJGL[56] = Keyboard.KEY_8;
        GLFWKeyboardImplementation.GLFW2LWJGL[57] = Keyboard.KEY_9;
        GLFWKeyboardImplementation.GLFW2LWJGL[59] = Keyboard.KEY_SEMICOLON;
        GLFWKeyboardImplementation.GLFW2LWJGL[61] = Keyboard.KEY_EQUALS;
        GLFWKeyboardImplementation.GLFW2LWJGL[65] = Keyboard.KEY_A;
        GLFWKeyboardImplementation.GLFW2LWJGL[66] = Keyboard.KEY_B;
        GLFWKeyboardImplementation.GLFW2LWJGL[67] = Keyboard.KEY_C;
        GLFWKeyboardImplementation.GLFW2LWJGL[68] = Keyboard.KEY_D;
        GLFWKeyboardImplementation.GLFW2LWJGL[69] = Keyboard.KEY_E;
        GLFWKeyboardImplementation.GLFW2LWJGL[70] = Keyboard.KEY_F;
        GLFWKeyboardImplementation.GLFW2LWJGL[71] = Keyboard.KEY_G;
        GLFWKeyboardImplementation.GLFW2LWJGL[72] = Keyboard.KEY_H;
        GLFWKeyboardImplementation.GLFW2LWJGL[73] = Keyboard.KEY_I;
        GLFWKeyboardImplementation.GLFW2LWJGL[74] = Keyboard.KEY_J;
        GLFWKeyboardImplementation.GLFW2LWJGL[75] = Keyboard.KEY_K;
        GLFWKeyboardImplementation.GLFW2LWJGL[76] = Keyboard.KEY_L;
        GLFWKeyboardImplementation.GLFW2LWJGL[77] = Keyboard.KEY_M;
        GLFWKeyboardImplementation.GLFW2LWJGL[78] = Keyboard.KEY_N;
        GLFWKeyboardImplementation.GLFW2LWJGL[79] = Keyboard.KEY_O;
        GLFWKeyboardImplementation.GLFW2LWJGL[80] = Keyboard.KEY_P;
        GLFWKeyboardImplementation.GLFW2LWJGL[81] = Keyboard.KEY_Q;
        GLFWKeyboardImplementation.GLFW2LWJGL[82] = Keyboard.KEY_R;
        GLFWKeyboardImplementation.GLFW2LWJGL[83] = Keyboard.KEY_S;
        GLFWKeyboardImplementation.GLFW2LWJGL[84] = Keyboard.KEY_T;
        GLFWKeyboardImplementation.GLFW2LWJGL[85] = Keyboard.KEY_U;
        GLFWKeyboardImplementation.GLFW2LWJGL[86] = Keyboard.KEY_V;
        GLFWKeyboardImplementation.GLFW2LWJGL[87] = Keyboard.KEY_W;
        GLFWKeyboardImplementation.GLFW2LWJGL[88] = Keyboard.KEY_X;
        GLFWKeyboardImplementation.GLFW2LWJGL[89] = Keyboard.KEY_Y;
        GLFWKeyboardImplementation.GLFW2LWJGL[90] = Keyboard.KEY_Z;
        GLFWKeyboardImplementation.GLFW2LWJGL[91] = Keyboard.KEY_LBRACKET;
        GLFWKeyboardImplementation.GLFW2LWJGL[92] = Keyboard.KEY_BACKSLASH;
        GLFWKeyboardImplementation.GLFW2LWJGL[93] = Keyboard.KEY_RBRACKET;
        GLFWKeyboardImplementation.GLFW2LWJGL[96] = Keyboard.KEY_GRAVE;
        GLFWKeyboardImplementation.GLFW2LWJGL[161] = Keyboard.KEY_WORLD_1;
        GLFWKeyboardImplementation.GLFW2LWJGL[162] = Keyboard.KEY_WORLD_2;
        GLFWKeyboardImplementation.GLFW2LWJGL[256] = Keyboard.KEY_ESCAPE;
        GLFWKeyboardImplementation.GLFW2LWJGL[257] = Keyboard.KEY_RETURN;
        GLFWKeyboardImplementation.GLFW2LWJGL[258] = Keyboard.KEY_TAB;
        GLFWKeyboardImplementation.GLFW2LWJGL[259] = Keyboard.KEY_BACK;
        GLFWKeyboardImplementation.GLFW2LWJGL[260] = Keyboard.KEY_INSERT;
        GLFWKeyboardImplementation.GLFW2LWJGL[261] = Keyboard.KEY_DELETE;
        GLFWKeyboardImplementation.GLFW2LWJGL[262] = Keyboard.KEY_RIGHT;
        GLFWKeyboardImplementation.GLFW2LWJGL[263] = Keyboard.KEY_LEFT;
        GLFWKeyboardImplementation.GLFW2LWJGL[264] = Keyboard.KEY_DOWN;
        GLFWKeyboardImplementation.GLFW2LWJGL[265] = Keyboard.KEY_UP;
        GLFWKeyboardImplementation.GLFW2LWJGL[266] = Keyboard.KEY_PRIOR;
        GLFWKeyboardImplementation.GLFW2LWJGL[267] = Keyboard.KEY_NEXT;
        GLFWKeyboardImplementation.GLFW2LWJGL[268] = Keyboard.KEY_HOME;
        GLFWKeyboardImplementation.GLFW2LWJGL[269] = Keyboard.KEY_END;
        GLFWKeyboardImplementation.GLFW2LWJGL[280] = Keyboard.KEY_CAPITAL;
        GLFWKeyboardImplementation.GLFW2LWJGL[281] = Keyboard.KEY_SCROLL;
        GLFWKeyboardImplementation.GLFW2LWJGL[282] = Keyboard.KEY_NUMLOCK;
        GLFWKeyboardImplementation.GLFW2LWJGL[283] = Keyboard.KEY_PRINT_SCREEN;
        GLFWKeyboardImplementation.GLFW2LWJGL[284] = Keyboard.KEY_PAUSE;
        GLFWKeyboardImplementation.GLFW2LWJGL[290] = Keyboard.KEY_F1;
        GLFWKeyboardImplementation.GLFW2LWJGL[291] = Keyboard.KEY_F2;
        GLFWKeyboardImplementation.GLFW2LWJGL[292] = Keyboard.KEY_F3;
        GLFWKeyboardImplementation.GLFW2LWJGL[293] = Keyboard.KEY_F4;
        GLFWKeyboardImplementation.GLFW2LWJGL[294] = Keyboard.KEY_F5;
        GLFWKeyboardImplementation.GLFW2LWJGL[295] = Keyboard.KEY_F6;
        GLFWKeyboardImplementation.GLFW2LWJGL[296] = Keyboard.KEY_F7;
        GLFWKeyboardImplementation.GLFW2LWJGL[297] = Keyboard.KEY_F8;
        GLFWKeyboardImplementation.GLFW2LWJGL[298] = Keyboard.KEY_F9;
        GLFWKeyboardImplementation.GLFW2LWJGL[299] = Keyboard.KEY_F10;
        GLFWKeyboardImplementation.GLFW2LWJGL[300] = Keyboard.KEY_F11;
        GLFWKeyboardImplementation.GLFW2LWJGL[301] = Keyboard.KEY_F12;
        GLFWKeyboardImplementation.GLFW2LWJGL[302] = Keyboard.KEY_F13;
        GLFWKeyboardImplementation.GLFW2LWJGL[303] = Keyboard.KEY_F14;
        GLFWKeyboardImplementation.GLFW2LWJGL[304] = Keyboard.KEY_F15;
        GLFWKeyboardImplementation.GLFW2LWJGL[305] = Keyboard.KEY_F16;
        GLFWKeyboardImplementation.GLFW2LWJGL[306] = Keyboard.KEY_F17;
        GLFWKeyboardImplementation.GLFW2LWJGL[307] = Keyboard.KEY_F18;
        GLFWKeyboardImplementation.GLFW2LWJGL[308] = Keyboard.KEY_F19;
        GLFWKeyboardImplementation.GLFW2LWJGL[309] = Keyboard.KEY_F20;
        GLFWKeyboardImplementation.GLFW2LWJGL[310] = Keyboard.KEY_F21;
        GLFWKeyboardImplementation.GLFW2LWJGL[311] = Keyboard.KEY_F22;
        GLFWKeyboardImplementation.GLFW2LWJGL[312] = Keyboard.KEY_F23;
        GLFWKeyboardImplementation.GLFW2LWJGL[313] = Keyboard.KEY_F24;
        GLFWKeyboardImplementation.GLFW2LWJGL[314] = Keyboard.KEY_F25;
        GLFWKeyboardImplementation.GLFW2LWJGL[320] = Keyboard.KEY_NUMPAD0;
        GLFWKeyboardImplementation.GLFW2LWJGL[321] = Keyboard.KEY_NUMPAD1;
        GLFWKeyboardImplementation.GLFW2LWJGL[322] = Keyboard.KEY_NUMPAD2;
        GLFWKeyboardImplementation.GLFW2LWJGL[323] = Keyboard.KEY_NUMPAD3;
        GLFWKeyboardImplementation.GLFW2LWJGL[324] = Keyboard.KEY_NUMPAD4;
        GLFWKeyboardImplementation.GLFW2LWJGL[325] = Keyboard.KEY_NUMPAD5;
        GLFWKeyboardImplementation.GLFW2LWJGL[326] = Keyboard.KEY_NUMPAD6;
        GLFWKeyboardImplementation.GLFW2LWJGL[327] = Keyboard.KEY_NUMPAD7;
        GLFWKeyboardImplementation.GLFW2LWJGL[328] = Keyboard.KEY_NUMPAD8;
        GLFWKeyboardImplementation.GLFW2LWJGL[329] = Keyboard.KEY_NUMPAD9;
        GLFWKeyboardImplementation.GLFW2LWJGL[330] = Keyboard.KEY_DECIMAL;
        GLFWKeyboardImplementation.GLFW2LWJGL[331] = Keyboard.KEY_DIVIDE;
        GLFWKeyboardImplementation.GLFW2LWJGL[332] = Keyboard.KEY_MULTIPLY;
        GLFWKeyboardImplementation.GLFW2LWJGL[333] = Keyboard.KEY_SUBTRACT;
        GLFWKeyboardImplementation.GLFW2LWJGL[334] = Keyboard.KEY_ADD;
        GLFWKeyboardImplementation.GLFW2LWJGL[335] = Keyboard.KEY_NUMPADENTER;
        GLFWKeyboardImplementation.GLFW2LWJGL[336] = Keyboard.KEY_NUMPADEQUALS;
        GLFWKeyboardImplementation.GLFW2LWJGL[340] = Keyboard.KEY_LSHIFT;
        GLFWKeyboardImplementation.GLFW2LWJGL[341] = Keyboard.KEY_LCONTROL;
        GLFWKeyboardImplementation.GLFW2LWJGL[342] = Keyboard.KEY_LMENU;
        GLFWKeyboardImplementation.GLFW2LWJGL[343] = Keyboard.KEY_LMETA;
        GLFWKeyboardImplementation.GLFW2LWJGL[344] = Keyboard.KEY_RSHIFT;
        GLFWKeyboardImplementation.GLFW2LWJGL[345] = Keyboard.KEY_RCONTROL;
        GLFWKeyboardImplementation.GLFW2LWJGL[346] = Keyboard.KEY_RMENU;
        GLFWKeyboardImplementation.GLFW2LWJGL[347] = Keyboard.KEY_RMETA;
        GLFWKeyboardImplementation.GLFW2LWJGL[348] = Keyboard.KEY_MENU;
    }
}

