/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.compat.mojang.minecraft.math;

import net.minecraft.class_1146;
import net.minecraft.class_1167;
import net.minecraft.class_1354;
import net.minecraft.class_2552;
import net.minecraft.class_837;

public class SectionPos
extends class_1167 {
    public static final int SECTION_BITS = 4;
    public static final int SECTION_SIZE = 16;
    public static final int SECTION_MASK = 15;
    public static final int SECTION_HALF_SIZE = 8;
    public static final int SECTION_MAX_INDEX = 15;
    private static final int PACKED_X_LENGTH = 22;
    private static final int PACKED_Y_LENGTH = 20;
    private static final int PACKED_Z_LENGTH = 22;
    private static final long PACKED_X_MASK = 0x3FFFFFL;
    private static final long PACKED_Y_MASK = 1048575L;
    private static final long PACKED_Z_MASK = 0x3FFFFFL;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = 20;
    private static final int X_OFFSET = 42;
    private static final int RELATIVE_X_SHIFT = 8;
    private static final int RELATIVE_Y_SHIFT = 0;
    private static final int RELATIVE_Z_SHIFT = 4;

    SectionPos(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public static SectionPos of(int n, int n2, int n3) {
        return new SectionPos(n, n2, n3);
    }

    public static SectionPos of(class_2552 blockPos) {
        return new SectionPos(SectionPos.blockToSectionCoord(blockPos.method_10572()), SectionPos.blockToSectionCoord(blockPos.method_10573()), SectionPos.blockToSectionCoord(blockPos.method_10574()));
    }

    public static SectionPos of(class_1146 chunkPos, int n) {
        return new SectionPos(chunkPos.field_4507, n, chunkPos.field_4508);
    }

    public static SectionPos of(long l) {
        return new SectionPos(SectionPos.x(l), SectionPos.y(l), SectionPos.z(l));
    }

    public static long offset(long l, class_1354 direction) {
        return SectionPos.offset(l, direction.method_4347(), direction.method_5134(), direction.method_4348());
    }

    public static long offset(long l, int n, int n2, int n3) {
        return SectionPos.asLong(SectionPos.x(l) + n, SectionPos.y(l) + n2, SectionPos.z(l) + n3);
    }

    public static int posToSectionCoord(double d) {
        return SectionPos.blockToSectionCoord(class_837.method_2345((double)d));
    }

    public static int blockToSectionCoord(int n) {
        return n >> 4;
    }

    public static int sectionToBlockCoord(int n) {
        return n << 4;
    }

    public static int sectionToBlockCoord(int n, int n2) {
        return SectionPos.sectionToBlockCoord(n) + n2;
    }

    public static int x(long l) {
        return (int)(l << 0 >> 42);
    }

    public static int y(long l) {
        return (int)(l << 44 >> 44);
    }

    public static int z(long l) {
        return (int)(l << 22 >> 42);
    }

    public int x() {
        return this.method_10572();
    }

    public int y() {
        return this.method_10573();
    }

    public int z() {
        return this.method_10574();
    }

    public int minBlockX() {
        return SectionPos.sectionToBlockCoord(this.x());
    }

    public int minBlockY() {
        return SectionPos.sectionToBlockCoord(this.y());
    }

    public int minBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z());
    }

    public int maxBlockX() {
        return SectionPos.sectionToBlockCoord(this.x(), 15);
    }

    public int maxBlockY() {
        return SectionPos.sectionToBlockCoord(this.y(), 15);
    }

    public int maxBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z(), 15);
    }

    public class_2552 origin() {
        return new class_2552(SectionPos.sectionToBlockCoord(this.x()), SectionPos.sectionToBlockCoord(this.y()), SectionPos.sectionToBlockCoord(this.z()));
    }

    public class_1146 chunk() {
        return new class_1146(this.x(), this.z());
    }

    public static long asLong(int n, int n2, int n3) {
        long l = 0L;
        l |= ((long)n & 0x3FFFFFL) << 42;
        l |= ((long)n2 & 0xFFFFFL) << 0;
        return l |= ((long)n3 & 0x3FFFFFL) << 20;
    }

    public long asLong() {
        return SectionPos.asLong(this.x(), this.y(), this.z());
    }
}

