/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.mixin.core;

import com.google.common.primitives.Floats;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.class_2522;
import net.minecraft.class_520;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_520.class})
public class MixinBufferBuilder {
    @Shadow
    private ByteBuffer field_10642;
    @Shadow
    private int field_10646;
    @Shadow
    private class_2522 field_10653;

    @Overwrite
    public void method_9730(float cameraX, float cameraY, float cameraZ) {
        this.field_10642.clear();
        FloatBuffer floatBuffer = this.field_10642.asFloatBuffer();
        int vertexStride = this.field_10653.method_10342();
        int quadStride = this.field_10653.method_10342() * 4;
        int quadCount = this.field_10646 / 4;
        int vertexSizeInteger = this.field_10653.method_10342();
        float[] distanceArray = new float[quadCount];
        int[] indicesArray = new int[quadCount];
        for (int quadIdx = 0; quadIdx < quadCount; ++quadIdx) {
            distanceArray[quadIdx] = MixinBufferBuilder.getDistanceSq(floatBuffer, cameraX, cameraY, cameraZ, vertexSizeInteger, quadIdx * vertexStride);
            indicesArray[quadIdx] = quadIdx;
        }
        MixinBufferBuilder.mergeSort(indicesArray, distanceArray);
        BitSet bits = new BitSet();
        FloatBuffer tmp = FloatBuffer.allocate(vertexSizeInteger * 4);
        int l = bits.nextClearBit(0);
        while (l < indicesArray.length) {
            int m = indicesArray[l];
            if (m != l) {
                MixinBufferBuilder.sliceQuad(floatBuffer, m, quadStride);
                tmp.clear();
                tmp.put(floatBuffer);
                int n = m;
                int o = indicesArray[m];
                while (n != l) {
                    MixinBufferBuilder.sliceQuad(floatBuffer, o, quadStride);
                    FloatBuffer floatBuffer3 = floatBuffer.slice();
                    MixinBufferBuilder.sliceQuad(floatBuffer, n, quadStride);
                    floatBuffer.put(floatBuffer3);
                    bits.set(n);
                    n = o;
                    o = indicesArray[o];
                }
                MixinBufferBuilder.sliceQuad(floatBuffer, l, quadStride);
                tmp.flip();
                floatBuffer.put(tmp);
            }
            bits.set(l);
            l = bits.nextClearBit(l + 1);
        }
    }

    @Unique
    private static void mergeSort(int[] indicesArray, float[] distanceArray) {
        MixinBufferBuilder.mergeSort(indicesArray, 0, indicesArray.length, distanceArray, Arrays.copyOf(indicesArray, indicesArray.length));
    }

    @Unique
    private static void sliceQuad(FloatBuffer floatBuffer, int quadIdx, int quadStride) {
        int base = quadIdx * quadStride;
        floatBuffer.limit(base + quadStride);
        floatBuffer.position(base);
    }

    @Unique
    private static float getDistanceSq(FloatBuffer buffer, float xCenter, float yCenter, float zCenter, int stride, int start) {
        int vertexBase = start;
        float x1 = buffer.get(vertexBase);
        float y1 = buffer.get(vertexBase + 1);
        float z1 = buffer.get(vertexBase + 2);
        float x2 = buffer.get(vertexBase += stride);
        float y2 = buffer.get(vertexBase + 1);
        float z2 = buffer.get(vertexBase + 2);
        float x3 = buffer.get(vertexBase += stride);
        float y3 = buffer.get(vertexBase + 1);
        float z3 = buffer.get(vertexBase + 2);
        float x4 = buffer.get(vertexBase += stride);
        float y4 = buffer.get(vertexBase + 1);
        float z4 = buffer.get(vertexBase + 2);
        float xDist = (x1 + x2 + x3 + x4) * 0.25f - xCenter;
        float yDist = (y1 + y2 + y3 + y4) * 0.25f - yCenter;
        float zDist = (z1 + z2 + z3 + z4) * 0.25f - zCenter;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    @Unique
    private static void mergeSort(int[] a, int from, int to, float[] dist, int[] supp) {
        int len = to - from;
        if (len < 16) {
            MixinBufferBuilder.insertionSort(a, from, to, dist);
            return;
        }
        int mid = from + to >>> 1;
        MixinBufferBuilder.mergeSort(supp, from, mid, dist, a);
        MixinBufferBuilder.mergeSort(supp, mid, to, dist, a);
        if (Floats.compare((float)dist[supp[mid]], (float)dist[supp[mid - 1]]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Floats.compare((float)dist[supp[q]], (float)dist[supp[p]]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    @Unique
    private static void insertionSort(int[] a, int from, int to, float[] dist) {
        int i = from;
        while (++i < to) {
            int t = a[i];
            int j = i;
            int u = a[j - 1];
            while (Floats.compare((float)dist[u], (float)dist[t]) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }
}

