/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.mixin.sodium.core.render.world;

import java.util.List;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.render.viewport.frustum.SimpleFrustum;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.minecraft.class_1150;
import net.minecraft.class_1600;
import net.minecraft.class_1699;
import net.minecraft.class_2165;
import net.minecraft.class_236;
import net.minecraft.class_2552;
import net.minecraft.class_321;
import net.minecraft.class_347;
import net.minecraft.class_478;
import net.minecraft.class_530;
import net.minecraft.class_536;
import net.minecraft.class_538;
import net.minecraft.class_550;
import net.minecraft.class_598;
import net.minecraft.class_786;
import net.minecraft.class_864;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_530.class})
public abstract class LevelRendererMixin
implements LevelRendererExtension {
    @Shadow
    @Final
    private Map<Integer, class_786> field_1887;
    @Shadow
    @Final
    private class_1600 field_1918;
    @Shadow
    private int field_1890;
    @Shadow
    @Final
    private class_550 field_10820;
    @Shadow
    private class_478 field_1909;
    @Shadow
    private int field_1889;
    @Unique
    private SodiumWorldRenderer renderer;

    @Override
    public SodiumWorldRenderer sodium$getWorldRenderer() {
        return this.renderer;
    }

    @Redirect(method={"method_1363()V"}, at=@At(value="FIELD", target="Lnet/minecraft/class_347;field_7668:I", ordinal=1))
    private int nullifyBuiltChunkStorage(class_347 instance) {
        return 0;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_1600;)V"}, at={@At(value="RETURN")})
    private void init(class_1600 client, CallbackInfo ci) {
        this.renderer = new SodiumWorldRenderer(client);
    }

    @Inject(method={"method_1371(Lnet/minecraft/class_478;)V"}, at={@At(value="RETURN")})
    private void onWorldChanged(class_478 level, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setLevel(level);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"method_9917()V"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.renderer.scheduleTerrainUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public int method_9894(class_2165 renderLayer, double tickDelta, int anaglyphFilter, class_864 entity) {
        RenderDevice.enterManagedCode();
        double x = entity.field_3211 + (entity.field_3252 - entity.field_3211) * tickDelta;
        double y = entity.field_3212 + (entity.field_3253 - entity.field_3212) * tickDelta;
        double z = entity.field_3213 + (entity.field_3254 - entity.field_3213) * tickDelta;
        Matrix4f projectionMatrix = new Matrix4f(class_321.field_897);
        Matrix4f modelViewMatrix = new Matrix4f(class_321.field_896);
        this.field_1918.field_3818.method_9783();
        try {
            this.renderer.drawChunkLayer(renderLayer, new ChunkRenderMatrices(projectionMatrix, modelViewMatrix), x, y, z);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
        this.field_1918.field_3818.method_9781();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void method_9906(class_864 entity, double tickDelta, class_536 cameraView, int frame, boolean spectator) {
        SimpleFrustum frustum = new SimpleFrustum((class_538)cameraView);
        class_236 transform = entity.method_10958((float)tickDelta);
        Viewport viewport = new Viewport(frustum, transform);
        boolean updateChunksImmediately = false;
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setupTerrain(viewport, spectator, updateChunksImmediately);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void method_1378(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Overwrite
    public void method_9892(long p) {
    }

    @Inject(method={"method_1363()V"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void method_9908(class_864 player, class_536 camera, float partialTicks) {
        this.field_1909.field_4527.method_2356("prepare");
        class_864 renderView = this.field_1918.method_9388();
        class_598.field_2188.method_1629((class_1150)this.field_1909, this.field_1918.method_5570(), this.field_1918.field_3814, renderView, partialTicks);
        this.field_10820.method_10200((class_1150)this.field_1909, this.field_1918.field_3814, renderView, this.field_1918.field_7630, this.field_1918.field_3823, partialTicks);
        double renderX = renderView.field_3211 + (renderView.field_3252 - renderView.field_3211) * (double)partialTicks;
        double renderY = renderView.field_3212 + (renderView.field_3253 - renderView.field_3212) * (double)partialTicks;
        double renderZ = renderView.field_3213 + (renderView.field_3254 - renderView.field_3213) * (double)partialTicks;
        class_598.field_2189 = renderX;
        class_598.field_2190 = renderY;
        class_598.field_2191 = renderZ;
        this.field_10820.method_10198(renderX, renderY, renderZ);
        this.field_1918.field_3818.method_9783();
        this.field_1909.field_4527.method_2360("global");
        List list = this.field_1909.method_3737();
        this.field_1889 = list.size();
        for (int j = 0; j < this.field_1909.field_4545.size(); ++j) {
            class_864 effect = (class_864)this.field_1909.field_4545.get(j);
            if (!effect.method_8363(renderX, renderY, renderZ)) continue;
            this.field_10820.method_6914(effect, partialTicks);
        }
        class_2552.class_2553 entityBlockPos = new class_2552.class_2553();
        for (class_864 entity : this.field_1909.method_3737()) {
            boolean isSleeping;
            if (!entity.method_8363(renderX, renderY, renderZ) && (!entity.method_2512() || entity.field_3246 != null) || !SodiumWorldRenderer.instance().isEntityVisible(entity)) continue;
            boolean bl = isSleeping = renderView instanceof class_1699 && ((class_1699)renderView).method_2641();
            if (entity == renderView && this.field_1918.field_3823.field_949 == 0 && !isSleeping) continue;
            entityBlockPos.method_10512((int)entity.field_3252, (int)entity.field_3253, (int)entity.field_3254);
            if (!(entity.field_3253 < 0.0) && !(entity.field_3253 >= 256.0) && !this.field_1909.method_8548((class_2552)entityBlockPos)) continue;
            ++this.field_1890;
            this.field_10820.method_6915(entity, partialTicks, false);
        }
        this.renderer.renderBlockEntities(this.field_1887, partialTicks);
        this.field_1918.field_3818.method_9781();
        this.field_1918.field_3767.method_2357();
    }

    @Overwrite
    public String method_1381() {
        return this.renderer.getChunksDebugString();
    }
}

