/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.shader;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.caffeinemc.mods.sodium.client.gl.shader.GlShader;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderParser;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.minecraft.class_1653;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"Sodium-ShaderLoader");
    private static final boolean OPTION_DEBUG_SHADERS = Objects.equal((Object)System.getProperty("sodium.debug.shaders.dump", "false"), (Object)"true");

    public static GlShader loadShader(ShaderType type, class_1653 name, ShaderConstants constants) {
        ShaderParser.ParsedShader parsedShader = ShaderParser.parseShader(ShaderLoader.getShaderSource(name), constants);
        if (OPTION_DEBUG_SHADERS) {
            LOGGER.info("Loaded shader {} with constants {}", new Object[]{name, constants});
            LOGGER.info(parsedShader.src());
        }
        return new GlShader(type, name, parsedShader);
    }

    public static String getShaderSource(class_1653 name) {
        String string;
        block9: {
            String path = String.format("/assets/%s/shaders/%s", name.method_5891(), name.method_5890());
            InputStream in = ShaderLoader.class.getResourceAsStream(path);
            try {
                if (in == null) {
                    throw new RuntimeException("Shader not found: " + path);
                }
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read shader source for " + path, e);
                }
            }
            in.close();
        }
        return string;
    }
}

