/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.caffeinemc.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptions;
import net.caffeinemc.mods.sodium.client.gui.SodiumOptionsGUI;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.CyclingControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.named.GraphicsMode;
import net.caffeinemc.mods.sodium.client.gui.options.named.ParticleMode;
import net.caffeinemc.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import net.caffeinemc.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_1990;
import net.minecraft.class_388;
import net.minecraft.class_389;
import org.lwjgl.opengl.Display;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();
    private static final class_389 window = new class_389(class_1600.method_2965());

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.renderDistance", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.view_distance.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.chunks())).setBinding((options, value) -> {
            options.field_7668 = value;
        }, options -> options.field_7668).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.gamma", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.brightness.tooltip", new Object[0])).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_959 = (float)value.intValue() * 0.01f;
        }, opts -> (int)((double)opts.field_959 / 0.01)).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.guiScale", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.gui_scale.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 3, 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_961 = value;
            if (class_1600.method_2965().field_3816 instanceof SodiumOptionsGUI) {
                class_1600.method_2965().method_2928((class_388)new SodiumOptionsGUI(((SodiumOptionsGUI)class_1600.method_2965().field_3816).prevScreen));
            }
        }, opts -> opts.field_961).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.fullscreen", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.fullscreen.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_990 = value;
            class_1600 client = class_1600.method_2965();
            if (client.method_2913() != opts.field_990) {
                client.method_2953();
                opts.field_990 = client.method_2913();
            }
        }, opts -> opts.field_990).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.vsync", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.v_sync.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_991 = value;
            Display.setVSyncEnabled(value);
        }, opts -> opts.field_991).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.framerateLimit", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.fps_limit.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 10, 260, 10, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_978 = value;
        }, opts -> opts.field_978).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.viewBobbing", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.view_bobbing.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_975 = value;
        }, opts -> opts.field_975).build()).build());
        return new OptionPage((class_1982)new class_1990("stat.generalButton", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsMode.class, vanillaOpts).setName((class_1982)new class_1990("options.graphics", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.graphics_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<GraphicsMode>((Option<GraphicsMode>)option, GraphicsMode.class)).setBinding((opts, value) -> {
            opts.field_979 = value.isFancy();
        }, opts -> GraphicsMode.fromBoolean(opts.field_979)).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("options.renderClouds", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.clouds_quality.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableClouds = value;
        }, opts -> opts.quality.enableClouds).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.cloud_height.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.cloud_height.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 128, 230, 1, ControlValueFormatter.number())).setBinding((opts, value) -> {
            opts.quality.cloudHeight = value;
        }, opts -> opts.quality.cloudHeight).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((class_1982)new class_1990("soundCategory.weather", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.weather_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((class_1982)new class_1990("sodium.options.leaves_quality.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.leaves_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleMode.class, vanillaOpts).setName((class_1982)new class_1990("options.particles", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.particle_quality.tooltip", new Object[0])).setControl(opt -> new CyclingControl<ParticleMode>((Option<ParticleMode>)opt, ParticleMode.class)).setBinding((opts, value) -> {
            opts.field_962 = value.ordinal();
        }, opts -> ParticleMode.fromOrdinal(opts.field_962)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.LightingQuality.class, sodiumOpts).setName((class_1982)new class_1990("options.ao", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.smooth_lighting.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.LightingQuality>((Option<SodiumGameOptions.LightingQuality>)option, SodiumGameOptions.LightingQuality.class)).setBinding((opts, value) -> {
            opts.quality.smoothLighting = value;
        }, opts -> opts.quality.smoothLighting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.biome_blend.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.biome_blend.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 1, 7, 1, ControlValueFormatter.biomeBlend())).setBinding((opts, value) -> {
            opts.quality.biomeBlendRadius = value;
        }, opts -> opts.quality.biomeBlendRadius).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.entityShadows", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.entity_shadows.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_10322 = value;
        }, opts -> opts.field_10322).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.vignette.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.vignette.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((class_1982)new class_1990("options.mipmapLevels", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.mipmap_levels.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_7637 = value;
        }, opts -> opts.field_7637).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage((class_1982)new class_1990("sodium.options.pages.quality", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.chunk_update_threads.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.chunk_update_threads.tooltip", new Object[0])).setControl(o -> new SliderControl((Option<Integer>)o, 0, Runtime.getRuntime().availableProcessors(), 1, ControlValueFormatter.quantityOrDisabled("threads", "Default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.always_defer_chunk_updates.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.always_defer_chunk_updates.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.use_block_face_culling.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.use_block_face_culling.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useBlockFaceCulling = value;
        }, opts -> opts.performance.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.use_fog_occlusion.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.use_fog_occlusion.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.performance.useFogOcclusion = value;
        }, opts -> opts.performance.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.use_entity_culling.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.use_entity_culling.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useEntityCulling = value;
        }, opts -> opts.performance.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.smart_cull.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.smart_cull.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.smartCull = value;
        }, opts -> opts.performance.smartCull).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.animate_only_visible_textures.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.animate_only_visible_textures.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.animateOnlyVisibleTextures = value;
        }, opts -> opts.performance.animateOnlyVisibleTextures).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.sort_behavior.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.sort_behavior.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                opts.performance.sortingEnabled = value;
            }, opts -> opts.performance.sortingEnabled).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        }
        return new OptionPage((class_1982)new class_1990("sodium.options.pages.performance", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        boolean isPersistentMappingSupported = MappedStagingBuffer.isSupported(RenderDevice.INSTANCE);
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.use_persistent_mapping.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.use_persistent_mapping.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setEnabled(() -> isPersistentMappingSupported).setBinding((opts, value) -> {
            opts.advanced.useAdvancedStagingBuffers = value;
        }, opts -> opts.advanced.useAdvancedStagingBuffers).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.cpu_render_ahead.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.cpu_render_ahead.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.cpuRenderAhead = value;
        }, opts -> opts.advanced.cpuRenderAhead).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.cpu_render_ahead_limit.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.cpu_render_ahead_limit.tooltip", new Object[0])).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 9, 1, ControlValueFormatter.translateVariable("sodium.options.cpu_render_ahead_limit.value"))).setBinding((opts, value) -> {
            opts.advanced.cpuRenderAheadLimit = value;
        }, opts -> opts.advanced.cpuRenderAheadLimit).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1990("sodium.options.fps_overlay.name", new Object[0])).setTooltip((class_1982)new class_1990("sodium.options.fps_overlay.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.fpsOverlay = value;
        }, opts -> opts.advanced.fpsOverlay).build()).build());
        return new OptionPage((class_1982)new class_1990("sodium.options.pages.advanced", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage particleCulling() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1989("Particle Culling")).setTooltip((class_1982)new class_1989("Enable particle culling to improve performance by skipping rendering of particles that are not visible.")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.particleCulling.cullingEnabled = value;
        }, opts -> opts.particleCulling.cullingEnabled).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1989("Cull Behind Blocks")).setTooltip((class_1982)new class_1989("Enable culling of particles that are behind blocks. This can improve performance in some situations.")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleCulling.cullBehindBlocks = value;
        }, opts -> opts.particleCulling.cullBehindBlocks).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1989("Cull Behind Glass")).setTooltip((class_1982)new class_1989("Enable culling of particles that are behind glass blocks. This can improve performance in some situations.")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleCulling.cullBehindGlass = value;
        }, opts -> opts.particleCulling.cullBehindGlass).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((class_1982)new class_1989("Cull In Spectator Mode")).setTooltip((class_1982)new class_1989("Enable culling of particles when in spectator mode. This can improve performance in spectator mode.")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleCulling.cullInSpectator = value;
        }, opts -> opts.particleCulling.cullInSpectator).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((class_1982)new class_1989("Block Buffer")).setTooltip((class_1982)new class_1989("The minimum amount of blocks around the player that will be checked for culling. A higher value may improve performance but can also increase the chance of culling particles that are actually visible.")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 50, 1, ControlValueFormatter.number())).setBinding((opts, value) -> {
            opts.particleCulling.blockBuffer = value;
        }, opts -> opts.particleCulling.blockBuffer).setImpact(OptionImpact.MEDIUM).build()).build());
        return new OptionPage((class_1982)new class_1989("Culling"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

