/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.caffeinemc.mods.sodium.client.gui.options.TextProvider;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.client.util.FileUtil;
import net.minecraft.class_1982;
import net.minecraft.class_1990;

public class SodiumGameOptions {
    private static final String DEFAULT_FILE_NAME = "radium-options.json";
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final PerformanceSettings performance = new PerformanceSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    public final ParticleCullingSettings particleCulling = new ParticleCullingSettings();
    private boolean readOnly;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    private SodiumGameOptions() {
    }

    public static SodiumGameOptions defaults() {
        return new SodiumGameOptions();
    }

    public static SodiumGameOptions loadFromDisk() {
        SodiumGameOptions config;
        block10: {
            Path path = SodiumGameOptions.getConfigPath();
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SodiumGameOptions)GSON.fromJson((Reader)reader, SodiumGameOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new SodiumGameOptions();
        }
        try {
            SodiumGameOptions.writeToDisk(config);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    private static Path getConfigPath() {
        return PlatformRuntimeInformation.getInstance().getConfigDirectory().resolve(DEFAULT_FILE_NAME);
    }

    public static void writeToDisk(SodiumGameOptions config) throws IOException {
        if (config.isReadOnly()) {
            throw new IllegalStateException("Config file is read-only");
        }
        Path path = SodiumGameOptions.getConfigPath();
        Path dir = path.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(dir));
        }
        FileUtil.writeTextRobustly(GSON.toJson((Object)config), path);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public static class QualitySettings {
        public boolean enableClouds = false;
        public int cloudHeight = 160;
        public GraphicsQuality cloudQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality leavesQuality = GraphicsQuality.DEFAULT;
        public LightingQuality smoothLighting = LightingQuality.HIGH;
        public int biomeBlendRadius = 2;
        public boolean enableVignette = true;
    }

    public static class AdvancedSettings {
        public boolean enableMemoryTracing = false;
        public boolean useAdvancedStagingBuffers = true;
        public boolean cpuRenderAhead = true;
        public int cpuRenderAheadLimit = 3;
        public boolean fpsOverlay = false;
    }

    public static class PerformanceSettings {
        public int chunkBuilderThreads = 0;
        @SerializedName(value="always_defer_chunk_updates_v2")
        public boolean alwaysDeferChunkUpdates = true;
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useBlockFaceCulling = true;
        public boolean smartCull = false;
        @SerializedName(value="sorting_enabled_v2")
        public boolean sortingEnabled = true;

        public SortBehavior getSortBehavior() {
            return this.sortingEnabled ? SortBehavior.DYNAMIC_DEFER_NEARBY_ZERO_FRAMES : SortBehavior.OFF;
        }
    }

    public static class NotificationSettings {
        public boolean hasClearedDonationButton = false;
        public boolean hasSeenDonationPrompt = false;
    }

    public static class ParticleCullingSettings {
        public boolean cullingEnabled = true;
        public boolean cullBehindBlocks = true;
        public boolean cullBehindGlass = false;
        public boolean cullInSpectator = false;
        public int blockBuffer = 1;
    }

    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT("generator.default"),
        FANCY("options.graphics.fancy"),
        FAST("options.graphics.fast");

        private final class_1982 name;

        private GraphicsQuality(String name) {
            this.name = new class_1990(name, new Object[0]);
        }

        @Override
        public class_1982 getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(boolean fancy) {
            return this == FANCY || this == DEFAULT && !fancy || fancy;
        }
    }

    public static enum LightingQuality implements TextProvider
    {
        OFF((class_1982)new class_1990("options.ao.off", new Object[0])),
        LOW((class_1982)new class_1990("options.ao.min", new Object[0])),
        HIGH((class_1982)new class_1990("options.ao.max", new Object[0]));

        private final class_1982 name;

        private LightingQuality(class_1982 name) {
            this.name = name;
        }

        @Override
        public class_1982 getLocalizedName() {
            return this.name;
        }
    }
}

