/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui;

import dev.vexor.radium.extra.client.gui.SodiumExtraGameOptionPages;
import dev.vexor.radium.extra.client.gui.scrollable_page.OptionPageScrollFrame;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.console.Console;
import net.caffeinemc.mods.sodium.client.console.message.MessageLevel;
import net.caffeinemc.mods.sodium.client.data.fingerprint.HashedFingerprint;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptionPages;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptions;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPrompt;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPromptable;
import net.caffeinemc.mods.sodium.client.gui.screen.ConfigCorruptedScreen;
import net.caffeinemc.mods.sodium.client.gui.screen.RenderableScreen;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1986;
import net.minecraft.class_1989;
import net.minecraft.class_1990;
import net.minecraft.class_2403;
import net.minecraft.class_2520;
import net.minecraft.class_388;
import net.minecraft.class_520;
import net.minecraft.class_533;
import org.jetbrains.annotations.Nullable;

public class SodiumOptionsGUI
extends RenderableScreen
implements ScreenPromptable {
    public final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final List<ControlElement<?>> controls = new ArrayList();
    public final class_388 prevScreen;
    private OptionPage currentPage;
    protected FlatButtonWidget applyButton;
    protected FlatButtonWidget closeButton;
    protected FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private ControlElement<?> hoveredElement;
    protected boolean hasPendingChanges;
    @Nullable
    private ScreenPrompt prompt;
    private static final List<class_1982> DONATION_PROMPT_MESSAGE = List.of(new class_1989("Hello!"), new class_1989("It seems that you've been enjoying "), new class_1989("Sodium"), new class_1989(", the powerful and open rendering optimization mod for Minecraft."), new class_1989("Mods like these are complex. They require "), new class_1989("thousands of hours"), new class_1989(" of development, debugging, and tuning to create the experience that players have come to expect."), new class_1989("If you'd like to show your token of appreciation, and support the development of our mod in the process, then consider "), new class_1989("buying us a coffee"), new class_1989("."), new class_1989("And thanks again for using our mod! We hope it helps you (and your computer.)"));

    public SodiumOptionsGUI(class_388 prevScreen) {
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.performance());
        this.pages.add(SodiumGameOptionPages.advanced());
        this.pages.add(SodiumGameOptionPages.particleCulling());
        this.pages.add(SodiumExtraGameOptionPages.animation());
        this.pages.add(SodiumExtraGameOptionPages.particle());
        this.pages.add(SodiumExtraGameOptionPages.detail());
        this.pages.add(SodiumExtraGameOptionPages.render());
        this.pages.add(SodiumExtraGameOptionPages.extra());
        this.checkPromptTimers();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        SodiumGameOptions options = SodiumClientMod.options();
        if (options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt(options);
        }
    }

    private void openDonationPrompt(SodiumGameOptions options) {
        ScreenPrompt prompt = new ScreenPrompt(this, DONATION_PROMPT_MESSAGE.stream().map(class_1982::method_7472).toList(), 320, 190, new ScreenPrompt.Action((class_1982)new class_1989("Buy us a coffee"), this::openDonationPage));
        prompt.setFocused(true);
        options.notifications.hasSeenDonationPrompt = true;
        try {
            SodiumGameOptions.writeToDisk(options);
        }
        catch (IOException e) {
            SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
        }
    }

    public static class_388 createScreen(class_388 currentScreen) {
        if (SodiumClientMod.options().isReadOnly()) {
            return new ConfigCorruptedScreen(currentScreen, SodiumOptionsGUI::new);
        }
        return new SodiumOptionsGUI(currentScreen);
    }

    public void setPage(OptionPage page) {
        this.currentPage = page;
        this.rebuildGUI();
    }

    public void method_1044() {
        super.method_1044();
        this.rebuildGUI();
        if (this.prompt != null) {
            this.prompt.init();
        }
    }

    protected void rebuildGUI() {
        this.controls.clear();
        this.clearWidgets();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.field_1230 - 211, this.field_1231 - 30, 65, 20), (class_1982)new class_1990("sodium.options.buttons.undo", new Object[0]), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.field_1230 - 142, this.field_1231 - 30, 65, 20), (class_1982)new class_1990("sodium.options.buttons.apply", new Object[0]), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.field_1230 - 73, this.field_1231 - 30, 65, 20), (class_1982)new class_1990("gui.done", new Object[0]), this::onClose);
        this.donateButton = new FlatButtonWidget(new Dim2i(this.field_1230 - 128, 6, 100, 20), (class_1982)new class_1990("sodium.options.buttons.donate", new Object[0]), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(new Dim2i(this.field_1230 - 26, 6, 20, 20), (class_1982)new class_1989("x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton) {
            this.setDonationButtonVisibility();
        }
        this.addRenderableWidget(this.undoButton);
        this.addRenderableWidget(this.applyButton);
        this.addRenderableWidget(this.closeButton);
        this.addRenderableWidget(this.donateButton);
        this.addRenderableWidget(this.hideDonateButton);
    }

    private void setDonationButtonVisibility() {
        this.donateButton.setVisible(false);
        this.hideDonateButton.setVisible(false);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            SodiumGameOptions.writeToDisk(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility();
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.field_1234.method_954(page.getName().method_7472());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, y, width, 18), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.addRenderableWidget(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(x, y, 240, 18));
                this.addRenderableWidget(element);
                OptionPageScrollFrame optionPageScrollFrame = new OptionPageScrollFrame(new Dim2i(x, y, 240, this.field_1231 - y - 10), this.currentPage);
                this.addRenderableWidget(optionPageScrollFrame);
                this.controls.add(element);
                y += 18;
            }
            y += 4;
        }
    }

    @Override
    public void method_1025(int mouseX, int mouseY, float delta) {
        this.updateControls();
        super.method_1025(this.prompt != null ? -1 : mouseX, this.prompt != null ? -1 : mouseY, delta);
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(this.hoveredElement);
        }
        if (this.prompt != null) {
            this.prompt.render(mouseX, mouseY, delta);
        }
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(AbstractWidget::isHovered).findFirst().orElse(this.getActiveControls().filter(AbstractWidget::isFocused).findFirst().orElse(null));
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hoveredElement = hovered;
        this.hasPendingChanges = hasChanges;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxY = dim.y();
        int boxX = dim.getLimitX() + boxPadding;
        int boxWidth = Math.min(200, this.field_1230 - boxX - boxPadding);
        Option<?> option = element.getOption();
        int splitWidth = boxWidth - textPadding * 2;
        ArrayList tooltip = new ArrayList(this.field_1234.method_971(option.getTooltip().method_7472(), splitWidth));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            class_1990 impactText = new class_1990("sodium.options.performance_impact_string", new Object[]{impact.getLocalizedName()});
            tooltip.addAll(this.field_1234.method_971(impactText.method_7468(new class_1986().method_7486(class_1442.field_5490)).method_7472(), splitWidth));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.field_1231 - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.method_989(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            this.field_1234.method_4247((String)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1);
        }
    }

    protected void method_989(int x1, int y1, int x2, int y2, int color1, int color2) {
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float h = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float i = (float)(color1 & 0xFF) / 255.0f;
        float j = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float k = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float l = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float m = (float)(color2 & 0xFF) / 255.0f;
        class_2403.method_9856();
        class_2403.method_9843();
        class_2403.method_9822();
        class_2403.method_9805((int)770, (int)771, (int)1, (int)0);
        class_2403.method_9841((int)7425);
        class_533 tessellator = class_533.method_9926();
        class_520 bufferBuilder = tessellator.method_9928();
        bufferBuilder.method_9737(7, class_2520.field_11207);
        bufferBuilder.method_9742((double)x2, (double)y1, (double)this.field_1172).method_9731(g, h, i, f).method_9750();
        bufferBuilder.method_9742((double)x1, (double)y1, (double)this.field_1172).method_9731(g, h, i, f).method_9750();
        bufferBuilder.method_9742((double)x1, (double)y2, (double)this.field_1172).method_9731(k, l, m, j).method_9750();
        bufferBuilder.method_9742((double)x2, (double)y2, (double)this.field_1172).method_9731(k, l, m, j).method_9750();
        tessellator.method_9927();
        class_2403.method_9841((int)7424);
        class_2403.method_9842();
        class_2403.method_9828();
        class_2403.method_9855();
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        class_1600 client = class_1600.method_2965();
        if (client.field_3803 != null) {
            if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
                client.field_3804.method_1363();
            } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
                client.field_3804.method_9917();
            }
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.method_5576();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_GAME_RESTART)) {
            Console.instance().logMessage(MessageLevel.WARN, "sodium.console.game_restart", true, 10.0);
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private void openDonationPage() {
        try {
            Desktop.getDesktop().browse(URI.create("https://caffeinemc.net/donate"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void method_1024(char id, int code) {
        if (this.prompt == null || !this.prompt.keyPressed(code, id)) {
            super.method_1024(id, code);
        }
    }

    @Override
    protected void method_1026(int mouseX, int mouseY, int button) {
        if (this.prompt != null) {
            this.prompt.mouseClicked(mouseX, mouseY, button);
        } else {
            super.method_1026(mouseX, mouseY, button);
        }
    }

    public void onClose() {
        this.field_1229.method_2928(this.prevScreen);
    }

    @Override
    public void setPrompt(@Nullable ScreenPrompt prompt) {
        this.prompt = prompt;
    }

    @Override
    @Nullable
    public ScreenPrompt getPrompt() {
        return this.prompt;
    }

    @Override
    public Dim2i getDimensions() {
        return new Dim2i(0, 0, this.field_1230, this.field_1231);
    }

    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }
}

