/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.console;

import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.client.console.Console;
import net.caffeinemc.mods.sodium.client.console.message.Message;
import net.caffeinemc.mods.sodium.client.console.message.MessageLevel;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_1990;
import net.minecraft.class_372;
import net.minecraft.class_389;
import net.minecraft.class_837;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class ConsoleRenderer {
    static final ConsoleRenderer INSTANCE = new ConsoleRenderer();
    private final LinkedList<ActiveMessage> activeMessages = new LinkedList();
    private static final EnumMap<MessageLevel, ColorPalette> COLORS = new EnumMap(MessageLevel.class);

    public void update(Console console, double currentTime) {
        this.purgeMessages(currentTime);
        this.pollMessages(console, currentTime);
    }

    private void purgeMessages(double currentTime) {
        this.activeMessages.removeIf(message -> currentTime > message.timestamp() + message.duration());
    }

    private void pollMessages(Console console, double currentTime) {
        Deque<Message> log = console.getMessageDrain();
        while (!log.isEmpty()) {
            this.activeMessages.add(ActiveMessage.create(log.poll(), currentTime));
        }
    }

    public void draw() {
        long currentTime = Sys.getTime();
        class_1600 minecraft = class_1600.method_2965();
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, 1000.0f);
        int paddingWidth = 3;
        int paddingHeight = 1;
        ArrayList<MessageRender> renders = new ArrayList<MessageRender>();
        int x = 4;
        int y = 4;
        for (ActiveMessage message : this.activeMessages) {
            double opacity = ConsoleRenderer.getMessageOpacity(message, currentTime);
            if (opacity < 0.025) continue;
            int messageWidth = 270;
            ArrayList<String> lines = new ArrayList<String>(minecraft.field_3814.method_971(message.text().method_7472(), messageWidth - 20));
            int messageHeight = minecraft.field_3814.field_1141 * lines.size() + paddingHeight * 2;
            renders.add(new MessageRender(x, y, messageWidth, messageHeight, message.level(), lines, opacity));
            y += messageHeight;
        }
        int scaleFactor = new class_389(minecraft).method_1049();
        int mouseX = minecraft.field_3760.field_931 / scaleFactor;
        int mouseY = minecraft.field_3760.field_932 / scaleFactor;
        boolean hovered = false;
        for (MessageRender render : renders) {
            if (mouseX < render.x || mouseX >= render.x + render.width || mouseY < render.y || mouseY >= render.y + render.height) continue;
            hovered = true;
            break;
        }
        for (MessageRender render : renders) {
            int x2 = render.x();
            int y2 = render.y();
            int width = render.width();
            int height = render.height();
            ColorPalette colors = COLORS.get((Object)render.level());
            double opacity = render.opacity();
            if (hovered) {
                opacity *= 0.4;
            }
            class_372.method_988((int)x2, (int)y2, (int)(x2 + width), (int)(y2 + height), (int)ColorARGB.withAlpha(colors.background(), ConsoleRenderer.weightAlpha(opacity)));
            class_372.method_988((int)x2, (int)y2, (int)(x2 + 1), (int)(y2 + height), (int)ColorARGB.withAlpha(colors.foreground(), ConsoleRenderer.weightAlpha(opacity)));
            for (String line : render.lines()) {
                minecraft.field_3814.method_9417(line, (float)(x2 + paddingWidth + 3), (float)(y2 + paddingHeight), ColorARGB.withAlpha(colors.text(), ConsoleRenderer.weightAlpha(opacity)), false);
                y2 += minecraft.field_3814.field_1141;
            }
        }
        GL11.glPopMatrix();
    }

    private static double getMessageOpacity(ActiveMessage message, double time) {
        double midpoint = message.timestamp() + message.duration() / 2.0;
        if (time > midpoint) {
            return ConsoleRenderer.getFadeOutOpacity(message, time);
        }
        if (time < midpoint) {
            return ConsoleRenderer.getFadeInOpacity(message, time);
        }
        return 1.0;
    }

    private static double getFadeInOpacity(ActiveMessage message, double time) {
        double animationDuration = 0.25;
        double animationStart = message.timestamp();
        double animationEnd = message.timestamp() + animationDuration;
        return ConsoleRenderer.getAnimationProgress(time, animationStart, animationEnd);
    }

    private static double getFadeOutOpacity(ActiveMessage message, double time) {
        double animationDuration = Math.min(0.5, message.duration() * 0.2);
        double animationStart = message.timestamp() + message.duration() - animationDuration;
        double animationEnd = message.timestamp() + message.duration();
        return 1.0 - ConsoleRenderer.getAnimationProgress(time, animationStart, animationEnd);
    }

    private static double getAnimationProgress(double currentTime, double startTime, double endTime) {
        return class_837.method_8339((double)class_837.method_8341((double)startTime, (double)endTime, (double)currentTime), (double)0.0, (double)1.0);
    }

    private static int weightAlpha(double scale) {
        return ColorU8.normalizedFloatToByte((float)scale);
    }

    static {
        COLORS.put(MessageLevel.INFO, new ColorPalette(ColorARGB.pack(255, 255, 255), ColorARGB.pack(15, 15, 15), ColorARGB.pack(15, 15, 15)));
        COLORS.put(MessageLevel.WARN, new ColorPalette(ColorARGB.pack(224, 187, 0), ColorARGB.pack(25, 21, 0), ColorARGB.pack(180, 150, 0)));
        COLORS.put(MessageLevel.SEVERE, new ColorPalette(ColorARGB.pack(220, 0, 0), ColorARGB.pack(25, 0, 0), ColorARGB.pack(160, 0, 0)));
    }

    private record ActiveMessage(MessageLevel level, class_1982 text, double duration, double timestamp) {
        public static ActiveMessage create(Message message, double timestamp) {
            class_1982 text = (message.translated() ? new class_1990(message.text(), new Object[0]) : new class_1989(message.text())).method_7474();
            return new ActiveMessage(message.level(), text, message.duration(), timestamp);
        }
    }

    private record MessageRender(int x, int y, int width, int height, MessageLevel level, List<String> lines, double opacity) {
    }

    private record ColorPalette(int text, int background, int foreground) {
    }
}

