/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.console;

import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.minecraft.class_1600;

public class FPSCounter {
    private static final int SAMPLE_SIZE = 700;
    private static final int FPS_UPDATE_INTERVAL = 100;
    private static final int AVG_UPDATE_INTERVAL = 700;
    public static final FPSCounter INSTANCE = new FPSCounter();
    private final long[] frameTimings = new long[700];
    private int frameIndex = 0;
    private long lastFrameTime = System.nanoTime();
    private boolean isFilled = false;
    private double currentFps = 0.0;
    private double avgFps = 0.0;
    private double avgFrameTime = 0.0;
    private int frameCounter = 0;
    private int avgFrameCounter = 0;

    public void render() {
        class_1600 minecraft = class_1600.method_2965();
        if (!SodiumClientMod.options().advanced.fpsOverlay) {
            return;
        }
        long currentTime = System.nanoTime();
        long deltaTime = currentTime - this.lastFrameTime;
        this.lastFrameTime = currentTime;
        this.frameTimings[this.frameIndex] = deltaTime;
        this.frameIndex = (this.frameIndex + 1) % 700;
        if (this.frameIndex == 0) {
            this.isFilled = true;
        }
        ++this.frameCounter;
        ++this.avgFrameCounter;
        if (this.frameCounter >= 100) {
            this.currentFps = class_1600.method_9393();
            this.frameCounter = 0;
        }
        if (this.avgFrameCounter >= 700) {
            this.avgFrameTime = this.getAvgFt();
            this.avgFps = 1.0E9 / this.avgFrameTime;
            this.avgFrameCounter = 0;
        }
        String finalStr = String.format("%.1f/%.1f FPS | %.2f/%.2f ms", Float.valueOf((float)this.currentFps), this.avgFps, (double)deltaTime / 1000000.0, this.avgFrameTime / 1000000.0);
        minecraft.field_3814.method_956(finalStr, 10.0f, 10.0f, 0xFFFFFF);
    }

    private double getAvgFt() {
        long total = 0L;
        int count = this.isFilled ? 700 : this.frameIndex;
        for (int i = 0; i < count; ++i) {
            total += this.frameTimings[i];
        }
        return (double)total / (double)count;
    }
}

