/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import dev.vexor.radium.options.client.gui.OptionExtended;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1442;
import org.jetbrains.annotations.NotNull;

public class ControlElement<T>
extends AbstractWidget {
    protected final Option<T> option;
    protected final Dim2i dim;

    public ControlElement(Option<T> option, Dim2i dim) {
        this.option = option;
        this.dim = dim;
    }

    public int getContentWidth() {
        return this.option.getControl().getMaxWidth();
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        Object name = this.option.getName().method_7472();
        if (this.option.isAvailable() && this.option.hasChanged()) {
            name = (String)name + " *";
        }
        if (this.hovered || this.isFocused()) {
            name = this.truncateLabelToFit((String)name);
        }
        String label = this.getLabel((String)name);
        this.hovered = this.dim.containsCursor(mouseX, mouseY);
        this.drawRect(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), this.hovered ? -536870912 : -1879048192);
        this.drawString(label, this.dim.x() + 6, this.dim.getCenterY() - 4, -1);
        if (this.isFocused()) {
            this.drawBorder(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -1);
        }
    }

    @NotNull
    private String getLabel(String name) {
        String label;
        if (this.option.isAvailable()) {
            OptionExtended optionExtended;
            Option<T> option = this.option;
            if (option instanceof OptionExtended && (optionExtended = (OptionExtended)option).isHighlight()) {
                class_1442 color = optionExtended.isSelected() ? class_1442.field_5485 : class_1442.field_5497;
                label = String.valueOf(color) + name;
            } else {
                label = String.valueOf(class_1442.field_5498) + name;
            }
        } else {
            label = String.valueOf(class_1442.field_5490) + String.valueOf(class_1442.field_5501) + name;
        }
        return label;
    }

    @NotNull
    private String truncateLabelToFit(String name) {
        int targetWidth;
        String suffix = "...";
        int suffixWidth = this.font.method_954(suffix);
        int nameFontWidth = this.font.method_954((String)name);
        if (nameFontWidth > (targetWidth = this.dim.width() - this.getContentWidth() - 20)) {
            targetWidth -= suffixWidth;
            int maxLabelChars = ((String)name).length() - 3;
            int minLabelChars = 1;
            while (maxLabelChars - minLabelChars > 1) {
                int mid = (maxLabelChars + minLabelChars) / 2;
                String midName = ((String)name).substring(0, mid);
                int midWidth = this.font.method_954(midName);
                if (midWidth > targetWidth) {
                    maxLabelChars = mid;
                    continue;
                }
                minLabelChars = mid;
            }
            name = ((String)name).substring(0, minLabelChars).trim() + suffix;
        }
        return name;
    }

    public Option<T> getOption() {
        return this.option;
    }

    public Dim2i getDimensions() {
        return this.dim;
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        return this.dim.containsCursor(x, y);
    }
}

