/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.prompt;

import dev.vexor.radium.compat.mojang.minecraft.gui.Renderable;
import dev.vexor.radium.compat.mojang.minecraft.gui.event.GuiEventListener;
import java.util.List;
import net.caffeinemc.mods.sodium.client.gui.prompt.ScreenPromptable;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_370;
import net.minecraft.class_372;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ScreenPrompt
implements GuiEventListener,
Renderable {
    private final ScreenPromptable parent;
    private final List<String> text;
    private final Action action;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget actionButton;
    private final int width;
    private final int height;

    public ScreenPrompt(ScreenPromptable parent, List<String> text, int width, int height, Action action) {
        this.parent = parent;
        this.text = text;
        this.width = width;
        this.height = height;
        this.action = action;
    }

    public void init() {
        Dim2i parentDimensions = this.parent.getDimensions();
        int boxX = parentDimensions.width() / 2 - this.width / 2;
        int boxY = parentDimensions.height() / 2 - this.height / 2;
        this.closeButton = new FlatButtonWidget(new Dim2i(boxX + this.width - 84, boxY + this.height - 24, 80, 20), (class_1982)new class_1989("Close"), this::close);
        this.closeButton.setStyle(ScreenPrompt.createButtonStyle());
        this.actionButton = new FlatButtonWidget(new Dim2i(boxX + this.width - 198, boxY + this.height - 24, 110, 20), this.action.label, this::runAction);
        this.actionButton.setStyle(ScreenPrompt.createButtonStyle());
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, 1000.0f);
        Dim2i parentDimensions = this.parent.getDimensions();
        class_372.method_988((int)0, (int)0, (int)parentDimensions.width(), (int)parentDimensions.height(), (int)0x70090909);
        GL11.glTranslatef(0.0f, 0.0f, 50.0f);
        int boxX = parentDimensions.width() / 2 - this.width / 2;
        int boxY = parentDimensions.height() / 2 - this.height / 2;
        class_372.method_988((int)boxX, (int)boxY, (int)(boxX + this.width), (int)(boxY + this.height), (int)-15263977);
        GL11.glTranslatef(0.0f, 0.0f, 50.0f);
        int padding = 5;
        int textX = boxX + padding;
        int textY = boxY + padding;
        int textMaxWidth = this.width - padding * 2;
        int textMaxHeight = this.height - padding * 2;
        class_370 font = class_1600.method_2965().field_3814;
        for (String paragraph : this.text) {
            List formatted = font.method_971(paragraph, textMaxWidth);
            for (String line : formatted) {
                font.method_9417(line, (float)textX, (float)textY, -1, true);
                textY += font.field_1141 + 2;
            }
            textY += 8;
        }
        for (AbstractWidget button : this.getWidgets()) {
            button.render(mouseX, mouseY, delta);
        }
        GL11.glPopMatrix();
    }

    private static FlatButtonWidget.Style createButtonStyle() {
        FlatButtonWidget.Style style = new FlatButtonWidget.Style();
        style.bgDefault = -13948117;
        style.bgHovered = -13027015;
        style.bgDisabled = style.bgDefault;
        style.textDisabled = style.textDefault = -1;
        return style;
    }

    @NotNull
    public List<AbstractWidget> getWidgets() {
        return List.of(this.actionButton, this.closeButton);
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused) {
            this.parent.setPrompt(this);
        } else {
            this.parent.setPrompt(null);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractWidget widget : this.getWidgets()) {
            if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, char scanCode) {
        if (keyCode == Keyboard.KEY_ESCAPE) {
            this.close();
            return true;
        }
        return GuiEventListener.super.keyPressed(keyCode, scanCode);
    }

    @Override
    public boolean isFocused() {
        return this.parent.getPrompt() == this;
    }

    private void close() {
        this.parent.setPrompt(null);
    }

    private void runAction() {
        this.action.runnable.run();
        this.close();
    }

    public record Action(class_1982 label, Runnable runnable) {
    }
}

