/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.light.flat;

import dev.vexor.radium.compat.mojang.minecraft.render.LightTexture;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.data.LightDataAccess;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.minecraft.class_1354;
import net.minecraft.class_2552;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;

    public FlatLightPipeline(LightDataAccess lightCache) {
        this.lightCache = lightCache;
    }

    @Override
    public void calculate(ModelQuadView quad, class_2552 pos, QuadLightData out, class_1354 cullFace, class_1354 lightFace, boolean shade, boolean enhanced) {
        int lightmap;
        if (cullFace != null) {
            lightmap = this.getOffsetLightmap(pos, cullFace);
            Arrays.fill(out.br, this.lightCache.getLevel().getBrightness(lightFace, shade));
        } else {
            int flags = quad.getFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos))) {
                lightmap = this.getOffsetLightmap(pos, lightFace);
                Arrays.fill(out.br, this.lightCache.getLevel().getBrightness(lightFace, shade));
            } else {
                lightmap = LightDataAccess.getEmissiveLightmap(this.lightCache.get(pos));
                Arrays.fill(out.br, this.lightCache.getLevel().getBrightness(lightFace, shade));
            }
        }
        Arrays.fill(out.lm, lightmap);
    }

    private int getOffsetLightmap(class_2552 pos, class_1354 face) {
        int word = this.lightCache.get(pos);
        if (LightDataAccess.unpackEM(word)) {
            return 0xF000F0;
        }
        int adjWord = this.lightCache.get(pos, face);
        return LightTexture.pack(Math.max(LightDataAccess.unpackBL(adjWord), LightDataAccess.unpackLU(word)), LightDataAccess.unpackSL(adjWord));
    }
}

