/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import dev.vexor.radium.compat.mojang.minecraft.render.FogHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTracker;
import net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.minecraft.class_1600;
import net.minecraft.class_2165;
import net.minecraft.class_226;
import net.minecraft.class_231;
import net.minecraft.class_2552;
import net.minecraft.class_321;
import net.minecraft.class_478;
import net.minecraft.class_518;
import net.minecraft.class_530;
import net.minecraft.class_598;
import net.minecraft.class_786;
import net.minecraft.class_839;
import net.minecraft.class_864;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class SodiumWorldRenderer {
    private final class_1600 client;
    private class_478 level;
    private int renderDistance;
    private Vector3d lastCameraPos;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private float lastFogDistance;
    private Matrix4f lastProjectionMatrix;
    private boolean useEntityCulling;
    private RenderSectionManager renderSectionManager;
    private static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;

    public static SodiumWorldRenderer instance() {
        SodiumWorldRenderer instance = SodiumWorldRenderer.instanceNullable();
        if (instance == null) {
            throw new IllegalStateException("No renderer attached to active level");
        }
        return instance;
    }

    public static SodiumWorldRenderer instanceNullable() {
        class_530 class_5302 = class_1600.method_2965().field_3804;
        if (class_5302 instanceof LevelRendererExtension) {
            LevelRendererExtension extension = (LevelRendererExtension)class_5302;
            return extension.sodium$getWorldRenderer();
        }
        return null;
    }

    public SodiumWorldRenderer(class_1600 client) {
        this.client = client;
    }

    public void setLevel(class_478 level) {
        if (this.level == level) {
            return;
        }
        if (this.level != null) {
            this.unloadLevel();
        }
        if (level != null) {
            this.loadLevel(level);
        }
    }

    private void loadLevel(class_478 level) {
        this.level = level;
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void unloadLevel() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        this.level = null;
    }

    public int getVisibleChunkCount() {
        return this.renderSectionManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.markGraphDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.renderSectionManager.getBuilder().isBuildQueueEmpty();
    }

    public void setupTerrain(Viewport viewport, boolean spectator, boolean updateChunksImmediately) {
        NativeBuffer.reclaim(false);
        this.processChunkEvents();
        this.useEntityCulling = SodiumClientMod.options().performance.useEntityCulling;
        if (this.client.field_3823.field_7668 != this.renderDistance) {
            this.reload();
        }
        class_839 profiler = this.client.field_3767;
        profiler.method_2356("camera_setup");
        class_518 player = this.client.field_10310;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        CameraTransform cam = viewport.getTransform();
        Vector3d pos = new Vector3d(cam.x, cam.y, cam.z);
        Matrix4f projectionMatrix = new Matrix4f(class_321.field_897);
        float pitch = class_321.method_9373();
        float yaw = class_321.method_9375();
        float fogDistance = FogHelper.getFogEnd();
        if (this.lastCameraPos == null) {
            this.lastCameraPos = new Vector3d(pos);
        }
        if (this.lastProjectionMatrix == null) {
            this.lastProjectionMatrix = new Matrix4f(projectionMatrix);
        }
        boolean cameraLocationChanged = !pos.equals(this.lastCameraPos);
        boolean cameraAngleChanged = (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw || fogDistance != this.lastFogDistance;
        boolean cameraProjectionChanged = !projectionMatrix.equals(this.lastProjectionMatrix);
        this.lastProjectionMatrix = projectionMatrix;
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        if (cameraLocationChanged || cameraAngleChanged || cameraProjectionChanged) {
            this.renderSectionManager.markGraphDirty();
        }
        this.lastFogDistance = fogDistance;
        this.renderSectionManager.updateCameraState(pos);
        if (cameraLocationChanged) {
            profiler.method_2360("translucent_triggering");
            this.renderSectionManager.processGFNIMovement(new CameraMovement(this.lastCameraPos, pos));
            this.lastCameraPos = new Vector3d(pos);
        }
        int maxChunkUpdates = updateChunksImmediately ? this.renderDistance : 1;
        for (int i = 0; i < maxChunkUpdates; ++i) {
            if (this.renderSectionManager.needsUpdate()) {
                profiler.method_2360("chunk_render_lists");
                this.renderSectionManager.update(viewport, spectator);
            }
            profiler.method_2360("chunk_update");
            this.renderSectionManager.cleanupAndFlip();
            this.renderSectionManager.updateChunks(updateChunksImmediately);
            profiler.method_2360("chunk_upload");
            this.renderSectionManager.uploadChunks();
            if (!this.renderSectionManager.needsUpdate()) break;
        }
        profiler.method_2360("chunk_render_tick");
        this.renderSectionManager.tickVisibleRenders();
        profiler.method_2357();
    }

    private void processChunkEvents() {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.level);
        tracker.forEachEvent(this.renderSectionManager::onChunkAdded, this.renderSectionManager::onChunkRemoved);
    }

    public void drawChunkLayer(class_2165 renderLayer, ChunkRenderMatrices matrices, double x, double y, double z) {
        this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.fromLayer(renderLayer), x, y, z);
    }

    public void reload() {
        if (this.level == null) {
            return;
        }
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void initRenderer(CommandList commandList) {
        if (this.renderSectionManager != null) {
            this.renderSectionManager = null;
        }
        this.renderDistance = this.client.field_3823.field_7668;
        this.renderSectionManager = new RenderSectionManager(this.level, this.renderDistance, commandList);
        ChunkTracker tracker = ChunkTrackerHolder.get(this.level);
        ChunkTracker.forEachChunk(tracker.getReadyChunks(), this.renderSectionManager::onChunkAdded);
    }

    public void renderBlockEntities(Map<Integer, class_786> blockBreakingProgressions, float tickDelta) {
        Vector3d cameraPos = this.lastCameraPos;
        double x = cameraPos.x;
        double y = cameraPos.y;
        double z = cameraPos.z;
        class_518 player = this.client.field_10310;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        class_598 blockEntityRenderer = class_598.field_2188;
        this.renderBlockEntities(blockBreakingProgressions, tickDelta, x, y, z, blockEntityRenderer, player);
        this.renderGlobalBlockEntities(blockBreakingProgressions, tickDelta, x, y, z, blockEntityRenderer, player);
    }

    private void renderBlockEntities(Map<Integer, class_786> blockBreakingProgressions, float tickDelta, double x, double y, double z, class_598 blockEntityRenderer, class_518 player) {
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                class_226[] blockEntities = renderSection.getCulledBlockEntities();
                if (blockEntities == null) continue;
                for (class_226 blockEntity : blockEntities) {
                    SodiumWorldRenderer.renderBlockEntity(blockBreakingProgressions, tickDelta, x, y, z, blockEntityRenderer, blockEntity, player);
                }
            }
        }
    }

    private void renderGlobalBlockEntities(Map<Integer, class_786> blockBreakingProgressions, float tickDelta, double x, double y, double z, class_598 blockEntityRenderer, class_518 player) {
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            class_226[] blockEntities = renderSection.getGlobalBlockEntities();
            if (blockEntities == null) continue;
            for (class_226 blockEntity : blockEntities) {
                SodiumWorldRenderer.renderBlockEntity(blockBreakingProgressions, tickDelta, x, y, z, blockEntityRenderer, blockEntity, player);
            }
        }
    }

    private static int destroyProgress(Map<Integer, class_786> progressions, class_2552 pos) {
        for (class_786 value : progressions.values()) {
            if (!value.method_2091().equals((Object)pos)) continue;
            return value.method_2093();
        }
        return -1;
    }

    private static void renderBlockEntity(Map<Integer, class_786> blockBreakingProgressions, float tickDelta, double x, double y, double z, class_598 dispatcher, class_226 entity, class_518 player) {
        class_2552 pos = entity.method_8983();
        class_2552 offset = pos.method_10486(-x, -y, -z);
        int destroyProgress = SodiumWorldRenderer.destroyProgress(blockBreakingProgressions, offset);
        dispatcher.method_10101(entity, tickDelta, destroyProgress);
    }

    public void iterateVisibleBlockEntities(Consumer<class_226> blockEntityConsumer) {
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                class_226[] blockEntities = renderSection.getCulledBlockEntities();
                if (blockEntities == null) continue;
                for (class_226 blockEntity : blockEntities) {
                    blockEntityConsumer.accept(blockEntity);
                }
            }
        }
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            class_226[] blockEntities = renderSection.getGlobalBlockEntities();
            if (blockEntities == null) continue;
            for (class_226 blockEntity : blockEntities) {
                blockEntityConsumer.accept(blockEntity);
            }
        }
    }

    public <T extends class_864> boolean isEntityVisible(T entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        if (entity.method_5394()) {
            return true;
        }
        class_231 bb = entity.method_10945();
        double entityVolume = (bb.field_585 - bb.field_582) * (bb.field_586 - bb.field_583) * (bb.field_587 - bb.field_584);
        if (entityVolume > 61440.0) {
            return true;
        }
        return this.isBoxVisible(bb.field_582, bb.field_583, bb.field_584, bb.field_585, bb.field_586, bb.field_587);
    }

    public boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (y2 < 0.5 || y1 > 255.5) {
            return true;
        }
        int minX = SectionPos.posToSectionCoord(x1 - 0.5);
        int minY = SectionPos.posToSectionCoord(y1 - 0.5);
        int minZ = SectionPos.posToSectionCoord(z1 - 0.5);
        int maxX = SectionPos.posToSectionCoord(x2 + 0.5);
        int maxY = SectionPos.posToSectionCoord(y2 + 0.5);
        int maxZ = SectionPos.posToSectionCoord(z2 + 0.5);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.renderSectionManager.isSectionVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getChunksDebugString() {
        return String.format("C: %d/%d D: %d", this.renderSectionManager.getVisibleChunkCount(), this.renderSectionManager.getTotalSections(), this.renderDistance);
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.renderSectionManager.scheduleRebuild(x, y, z, important);
    }

    public Collection<String> getDebugStrings() {
        return this.renderSectionManager.getDebugStrings();
    }

    public boolean isSectionReady(int x, int y, int z) {
        return this.renderSectionManager.isSectionBuilt(x, y, z);
    }
}

