/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.PresentTranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.util.BlockRenderType;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1;
import net.minecraft.class_1158;
import net.minecraft.class_1392;
import net.minecraft.class_1600;
import net.minecraft.class_197;
import net.minecraft.class_2232;
import net.minecraft.class_226;
import net.minecraft.class_2484;
import net.minecraft.class_2528;
import net.minecraft.class_2552;
import net.minecraft.class_598;
import net.minecraft.class_599;
import net.minecraft.class_839;
import net.minecraft.class_875;
import org.joml.Vector3dc;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final ChunkRenderContext renderContext;

    public ChunkBuilderMeshingTask(RenderSection render, int buildTime, Vector3dc absoluteCameraPos, ChunkRenderContext renderContext) {
        super(render, buildTime, absoluteCameraPos);
        this.renderContext = renderContext;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        class_839 profiler = class_1600.method_2965().field_3767;
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        class_2484 occluder = new class_2484();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        LevelSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        class_2552.class_2553 blockPos = new class_2552.class_2553(minX, minY, minZ);
        class_2552.class_2553 modelOffset = new class_2552.class_2553();
        TranslucentGeometryCollector collector = null;
        if (SodiumClientMod.options().performance.getSortBehavior() != SortBehavior.OFF) {
            collector = new TranslucentGeometryCollector(this.render.getPosition());
        }
        BlockRenderContext context = new BlockRenderContext(slice, collector);
        profiler.method_2356("render blocks");
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        class_599 renderer;
                        class_226 entity;
                        blockPos.method_10512(x, y, z);
                        TerrainRenderPass[] blockState = slice.method_8580((class_2552)blockPos);
                        class_197 block = blockState.method_9028();
                        int blockType = block.method_429();
                        if (BlockRenderType.isInvisible(blockType) && !block.method_478()) continue;
                        blockState = block.method_8656((class_2232)blockState, (class_1158)slice, (class_2552)blockPos);
                        modelOffset.method_10512(x & 0xF, y & 0xF, z & 0xF);
                        if (BlockRenderType.isModel(blockType)) {
                            class_2528 model = cache.getBlockModels().method_9944((class_2232)blockState);
                            context.update((class_2552)blockPos, (class_2552)modelOffset, (class_2232)blockState, model);
                            cache.getBlockRenderer().renderModel(context, buffers);
                        }
                        if (BlockRenderType.isLiquid(blockType)) {
                            cache.getFluidRenderer().render(slice, (class_2232)blockState, (class_2232)blockState, (class_2552)blockPos, (class_2552)modelOffset, collector, buffers);
                        }
                        if (block.method_478() && (entity = slice.method_8581((class_2552)blockPos)) != null && (renderer = class_598.field_2188.method_1630(entity)) != null) {
                            entity.method_8982(new class_2552(x, y, z));
                            renderData.addBlockEntity(entity, false);
                        }
                        if (!block.method_449()) continue;
                        occluder.method_10181((class_2552)blockPos);
                    }
                }
            }
        }
        catch (class_875 ex) {
            throw this.fillCrashInfo(ex.method_2682(), slice, (class_2552)blockPos);
        }
        catch (Exception ex) {
            throw this.fillCrashInfo(class_1.method_4084((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (class_2552)blockPos);
        }
        profiler.method_2360("mesh appenders");
        SortType sortType = SortType.NONE;
        if (collector != null) {
            sortType = collector.finishRendering();
        }
        Reference2ReferenceOpenHashMap<TerrainRenderPass, BuiltSectionMeshParts> meshes = new Reference2ReferenceOpenHashMap<TerrainRenderPass, BuiltSectionMeshParts>();
        int visibleSlices = DefaultChunkRenderer.getVisibleFaces((int)this.absoluteCameraPos.x(), (int)this.absoluteCameraPos.y(), (int)this.absoluteCameraPos.z(), this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ());
        profiler.method_2360("meshing");
        for (TerrainRenderPass pass2 : DefaultTerrainRenderPasses.ALL) {
            boolean sliceReordering;
            boolean translucentBehavior = collector != null && pass2.isTranslucent();
            boolean forceUnassigned = translucentBehavior && sortType.needsDirectionMixing;
            BuiltSectionMeshParts mesh2 = buffers.createMesh(pass2, visibleSlices, forceUnassigned, sliceReordering = !translucentBehavior || sortType.allowSliceReordering);
            if (mesh2 == null) continue;
            meshes.put(pass2, mesh2);
            renderData.addRenderPass(pass2);
        }
        if (cancellationToken.isCancelled()) {
            meshes.forEach((pass, mesh) -> mesh.getVertexData().free());
            profiler.method_2357();
            return null;
        }
        renderData.setOcclusionData(occluder.method_10176());
        profiler.method_2360("translucency sorting");
        boolean reuseUploadedData = false;
        TranslucentData translucentData = null;
        if (collector != null) {
            TranslucentData oldData = this.render.getTranslucentData();
            translucentData = collector.getTranslucentData(oldData, (BuiltSectionMeshParts)meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT), this);
            reuseUploadedData = translucentData == oldData;
        }
        ChunkBuildOutput output = new ChunkBuildOutput(this.render, this.submitTime, translucentData, renderData.build(), meshes);
        if (collector != null) {
            if (reuseUploadedData) {
                output.markAsReusingUploadedData();
            } else if (translucentData instanceof PresentTranslucentData) {
                PresentTranslucentData present = (PresentTranslucentData)translucentData;
                Sorter sorter = present.getSorter();
                sorter.writeIndexBuffer(this, true);
                output.setSorter(sorter);
            }
        }
        profiler.method_2357();
        return output;
    }

    private class_875 fillCrashInfo(class_1 report, LevelSlice slice, class_2552 pos) {
        class_1392 crashReportSection = report.method_6613("Block being rendered", 1);
        crashReportSection.method_4427("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.method_4427("Render context volume", (Object)this.renderContext.volume());
        }
        return new class_875(report);
    }

    @Override
    public int getEffort() {
        return 10;
    }
}

