/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.data;

import net.caffeinemc.mods.sodium.client.util.UInt32;
import org.lwjgl.system.MemoryUtil;

public class SectionRenderDataUnsafe {
    private static final long OFFSET_BASE_ELEMENT = 0L;
    private static final long OFFSET_BASE_VERTEX = 4L;
    private static final long OFFSET_FACING_LIST = 8L;
    private static final long OFFSET_IS_LOCAL_INDEX = 15L;
    private static final long OFFSET_SLICE_MASK = 16L;
    private static final long OFFSET_ELEMENT_COUNTS = 20L;
    private static final long ALIGNMENT = 8L;
    private static final long STRIDE = 48L;

    public static long allocateHeap(int count) {
        long bytes = 48L * (long)count;
        long ptr = MemoryUtil.nmemAlignedAlloc(8L, bytes);
        MemoryUtil.memSet(ptr, 0, bytes);
        return ptr;
    }

    public static void freeHeap(long pointer) {
        MemoryUtil.nmemAlignedFree(pointer);
    }

    public static void clearFull(long pointer) {
        MemoryUtil.memSet(pointer, 0, 48L);
    }

    public static void clearVertexData(long ptr) {
        int baseElement = MemoryUtil.memGetInt(ptr + 0L);
        byte isLocalIndexByte = MemoryUtil.memGetByte(ptr + 15L);
        SectionRenderDataUnsafe.clearFull(ptr);
        MemoryUtil.memPutInt(ptr + 0L, baseElement);
        MemoryUtil.memPutByte(ptr + 15L, isLocalIndexByte);
    }

    public static void clearIndexData(long ptr) {
        MemoryUtil.memPutInt(ptr + 0L, 0);
        MemoryUtil.memPutByte(ptr + 15L, (byte)0);
    }

    public static long heapPointer(long ptr, int index) {
        return ptr + (long)index * 48L;
    }

    public static void setLocalBaseElement(long ptr, long value) {
        MemoryUtil.memPutInt(ptr + 0L, UInt32.downcast(value));
        MemoryUtil.memPutByte(ptr + 15L, (byte)1);
    }

    public static void setSharedBaseElement(long ptr, long value) {
        MemoryUtil.memPutInt(ptr + 0L, UInt32.downcast(value));
        MemoryUtil.memPutByte(ptr + 15L, (byte)0);
    }

    public static long getBaseElement(long ptr) {
        return Integer.toUnsignedLong(MemoryUtil.memGetInt(ptr + 0L));
    }

    public static void setSliceMask(long ptr, int value) {
        MemoryUtil.memPutInt(ptr + 16L, value);
    }

    public static int getSliceMask(long ptr) {
        return MemoryUtil.memGetInt(ptr + 16L);
    }

    public static void setFacingList(long ptr, long facingList) {
        byte isLocalIndexByte = MemoryUtil.memGetByte(ptr + 15L);
        MemoryUtil.memPutLong(ptr + 8L, facingList);
        MemoryUtil.memPutByte(ptr + 15L, isLocalIndexByte);
    }

    public static long getFacingList(long ptr) {
        return MemoryUtil.memGetLong(ptr + 8L);
    }

    public static boolean isLocalIndex(long ptr) {
        return MemoryUtil.memGetByte(ptr + 15L) != 0;
    }

    public static void setBaseVertex(long ptr, long value) {
        MemoryUtil.memPutInt(ptr + 4L, UInt32.downcast(value));
    }

    public static long getBaseVertex(long ptr) {
        return UInt32.upcast(MemoryUtil.memGetInt(ptr + 4L));
    }

    public static void setVertexCount(long ptr, int index, long count) {
        MemoryUtil.memPutInt(ptr + 20L + (long)(index * 4), UInt32.downcast(count));
    }

    public static long getVertexCount(long ptr, int index) {
        return UInt32.upcast(MemoryUtil.memGetInt(ptr + 20L + (long)(index * 4)));
    }
}

