/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import java.nio.IntBuffer;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.SplitDirectionData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.StaticSorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.sorting.RadixSort;

public class StaticNormalRelativeData
extends SplitDirectionData {
    private Sorter sorterOnce;

    public StaticNormalRelativeData(SectionPos sectionPos, int[] vertexCounts, int quadCount) {
        super(sectionPos, vertexCounts, quadCount);
    }

    @Override
    public SortType getSortType() {
        return SortType.STATIC_NORMAL_RELATIVE;
    }

    @Override
    public Sorter getSorter() {
        Sorter sorter = this.sorterOnce;
        if (sorter == null) {
            throw new IllegalStateException("Sorter already used!");
        }
        this.sorterOnce = null;
        return sorter;
    }

    private static StaticNormalRelativeData fromDoubleUnaligned(int[] vertexCounts, TQuad[] quads, SectionPos sectionPos) {
        StaticNormalRelativeData snrData = new StaticNormalRelativeData(sectionPos, vertexCounts, quads.length);
        StaticSorter sorter = new StaticSorter(quads.length);
        snrData.sorterOnce = sorter;
        IntBuffer indexBuffer = sorter.getIntBuffer();
        if (quads.length <= 1) {
            TranslucentData.writeQuadVertexIndexes(indexBuffer, 0);
        } else {
            int[] keys = new int[quads.length];
            int[] perm = new int[quads.length];
            for (int q = 0; q < quads.length; ++q) {
                keys[q] = MathUtil.floatToComparableInt(quads[q].getAccurateDotProduct());
                perm[q] = q;
            }
            RadixSort.sortIndirect(perm, keys, false);
            for (int i = 0; i < quads.length; ++i) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, perm[i]);
            }
        }
        return snrData;
    }

    private static StaticNormalRelativeData fromMixed(int[] vertexCounts, TQuad[] quads, SectionPos sectionPos) {
        StaticNormalRelativeData snrData = new StaticNormalRelativeData(sectionPos, vertexCounts, quads.length);
        StaticSorter sorter = new StaticSorter(quads.length);
        snrData.sorterOnce = sorter;
        IntBuffer indexBuffer = sorter.getIntBuffer();
        int maxQuadCount = 0;
        for (int vertexCount : vertexCounts) {
            if (vertexCount == -1) continue;
            int quadCount = TranslucentData.vertexCountToQuadCount(vertexCount);
            maxQuadCount = Math.max(maxQuadCount, quadCount);
        }
        int quadIndex = 0;
        for (int vertexCount : vertexCounts) {
            int idx;
            if (vertexCount == -1 || vertexCount == 0) continue;
            int count = TranslucentData.vertexCountToQuadCount(vertexCount);
            if (count == 1) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, 0);
                ++quadIndex;
                continue;
            }
            int[] keys = new int[count];
            int[] perm = new int[count];
            for (idx = 0; idx < count; ++idx) {
                keys[idx] = MathUtil.floatToComparableInt(quads[quadIndex++].getAccurateDotProduct());
                perm[idx] = idx;
            }
            RadixSort.sortIndirect(perm, keys, false);
            for (idx = 0; idx < count; ++idx) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, perm[idx]);
            }
        }
        return snrData;
    }

    public static StaticNormalRelativeData fromMesh(int[] vertexCounts, TQuad[] quads, SectionPos sectionPos, boolean isDoubleUnaligned) {
        if (isDoubleUnaligned) {
            return StaticNormalRelativeData.fromDoubleUnaligned(vertexCounts, quads, sectionPos);
        }
        return StaticNormalRelativeData.fromMixed(vertexCounts, quads, sectionPos);
    }
}

