/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import java.util.function.IntConsumer;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalList;
import net.caffeinemc.mods.sodium.client.util.collections.BitArray;
import org.joml.Vector3fc;

public class TopoGraphSorting {
    private static final float HALF_SPACE_EPSILON = 0.001f;

    private TopoGraphSorting() {
    }

    private static boolean pointOutsideHalfSpace(float planeDistance, Vector3fc planeNormal, Vector3fc point) {
        return planeNormal.dot(point) > planeDistance;
    }

    private static boolean pointInsideHalfSpaceEpsilon(float planeDistance, Vector3fc planeNormal, float x, float y, float z) {
        return planeNormal.dot(x, y, z) + 0.001f < planeDistance;
    }

    private static boolean pointOutsideHalfSpaceEpsilon(float planeDistance, Vector3fc planeNormal, float x, float y, float z) {
        return planeNormal.dot(x, y, z) - 0.001f > planeDistance;
    }

    public static boolean orthogonalQuadVisibleThrough(TQuad quadA, TQuad quadB) {
        boolean vis;
        int aDirection = quadA.getFacing().ordinal();
        int aOpposite = quadA.getFacing().getOpposite().ordinal();
        int bDirection = quadB.getFacing().ordinal();
        int aSign = quadA.getFacing().getSign();
        int bSign = quadB.getFacing().getSign();
        float[] aExtents = quadA.getExtents();
        float[] bExtents = quadB.getExtents();
        float BIntoADescent = (float)aSign * aExtents[aDirection] - (float)aSign * bExtents[aOpposite];
        float AOutsideBAscent = (float)bSign * aExtents[bDirection] - (float)bSign * bExtents[bDirection];
        boolean bl = vis = BIntoADescent > 0.0f && AOutsideBAscent > 0.0f;
        if (vis && TQuad.extentsIntersect(aExtents, bExtents)) {
            return BIntoADescent + AOutsideBAscent > 1.0f;
        }
        return vis;
    }

    private static boolean testSeparatorRange(Object2ReferenceMap<Vector3fc, float[]> distancesByNormal, Vector3fc normal, float start, float end) {
        float[] distances = (float[])distancesByNormal.get(normal);
        if (distances == null) {
            return false;
        }
        return NormalList.queryRange(distances, start, end);
    }

    private static boolean visibilityWithSeparator(TQuad quadA, TQuad quadB, Object2ReferenceMap<Vector3fc, float[]> distancesByNormal, Vector3fc cameraPos) {
        for (int direction = 0; direction < ModelQuadFacing.DIRECTIONS; ++direction) {
            Vector3fc facingNormal;
            float cameraDistance;
            float separatorRangeEnd;
            ModelQuadFacing facing = ModelQuadFacing.VALUES[direction];
            ModelQuadFacing oppositeFacing = facing.getOpposite();
            int oppositeDirection = oppositeFacing.ordinal();
            int sign = facing.getSign();
            float separatorRangeStart = (float)sign * quadB.getExtents()[direction];
            if (separatorRangeStart > (separatorRangeEnd = (float)sign * quadA.getExtents()[oppositeDirection]) || (cameraDistance = (facingNormal = ModelQuadFacing.ALIGNED_NORMALS[direction]).dot(cameraPos)) > separatorRangeEnd || !TopoGraphSorting.testSeparatorRange(distancesByNormal, facingNormal, separatorRangeStart = cameraDistance, separatorRangeEnd)) continue;
            return false;
        }
        return true;
    }

    private static boolean quadVisibleThrough(TQuad quad, TQuad other, Object2ReferenceMap<Vector3fc, float[]> distancesByNormal, Vector3fc cameraPos) {
        if (quad == other) {
            return false;
        }
        ModelQuadFacing quadFacing = quad.getFacing();
        ModelQuadFacing otherFacing = other.getFacing();
        boolean result = false;
        if (quadFacing != ModelQuadFacing.UNASSIGNED && otherFacing != ModelQuadFacing.UNASSIGNED) {
            if (quadFacing.getOpposite() == otherFacing) {
                return false;
            }
            if (quadFacing == otherFacing) {
                int sign = quadFacing.getSign();
                int direction = quadFacing.ordinal();
                result = (float)sign * quad.getExtents()[direction] > (float)sign * other.getExtents()[direction];
            } else {
                result = TopoGraphSorting.orthogonalQuadVisibleThrough(quad, other);
            }
        } else {
            float quadDot = quad.getAccurateDotProduct();
            Vector3fc quadNormal = quad.getAccurateNormal();
            float[] otherVertexPositions = other.getVertexPositions();
            boolean otherInsideQuad = false;
            int itemIndex = 0;
            for (int i = 0; i < 4; ++i) {
                if (!TopoGraphSorting.pointInsideHalfSpaceEpsilon(quadDot, quadNormal, otherVertexPositions[itemIndex++], otherVertexPositions[itemIndex++], otherVertexPositions[itemIndex++])) continue;
                otherInsideQuad = true;
                break;
            }
            if (otherInsideQuad) {
                float otherDot = other.getAccurateDotProduct();
                Vector3fc otherNormal = other.getAccurateNormal();
                float[] quadVertexPositions = quad.getVertexPositions();
                boolean quadNotFullyInsideOther = false;
                int itemIndex2 = 0;
                for (int i = 0; i < 4; ++i) {
                    if (!TopoGraphSorting.pointOutsideHalfSpaceEpsilon(otherDot, otherNormal, quadVertexPositions[itemIndex2++], quadVertexPositions[itemIndex2++], quadVertexPositions[itemIndex2++])) continue;
                    quadNotFullyInsideOther = true;
                    break;
                }
                result = quadNotFullyInsideOther;
            }
        }
        if (result && distancesByNormal != null) {
            return TopoGraphSorting.visibilityWithSeparator(quad, other, distancesByNormal, cameraPos);
        }
        return result;
    }

    public static boolean topoGraphSort(IntConsumer indexConsumer, TQuad[] allQuads, Object2ReferenceMap<Vector3fc, float[]> distancesByNormal, Vector3fc cameraPos) {
        TQuad[] quads;
        int[] activeToRealIndex = null;
        int quadCount = 0;
        if (cameraPos != null) {
            quads = new TQuad[allQuads.length];
            activeToRealIndex = new int[allQuads.length];
            for (int i = 0; i < allQuads.length; ++i) {
                TQuad quad = allQuads[i];
                if (TopoGraphSorting.pointOutsideHalfSpace(quad.getAccurateDotProduct(), quad.getAccurateNormal(), cameraPos)) {
                    activeToRealIndex[quadCount] = i;
                    quads[quadCount] = quad;
                    ++quadCount;
                    continue;
                }
                indexConsumer.accept(i);
            }
        } else {
            quads = allQuads;
            quadCount = allQuads.length;
        }
        return TopoGraphSorting.topoGraphSort(indexConsumer, quads, quadCount, activeToRealIndex, distancesByNormal, cameraPos);
    }

    public static boolean topoGraphSort(IntConsumer indexConsumer, TQuad[] quads, int quadCount, int[] activeToRealIndex, Object2ReferenceMap<Vector3fc, float[]> distancesByNormal, Vector3fc cameraPos) {
        if (quadCount == 0) {
            return true;
        }
        if (quadCount == 1) {
            if (activeToRealIndex != null) {
                indexConsumer.accept(activeToRealIndex[0]);
            } else {
                indexConsumer.accept(0);
            }
            return true;
        }
        if (quadCount == 2) {
            int a = 0;
            int b = 1;
            if (TopoGraphSorting.quadVisibleThrough(quads[a], quads[b], null, null)) {
                a = 1;
                b = 0;
            }
            if (activeToRealIndex != null) {
                indexConsumer.accept(activeToRealIndex[a]);
                indexConsumer.accept(activeToRealIndex[b]);
            } else {
                indexConsumer.accept(a);
                indexConsumer.accept(b);
            }
            return true;
        }
        BitArray unvisited = new BitArray(quadCount);
        unvisited.set(0, quadCount);
        int visitedCount = 0;
        BitArray onStack = new BitArray(quadCount);
        int[] stack = new int[quadCount];
        int[] nextEdge = new int[quadCount];
        while (visitedCount < quadCount) {
            int root;
            int stackPos = 0;
            stack[stackPos] = root = unvisited.nextSetBit(0);
            onStack.set(root);
            nextEdge[stackPos] = 0;
            while (stackPos >= 0) {
                int currentQuadIndex = stack[stackPos];
                int nextEdgeTest = unvisited.nextSetBit(nextEdge[stackPos]);
                if (nextEdgeTest != -1) {
                    TQuad nextQuad;
                    TQuad currentQuad;
                    if (currentQuadIndex != nextEdgeTest && TopoGraphSorting.quadVisibleThrough(currentQuad = quads[currentQuadIndex], nextQuad = quads[nextEdgeTest], distancesByNormal, cameraPos)) {
                        if (onStack.getAndSet(nextEdgeTest)) {
                            return false;
                        }
                        nextEdge[stackPos] = nextEdgeTest + 1;
                        stack[++stackPos] = nextEdgeTest;
                        nextEdge[stackPos] = 0;
                        continue;
                    }
                    if (++nextEdgeTest < quadCount) {
                        nextEdge[stackPos] = nextEdgeTest;
                        continue;
                    }
                }
                onStack.unset(currentQuadIndex);
                ++visitedCount;
                unvisited.unset(currentQuadIndex);
                --stackPos;
                if (activeToRealIndex != null) {
                    indexConsumer.accept(activeToRealIndex[currentQuadIndex]);
                    continue;
                }
                indexConsumer.accept(currentQuadIndex);
            }
        }
        return true;
    }
}

