/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.GeometryPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.SortTriggering;
import org.joml.Vector3fc;

class GFNITriggers
implements SortTriggering.SectionTriggers<DynamicData> {
    private final Object2ReferenceMap<Vector3fc, NormalList> normalLists = new Object2ReferenceOpenHashMap<Vector3fc, NormalList>();

    GFNITriggers() {
    }

    int getUniqueNormalCount() {
        return this.normalLists.size();
    }

    @Override
    public void processTriggers(SortTriggering ts, CameraMovement movement) {
        for (NormalList normalList : this.normalLists.values()) {
            normalList.processMovement(ts, movement);
        }
    }

    private void addSectionInNewNormalLists(NormalPlanes normalPlanes) {
        Vector3fc normal = normalPlanes.normal;
        NormalList normalList = (NormalList)this.normalLists.get(normal);
        if (normalList == null) {
            normalList = new NormalList(normal, normalPlanes.alignedDirection);
            this.normalLists.put(normal, normalList);
            normalList.addSection(normalPlanes, normalPlanes.sectionPos.asLong());
        }
    }

    private boolean removeSectionFromList(NormalList normalList, long sectionPos) {
        normalList.removeSection(sectionPos);
        return normalList.isEmpty();
    }

    @Override
    public void removeSection(long sectionPos, TranslucentData data) {
        this.normalLists.values().removeIf(normalList -> this.removeSectionFromList((NormalList)normalList, sectionPos));
    }

    @Override
    public void integrateSection(SortTriggering ts, SectionPos pos, DynamicData data, CameraMovement movement) {
        Collection<NormalPlanes> collection;
        long sectionPos = pos.asLong();
        GeometryPlanes geometryPlanes = data.getGeometryPlanes();
        Iterator iterator = this.normalLists.values().iterator();
        while (iterator.hasNext()) {
            NormalList normalList = (NormalList)iterator.next();
            NormalPlanes normalPlanes = geometryPlanes.getPlanesForNormal(normalList);
            if (normalList.hasSection(sectionPos)) {
                if (normalPlanes == null) {
                    if (!this.removeSectionFromList(normalList, sectionPos)) continue;
                    iterator.remove();
                    continue;
                }
                normalList.updateSection(normalPlanes, sectionPos);
                continue;
            }
            if (normalPlanes == null) continue;
            normalList.addSection(normalPlanes, sectionPos);
        }
        NormalPlanes[] aligned = geometryPlanes.getAligned();
        if (aligned != null) {
            for (NormalPlanes normalPlane : aligned) {
                if (normalPlane == null) continue;
                this.addSectionInNewNormalLists(normalPlane);
            }
        }
        if ((collection = geometryPlanes.getUnaligned()) != null) {
            for (NormalPlanes normalPlane : collection) {
                this.addSectionInNewNormalLists(normalPlane);
            }
        }
        data.discardGeometryPlanes();
        if (movement.hasChanged()) {
            for (NormalList normalList : this.normalLists.values()) {
                normalList.processCatchup(ts, movement, sectionPos);
            }
        }
    }
}

