/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.Collection;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.Group;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.SortTriggering;
import net.caffeinemc.mods.sodium.client.util.interval_tree.DoubleInterval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.Interval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.IntervalTree;
import org.joml.Math;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class NormalList {
    private static final int HASH_SET_THRESHOLD = 20;
    private static final int ARRAY_SET_THRESHOLD = 10;
    private final Vector3fc normal;
    private final int alignedDirection;
    private final IntervalTree<Double> intervalTree = new IntervalTree();
    private final Object2ReferenceOpenHashMap<DoubleInterval, Collection<Group>> groupsByInterval = new Object2ReferenceOpenHashMap();
    private final Long2ReferenceOpenHashMap<Group> groupsBySection = new Long2ReferenceOpenHashMap();

    NormalList(Vector3fc normal, int alignedDirection) {
        this.normal = normal;
        this.alignedDirection = alignedDirection;
    }

    public Vector3fc getNormal() {
        return this.normal;
    }

    public boolean isAligned() {
        return this.alignedDirection != ModelQuadFacing.UNASSIGNED_ORDINAL;
    }

    public int getAlignedDirection() {
        return this.alignedDirection;
    }

    private double normalDotDouble(Vector3dc v) {
        return Math.fma((double)this.normal.x(), v.x(), Math.fma((double)this.normal.y(), v.y(), (double)this.normal.z() * v.z()));
    }

    void processMovement(SortTriggering ts, CameraMovement movement) {
        double end;
        double start = this.normalDotDouble(movement.start());
        if (start >= (end = this.normalDotDouble(movement.end()))) {
            return;
        }
        DoubleInterval interval = new DoubleInterval(start, end, Interval.Bounded.CLOSED);
        for (Interval<Double> groupInterval : this.intervalTree.query(interval)) {
            for (Group group : this.groupsByInterval.get(groupInterval)) {
                group.triggerRange(ts, start, end);
            }
        }
    }

    void processCatchup(SortTriggering ts, CameraMovement movement, long sectionPos) {
        double end;
        double start = this.normalDotDouble(movement.start());
        if (start >= (end = this.normalDotDouble(movement.end()))) {
            return;
        }
        Group group = this.groupsBySection.get(sectionPos);
        if (group != null) {
            group.triggerRange(ts, start, end);
        }
    }

    private void removeGroupInterval(Group group) {
        Collection<Group> groups = this.groupsByInterval.get(group.distances);
        if (groups != null) {
            groups.remove(group);
            if (groups.isEmpty()) {
                this.groupsByInterval.remove(group.distances);
                this.intervalTree.remove(group.distances);
            } else if (groups.size() <= 10) {
                groups = new ReferenceArraySet<Group>(groups);
                this.groupsByInterval.put(group.distances, groups);
            }
        }
    }

    private void addGroupInterval(Group group) {
        Collection<Group> groups = this.groupsByInterval.get(group.distances);
        if (groups == null) {
            groups = new ReferenceArraySet<Group>();
            this.groupsByInterval.put(group.distances, groups);
            this.intervalTree.add(group.distances);
        } else if (groups.size() >= 20) {
            groups = new ReferenceLinkedOpenHashSet<Group>(groups);
            this.groupsByInterval.put(group.distances, groups);
        }
        groups.add(group);
    }

    boolean hasSection(long sectionPos) {
        return this.groupsBySection.containsKey(sectionPos);
    }

    boolean isEmpty() {
        return this.groupsBySection.isEmpty();
    }

    void addSection(NormalPlanes normalPlanes, long sectionPos) {
        Group group = new Group(normalPlanes);
        this.groupsBySection.put(sectionPos, group);
        this.addGroupInterval(group);
    }

    void removeSection(long sectionPos) {
        Group group = this.groupsBySection.remove(sectionPos);
        if (group != null) {
            this.removeGroupInterval(group);
        }
    }

    void updateSection(NormalPlanes normalPlanes, long sectionPos) {
        Group group = this.groupsBySection.get(sectionPos);
        if (group.normalPlanesEquals(normalPlanes)) {
            return;
        }
        this.removeGroupInterval(group);
        group.replaceWith(normalPlanes);
        this.addGroupInterval(group);
    }

    public static boolean queryRange(float[] sortedDistances, float start, float end) {
        int result = FloatArrays.binarySearch(sortedDistances, start);
        if (result < 0) {
            int insertionPoint = -result - 1;
            if (insertionPoint >= sortedDistances.length) {
                return false;
            }
            return sortedDistances[insertionPoint] <= end;
        }
        return true;
    }
}

