/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.util.interval_tree.DoubleInterval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.Interval;
import org.joml.Vector3fc;

public class NormalPlanes {
    final FloatOpenHashSet relativeDistancesSet = new FloatOpenHashSet(16);
    final Vector3fc normal;
    final int alignedDirection;
    final SectionPos sectionPos;
    float[] relativeDistances;
    DoubleInterval distanceRange;
    long relDistanceHash;
    double baseDistance;

    private NormalPlanes(SectionPos sectionPos, Vector3fc normal, int alignedDirection) {
        this.sectionPos = sectionPos;
        this.normal = normal;
        this.alignedDirection = alignedDirection;
    }

    public NormalPlanes(SectionPos sectionPos, Vector3fc normal) {
        this(sectionPos, normal, ModelQuadFacing.UNASSIGNED_ORDINAL);
    }

    public NormalPlanes(SectionPos sectionPos, int alignedDirection) {
        this(sectionPos, ModelQuadFacing.ALIGNED_NORMALS[alignedDirection], alignedDirection);
    }

    public void addPlaneMember(float distance) {
        this.relativeDistancesSet.add(distance);
    }

    public void prepareIntegration() {
        if (this.relativeDistances != null) {
            throw new IllegalStateException("Already prepared");
        }
        int size = this.relativeDistancesSet.size();
        this.relativeDistances = new float[this.relativeDistancesSet.size()];
        int i = 0;
        FloatIterator it = this.relativeDistancesSet.iterator();
        while (it.hasNext()) {
            float relDistance = it.nextFloat();
            this.relativeDistances[i++] = relDistance;
            long distanceBits = Double.doubleToLongBits(relDistance);
            this.relDistanceHash ^= this.relDistanceHash * 31L + distanceBits;
        }
        Arrays.sort(this.relativeDistances);
        this.baseDistance = this.normal.dot(this.sectionPos.minBlockX(), this.sectionPos.minBlockY(), this.sectionPos.minBlockZ());
        this.distanceRange = new DoubleInterval((double)this.relativeDistances[0] + this.baseDistance, (double)this.relativeDistances[size - 1] + this.baseDistance, Interval.Bounded.CLOSED);
    }

    public void prepareAndInsert(Object2ReferenceMap<Vector3fc, float[]> distancesByNormal) {
        this.prepareIntegration();
        if (distancesByNormal != null) {
            distancesByNormal.put(this.normal, this.relativeDistances);
        }
    }
}

