/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world;

import dev.vexor.radium.compat.mojang.math.Mth;
import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.Arrays;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.world.biome.BiomeColorSource;
import net.caffeinemc.mods.sodium.client.world.biome.LevelBiomeSlice;
import net.caffeinemc.mods.sodium.client.world.biome.LevelColorCache;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.class_1150;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1161;
import net.minecraft.class_1167;
import net.minecraft.class_1170;
import net.minecraft.class_1194;
import net.minecraft.class_1196;
import net.minecraft.class_1197;
import net.minecraft.class_1251;
import net.minecraft.class_1354;
import net.minecraft.class_1752;
import net.minecraft.class_2232;
import net.minecraft.class_226;
import net.minecraft.class_2552;
import net.minecraft.class_478;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LevelSlice
implements class_1158 {
    private static final class_1161[] LIGHT_TYPES = class_1161.values();
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = Mth.roundToward(2, 16) >> 4;
    private static final int SECTION_ARRAY_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int SECTION_ARRAY_SIZE = SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH;
    private static final int LOCAL_XYZ_BITS = 4;
    private static final class_2232 EMPTY_BLOCK_STATE = class_1752.field_7312.method_8633();
    private final class_478 level;
    private final LevelBiomeSlice biomeSlice;
    private final LevelColorCache biomeColors;
    private final class_2232[][] blockArrays;
    @Nullable
    private final class_1194[][] lightArrays;
    @Nullable
    private final Int2ReferenceMap<class_226>[] blockEntityArrays;
    private int originBlockX;
    private int originBlockY;
    private int originBlockZ;
    private class_1251 volume;
    private final int[] defaultLightValues;

    public static ChunkRenderContext prepare(class_1150 level, SectionPos pos, ClonedChunkSectionCache cache) {
        class_1196 chunk = level.method_3688(pos.method_10572(), pos.method_10574());
        class_1197 section = chunk.method_3918()[pos.method_10573()];
        if (section == null || section.method_3925()) {
            return null;
        }
        class_1251 box = new class_1251(pos.minBlockX() - 2, pos.minBlockY() - 2, pos.minBlockZ() - 2, pos.maxBlockX() + 2, pos.maxBlockY() + 2, pos.maxBlockZ() + 2);
        int minChunkX = pos.method_10572() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = pos.method_10573() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = pos.method_10574() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = pos.method_10572() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = pos.method_10573() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = pos.method_10574() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[LevelSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = cache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(pos, sections, box);
    }

    public LevelSlice(class_478 level) {
        this.level = level;
        this.defaultLightValues = new int[LIGHT_TYPES.length];
        this.defaultLightValues[class_1161.field_9219.ordinal()] = level.field_4558.method_9177() ? 0 : class_1161.field_9219.field_4590;
        this.defaultLightValues[class_1161.field_9220.ordinal()] = class_1161.field_9220.field_4590;
        this.blockArrays = new class_2232[SECTION_ARRAY_SIZE][4096];
        this.lightArrays = new class_1194[SECTION_ARRAY_SIZE][LIGHT_TYPES.length];
        this.blockEntityArrays = new Int2ReferenceMap[SECTION_ARRAY_SIZE];
        int biomeBlendRadius = SodiumClientMod.options().quality.biomeBlendRadius;
        this.biomeSlice = new LevelBiomeSlice();
        this.biomeColors = new LevelColorCache(this.biomeSlice, biomeBlendRadius);
        for (Object[] objectArray : this.blockArrays) {
            Arrays.fill(objectArray, EMPTY_BLOCK_STATE);
        }
    }

    public void copyData(ChunkRenderContext context) {
        this.originBlockX = SectionPos.sectionToBlockCoord(context.origin().method_10572() - NEIGHBOR_CHUNK_RADIUS);
        this.originBlockY = SectionPos.sectionToBlockCoord(context.origin().method_10573() - NEIGHBOR_CHUNK_RADIUS);
        this.originBlockZ = SectionPos.sectionToBlockCoord(context.origin().method_10574() - NEIGHBOR_CHUNK_RADIUS);
        this.volume = context.volume();
        for (int x = 0; x < SECTION_ARRAY_LENGTH; ++x) {
            for (int y = 0; y < SECTION_ARRAY_LENGTH; ++y) {
                for (int z = 0; z < SECTION_ARRAY_LENGTH; ++z) {
                    this.copySectionData(context, LevelSlice.getLocalSectionIndex(x, y, z));
                }
            }
        }
        this.biomeSlice.update(this.level, context);
        this.biomeColors.update(context);
    }

    private void copySectionData(ChunkRenderContext context, int sectionIndex) {
        ClonedChunkSection section = context.sections()[sectionIndex];
        Objects.requireNonNull(section, "Chunk section must be non-null");
        this.unpackBlockData(this.blockArrays[sectionIndex], context, section);
        this.lightArrays[sectionIndex][class_1161.field_9220.ordinal()] = section.getLightArray(class_1161.field_9220);
        this.lightArrays[sectionIndex][class_1161.field_9219.ordinal()] = section.getLightArray(class_1161.field_9219);
        this.blockEntityArrays[sectionIndex] = section.getBlockEntityMap();
    }

    private void unpackBlockData(class_2232[] blockArray, ChunkRenderContext context, ClonedChunkSection section) {
        if (section.getBlockData() == null) {
            Arrays.fill(blockArray, EMPTY_BLOCK_STATE);
            return;
        }
        class_2232[] container = section.getBlockData();
        SectionPos sectionPos = section.getPosition();
        if (sectionPos.equals((Object)context.origin())) {
            System.arraycopy(container, 0, blockArray, 0, container.length);
        } else {
            class_1251 bounds = context.volume();
            int minBlockX = Math.max(bounds.field_4904, sectionPos.minBlockX());
            int maxBlockX = Math.min(bounds.field_4907, sectionPos.maxBlockX());
            int minBlockY = Math.max(bounds.field_4905, sectionPos.minBlockY());
            int maxBlockY = Math.min(bounds.field_4908, sectionPos.maxBlockY());
            int minBlockZ = Math.max(bounds.field_4906, sectionPos.minBlockZ());
            int maxBlockZ = Math.min(bounds.field_4909, sectionPos.maxBlockZ());
            for (int x = minBlockX; x <= maxBlockX; ++x) {
                for (int y = minBlockY; y <= maxBlockY; ++y) {
                    for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                        int index = LevelSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                        blockArray[index] = container[index];
                    }
                }
            }
        }
    }

    public void reset() {
        for (int sectionIndex = 0; sectionIndex < SECTION_ARRAY_LENGTH; ++sectionIndex) {
            Arrays.fill(this.lightArrays[sectionIndex], null);
            this.blockEntityArrays[sectionIndex] = null;
        }
    }

    @NotNull
    public class_2232 method_8580(class_2552 pos) {
        if (!this.volume.method_9233((class_1167)pos)) {
            return EMPTY_BLOCK_STATE;
        }
        int relBlockX = pos.method_10572() - this.originBlockX;
        int relBlockY = pos.method_10573() - this.originBlockY;
        int relBlockZ = pos.method_10574() - this.originBlockZ;
        return this.blockArrays[LevelSlice.getLocalSectionIndex(relBlockX >> 4, relBlockY >> 4, relBlockZ >> 4)][LevelSlice.getLocalBlockIndex(relBlockX & 0xF, relBlockY & 0xF, relBlockZ & 0xF)];
    }

    public boolean method_8579(class_2552 pos) {
        return this.method_8580(pos).method_9028() == class_1752.field_7312;
    }

    public class_1170 method_8577(class_2552 pos) {
        return this.biomeSlice.getBiome(pos.method_10572(), pos.method_10573(), pos.method_10574());
    }

    public boolean method_3772() {
        return false;
    }

    public int method_8576(class_2552 pos, class_1354 direction) {
        class_2232 blockState = this.method_8580(pos);
        return blockState.method_9028().method_8664((class_1158)this, pos, blockState, direction);
    }

    public class_1160 method_8575() {
        return this.level.method_8575();
    }

    public int getLight(class_1161 type, class_2552 pos) {
        int relZ;
        int relY;
        if (!this.volume.method_9233((class_1167)pos)) {
            return 0;
        }
        int relX = pos.method_10572() - this.originBlockX;
        class_2232 state = this.getBlockStateRelative(relX, relY = pos.method_10573() - this.originBlockY, relZ = pos.method_10574() - this.originBlockZ);
        if (!state.method_9028().method_6455()) {
            return this.getLightFor(type, relX, relY, relZ);
        }
        int west = this.getLightFor(type, relX - 1, relY, relZ);
        int east = this.getLightFor(type, relX + 1, relY, relZ);
        int up = this.getLightFor(type, relX, relY + 1, relZ);
        int down = this.getLightFor(type, relX, relY - 1, relZ);
        int north = this.getLightFor(type, relX, relY, relZ + 1);
        int south = this.getLightFor(type, relX, relY, relZ - 1);
        if (east > west) {
            west = east;
        }
        if (up > west) {
            west = up;
        }
        if (down > west) {
            west = down;
        }
        if (north > west) {
            west = north;
        }
        if (south > west) {
            west = south;
        }
        return west;
    }

    private int getLightFor(class_1161 type, int relX, int relY, int relZ) {
        int sectionIdx = LevelSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4);
        class_1194 lightArray = this.lightArrays[sectionIdx][type.ordinal()];
        if (lightArray == null) {
            return this.defaultLightValues[type.ordinal()];
        }
        return lightArray.method_3875(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public class_2232 getBlockStateRelative(int x, int y, int z) {
        int sectionIdx = LevelSlice.getLocalSectionIndex(x >> 4, y >> 4, z >> 4);
        int blockIdx = LevelSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
        return this.blockArrays[sectionIdx][blockIdx];
    }

    public int method_8578(class_2552 pos, int ambientDarkness) {
        if (!this.volume.method_9233((class_1167)pos)) {
            return 0;
        }
        int x = pos.method_10572();
        int y = pos.method_10573();
        int z = pos.method_10574();
        if (y < 0 || y >= 256 || x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return this.defaultLightValues[0] << 20 | ambientDarkness << 4;
        }
        int skyBrightness = this.getLight(class_1161.field_9219, pos);
        int blockBrightness = this.getLight(class_1161.field_9220, pos);
        if (blockBrightness < ambientDarkness) {
            blockBrightness = ambientDarkness;
        }
        return skyBrightness << 20 | blockBrightness << 4;
    }

    public class_226 method_8581(class_2552 pos) {
        int relBlockZ;
        int relBlockY;
        if (!this.volume.method_9233((class_1167)pos)) {
            return null;
        }
        int relBlockX = pos.method_10572() - this.originBlockX;
        Int2ReferenceMap<class_226> blockEntities = this.blockEntityArrays[LevelSlice.getLocalSectionIndex(relBlockX >> 4, (relBlockY = pos.method_10573() - this.originBlockY) >> 4, (relBlockZ = pos.method_10574() - this.originBlockZ) >> 4)];
        if (blockEntities == null) {
            return null;
        }
        return (class_226)blockEntities.get(LevelSlice.getLocalBlockIndex(relBlockX & 0xF, relBlockY & 0xF, relBlockZ & 0xF));
    }

    public static int getLocalBlockIndex(int blockX, int blockY, int blockZ) {
        return blockY << 4 << 4 | blockZ << 4 | blockX;
    }

    public static int getLocalSectionIndex(int sectionX, int sectionY, int sectionZ) {
        return sectionY * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH + sectionZ * SECTION_ARRAY_LENGTH + sectionX;
    }

    public float getBrightness(class_1354 direction, boolean shaded) {
        if (!shaded) {
            return this.level.field_4558.method_9177() ? 0.9f : 1.0f;
        }
        return switch (direction) {
            case class_1354.field_5200 -> 0.5f;
            case class_1354.field_5201 -> 1.0f;
            case class_1354.field_5202, class_1354.field_5203 -> 0.8f;
            default -> 0.7f;
        };
    }

    public int getColor(BiomeColorSource source, int blockX, int blockY, int blockZ) {
        return this.biomeColors.getColor(source.getProvider(), blockX, blockY, blockZ);
    }
}

