/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.caffeinemc.mods.sodium.client.util.color.BoxBlur;
import net.caffeinemc.mods.sodium.client.world.biome.LevelBiomeSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1170;
import net.minecraft.class_2167;
import net.minecraft.class_2552;
import net.minecraft.class_837;

public class LevelColorCache {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private final LevelBiomeSlice biomeData;
    private final Reference2ReferenceOpenHashMap<class_2167.class_2168, Slice[]> slices;
    private long populateStamp;
    private final int blendRadius;
    private final BoxBlur.ColorBuffer tempColorBuffer;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private final int sizeXZ;
    private final int sizeY;

    public LevelColorCache(LevelBiomeSlice biomeData, int blendRadius) {
        this.biomeData = biomeData;
        this.blendRadius = blendRadius;
        this.sizeXZ = 16 + (2 + this.blendRadius) * 2;
        this.sizeY = 20;
        this.slices = new Reference2ReferenceOpenHashMap();
        this.populateStamp = 1L;
        this.tempColorBuffer = new BoxBlur.ColorBuffer(this.sizeXZ, this.sizeXZ);
    }

    public void update(ChunkRenderContext context) {
        this.minBlockX = context.origin().minBlockX() - 2;
        this.minBlockY = context.origin().minBlockY() - 2;
        this.minBlockZ = context.origin().minBlockZ() - 2;
        this.maxBlockX = context.origin().maxBlockX() + 2;
        this.maxBlockY = context.origin().maxBlockY() + 2;
        this.maxBlockZ = context.origin().maxBlockZ() + 2;
        ++this.populateStamp;
    }

    public int getColor(class_2167.class_2168 resolver, int blockX, int blockY, int blockZ) {
        blockX = class_837.method_2339((int)blockX, (int)this.minBlockX, (int)this.maxBlockX) - this.minBlockX;
        blockY = class_837.method_2339((int)blockY, (int)this.minBlockY, (int)this.maxBlockY) - this.minBlockY;
        blockZ = class_837.method_2339((int)blockZ, (int)this.minBlockZ, (int)this.maxBlockZ) - this.minBlockZ;
        if (!this.slices.containsKey(resolver)) {
            this.initializeSlices(resolver);
        }
        Slice slice = this.slices.get(resolver)[blockY];
        if (slice.lastPopulateStamp < this.populateStamp) {
            this.updateColorBuffers(blockY, resolver, slice);
        }
        BoxBlur.ColorBuffer buffer = slice.getBuffer();
        return buffer.get(blockX + this.blendRadius, blockZ + this.blendRadius);
    }

    private void initializeSlices(class_2167.class_2168 resolver) {
        Slice[] slice = new Slice[this.sizeY];
        for (int blockY = 0; blockY < this.sizeY; ++blockY) {
            slice[blockY] = new Slice(this.sizeXZ);
        }
        this.slices.put(resolver, slice);
    }

    private void updateColorBuffers(int relY, class_2167.class_2168 resolver, Slice slice) {
        int blockY = this.minBlockY + relY;
        int minBlockZ = this.minBlockZ - this.blendRadius;
        int minBlockX = this.minBlockX - this.blendRadius;
        int maxBlockZ = this.maxBlockZ + this.blendRadius;
        int maxBlockX = this.maxBlockX + this.blendRadius;
        BoxBlur.ColorBuffer buffer = slice.buffer;
        for (int blockZ = minBlockZ; blockZ <= maxBlockZ; ++blockZ) {
            for (int blockX = minBlockX; blockX <= maxBlockX; ++blockX) {
                class_1170 biome = this.biomeData.getBiome(blockX, blockY, blockZ);
                int relBlockX = blockX - minBlockX;
                int relBlockZ = blockZ - minBlockZ;
                buffer.set(relBlockX, relBlockZ, resolver.method_8598(biome, new class_2552(blockX, blockY, blockZ)));
            }
        }
        if (this.blendRadius > 0) {
            BoxBlur.blur(buffer.data, this.tempColorBuffer.data, this.sizeXZ, this.sizeXZ, this.blendRadius);
        }
        slice.lastPopulateStamp = this.populateStamp;
    }

    private static class Slice {
        private final BoxBlur.ColorBuffer buffer;
        private long lastPopulateStamp;

        private Slice(int size) {
            this.buffer = new BoxBlur.ColorBuffer(size, size);
            this.lastPopulateStamp = 0L;
        }

        public BoxBlur.ColorBuffer getBuffer() {
            return this.buffer;
        }
    }
}

