/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.cloned;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import java.util.concurrent.TimeUnit;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.class_1150;
import net.minecraft.class_1196;
import net.minecraft.class_1197;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClonedChunkSectionCache {
    private static final int MAX_CACHE_SIZE = 512;
    private static final long MAX_CACHE_DURATION = TimeUnit.SECONDS.toNanos(5L);
    private final class_1150 level;
    private final Long2ReferenceLinkedOpenHashMap<ClonedChunkSection> positionToEntry = new Long2ReferenceLinkedOpenHashMap();
    private long time;

    public ClonedChunkSectionCache(class_1150 level) {
        this.level = level;
        this.time = ClonedChunkSectionCache.getMonotonicTimeSource();
    }

    public void cleanup() {
        this.time = ClonedChunkSectionCache.getMonotonicTimeSource();
        this.positionToEntry.values().removeIf(entry -> this.time > entry.getLastUsedTimestamp() + MAX_CACHE_DURATION);
    }

    @Nullable
    public ClonedChunkSection acquire(int x, int y, int z) {
        long pos = SectionPos.asLong(x, y, z);
        ClonedChunkSection section = this.positionToEntry.getAndMoveToLast(pos);
        if (section == null) {
            section = this.clone(x, y, z);
            while (this.positionToEntry.size() >= 512) {
                this.positionToEntry.removeFirst();
            }
            this.positionToEntry.putAndMoveToLast(pos, section);
        }
        section.setLastUsedTimestamp(this.time);
        return section;
    }

    @NotNull
    private ClonedChunkSection clone(int x, int y, int z) {
        class_1196 chunk = this.level.method_3688(x, z);
        if (chunk == null) {
            throw new RuntimeException("Chunk is not loaded at: " + SectionPos.asLong(x, y, z));
        }
        class_1197 section = null;
        if (!ClonedChunkSectionCache.withinBuildHeight(SectionPos.sectionToBlockCoord(y))) {
            section = chunk.method_3918()[SectionPos.blockToSectionCoord(SectionPos.sectionToBlockCoord(y))];
        }
        return new ClonedChunkSection(this.level, chunk, section, SectionPos.of(x, y, z));
    }

    private static boolean withinBuildHeight(int y) {
        return y < 0 || y >= 256;
    }

    public void invalidate(int x, int y, int z) {
        this.positionToEntry.remove(SectionPos.asLong(x, y, z));
    }

    private static long getMonotonicTimeSource() {
        return System.nanoTime();
    }
}

