/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.HashSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;

public class Display {
    private static final DisplayMode desktop_mode;
    private static String title;
    private static long handle;
    private static boolean resizable;
    private static DisplayMode current_mode;
    private static int width;
    private static int height;
    private static int x;
    private static int y;
    private static boolean fullscreen;
    private static boolean window_resized;
    private static boolean window_created;
    private static GLFWWindowSizeCallback sizeCallback;
    private static ByteBuffer[] cached_icons;

    private Display() {
    }

    public static DisplayMode getDisplayMode() {
        return current_mode;
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (cached_icons != icons) {
            cached_icons = new ByteBuffer[icons.length];
            for (int i = 0; i < icons.length; ++i) {
                Display.cached_icons[i] = BufferUtils.createByteBuffer(icons[i].capacity());
                int old_position = icons[i].position();
                cached_icons[i].put(icons[i]);
                icons[i].position(old_position);
                cached_icons[i].flip();
            }
        }
        if (Display.isCreated()) {
            GLFW.glfwSetWindowIcon(handle, Display.iconsToGLFWBuffer(cached_icons));
            return 1;
        }
        return 0;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktop_mode;
    }

    private static GLFWImage.Buffer iconsToGLFWBuffer(ByteBuffer[] icons) {
        GLFWImage.Buffer buffer = GLFWImage.create(icons.length);
        for (ByteBuffer icon : icons) {
            int size = icon.limit() / 4;
            int dimension = (int)Math.sqrt(size);
            GLFWImage image = GLFWImage.malloc();
            buffer.put(image.set(dimension, dimension, icon));
        }
        buffer.flip();
        return buffer;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        window_resized = false;
        GLFW.glfwPollEvents();
        if (processMessages) {
            if (Mouse.isCreated()) {
                Mouse.poll();
            }
            if (Keyboard.isCreated()) {
                Keyboard.poll();
            }
            if (Controllers.isCreated()) {
                Controllers.poll();
            }
        }
        Display.swapBuffers();
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers(handle);
    }

    public static void create() throws LWJGLException {
        Display.create(new PixelFormat());
    }

    public static void create(PixelFormat pixelFormat) throws LWJGLException {
        GLFW.glfwWindowHint(135178, pixelFormat.getAccumulationBitsPerPixel());
        GLFW.glfwWindowHint(135172, pixelFormat.getAlphaBits());
        GLFW.glfwWindowHint(135179, pixelFormat.getAuxBuffers());
        GLFW.glfwWindowHint(135173, pixelFormat.getDepthBits());
        GLFW.glfwWindowHint(135181, pixelFormat.getSamples());
        GLFW.glfwWindowHint(135174, pixelFormat.getStencilBits());
        GLFW.glfwWindowHint(131076, 0);
        handle = GLFW.glfwCreateWindow(current_mode.getWidth(), current_mode.getHeight(), title, 0L, 0L);
        if (handle == 0L) {
            throw new LWJGLException("Display could not be created");
        }
        sizeCallback = GLFWWindowSizeCallback.create(Display::resizeCallback);
        GLFW.glfwSetWindowSizeCallback(handle, sizeCallback);
        GLFW.glfwMakeContextCurrent(handle);
        Display.createWindow();
        GL.createCapabilities();
    }

    public static void setLocation(int new_x, int new_y) {
        x = new_x;
        y = new_y;
        if (Display.isCreated() && !Display.isFullscreen()) {
            GLFW.glfwSetWindowPos(handle, x, y);
        }
    }

    public static void setFullscreen(boolean fullscreen) throws LWJGLException {
        Display.setDisplayModeAndFullscreenInternal(fullscreen, current_mode);
    }

    public static void setDisplayMode(DisplayMode mode) throws LWJGLException {
        Display.setDisplayModeAndFullscreen(mode);
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) throws LWJGLException {
        Display.setDisplayModeAndFullscreenInternal(mode.isFullscreenCapable(), mode);
    }

    private static void setDisplayModeAndFullscreenInternal(boolean fullscreen, DisplayMode mode) throws LWJGLException {
        if (mode == null) {
            throw new NullPointerException("mode must be non-null");
        }
        DisplayMode old_mode = current_mode;
        current_mode = mode;
        boolean was_fullscreen = Display.isFullscreen();
        Display.fullscreen = fullscreen;
        if (was_fullscreen != Display.isFullscreen() || !mode.equals(old_mode)) {
            if (!Display.isCreated()) {
                return;
            }
            Display.destroyWindow();
            Display.createWindow();
        }
    }

    private static void createWindow() throws LWJGLException {
        if (Display.isCreated()) {
            return;
        }
        GLFW.glfwSetWindowAttrib(handle, 131075, resizable ? 1 : 0);
        window_created = true;
        if (Display.isFullscreen()) {
            boolean borderlessFullscreen = false;
            if (borderlessFullscreen) {
                GLFW.glfwSetWindowAttrib(handle, 131077, 0);
                GLFW.glfwSetWindowSize(handle, current_mode.getWidth(), current_mode.getHeight());
            } else {
                GLFW.glfwSetWindowMonitor(handle, GLFW.glfwGetPrimaryMonitor(), x, y, current_mode.getWidth(), current_mode.getHeight(), current_mode.getFrequency());
            }
        } else {
            GLFW.glfwSetWindowAttrib(handle, 131077, 1);
            GLFW.glfwSetWindowMonitor(handle, 0L, x, y, current_mode.getWidth(), current_mode.getHeight(), current_mode.getFrequency());
        }
        width = current_mode.getWidth();
        height = current_mode.getHeight();
        GLFW.glfwSetWindowPos(handle, Display.getWindowX(), Display.getWindowY());
        Display.initControls();
        if (cached_icons != null) {
            Display.setIcon(cached_icons);
        } else {
            Display.setIcon(new ByteBuffer[]{LWJGLUtil.LWJGLIcon32x32, LWJGLUtil.LWJGLIcon16x16});
        }
        GLFW.glfwShowWindow(handle);
        GLFW.glfwFocusWindow(handle);
    }

    static boolean getPrivilegedBoolean(String property_name) {
        return Boolean.getBoolean(property_name);
    }

    private static void initControls() {
        if (!Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.noinput")) {
            if (!Mouse.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nomouse")) {
                try {
                    Mouse.create();
                }
                catch (LWJGLException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (!Keyboard.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nokeyboard")) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        if (primaryMonitor == 0L) {
            return new DisplayMode[0];
        }
        GLFWVidMode.Buffer videoModes = GLFW.glfwGetVideoModes(primaryMonitor);
        HashSet<DisplayMode> modes = new HashSet<DisplayMode>(videoModes.sizeof());
        for (int i = 0; i < videoModes.sizeof(); ++i) {
            GLFWVidMode mode = (GLFWVidMode)videoModes.get(i);
            modes.add(new DisplayMode(mode.width(), mode.height(), mode.redBits() + mode.blueBits() + mode.greenBits(), mode.refreshRate()));
        }
        DisplayMode[] filteredModes = new DisplayMode[videoModes.sizeof()];
        modes.toArray(filteredModes);
        return filteredModes;
    }

    private static void resizeCallback(long window, int width, int height) {
        if (window == handle) {
            window_resized = true;
            Display.width = width;
            Display.height = height;
        }
    }

    private static void destroyWindow() {
        if (!Display.isCreated()) {
            return;
        }
        if (Mouse.isCreated()) {
            Mouse.destroy();
        }
        if (Keyboard.isCreated()) {
            Keyboard.destroy();
        }
        window_created = false;
    }

    public static void destroy() {
        Display.destroyWindow();
        sizeCallback.free();
        GLFW.glfwTerminate();
        GLFWErrorCallback callback = GLFW.glfwSetErrorCallback(null);
        if (callback != null) {
            callback.free();
        }
    }

    public static boolean isCreated() {
        return window_created;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose(handle);
    }

    public static boolean isActive() {
        return GLFW.glfwGetWindowAttrib(handle, 131074) == 0;
    }

    public static void setResizable(boolean isResizable) {
        resizable = isResizable;
        if (Display.isCreated()) {
            GLFW.glfwWindowHint(131075, resizable ? 1 : 0);
        }
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static String getTitle() {
        return title;
    }

    public static void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        title = newTitle;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle(handle, title);
        }
    }

    public static void setVSyncEnabled(boolean enabled) {
        if (!Display.isCreated()) {
            return;
        }
        GLFW.glfwSwapInterval(enabled ? 1 : 0);
    }

    private static int getWindowX() {
        if (!Display.isFullscreen()) {
            if (x == -1) {
                return Math.max(0, (desktop_mode.getWidth() - current_mode.getWidth()) / 2);
            }
            return x;
        }
        return 0;
    }

    private static int getWindowY() {
        if (!Display.isFullscreen()) {
            if (y == -1) {
                return Math.max(0, (desktop_mode.getHeight() - current_mode.getHeight()) / 2);
            }
            return y;
        }
        return 0;
    }

    public static int getX() {
        if (Display.isFullscreen()) {
            return 0;
        }
        return x;
    }

    public static int getY() {
        if (Display.isFullscreen()) {
            return 0;
        }
        return y;
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static boolean isFullscreen() {
        return fullscreen;
    }

    public static boolean wasResized() {
        return window_resized;
    }

    public static long getHandle() {
        return handle;
    }

    static {
        title = "Game";
        handle = 0L;
        resizable = false;
        width = 0;
        height = 0;
        x = -1;
        y = -1;
        window_resized = false;
        window_created = false;
        sizeCallback = null;
        cached_icons = null;
        GLFWErrorCallback.createPrint(System.err).set();
        if (GLFW.glfwInit()) {
            new ExceptionInInitializerError("Unable to initialize GLFW");
        }
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        current_mode = desktop_mode = new DisplayMode(vidMode.width(), vidMode.height(), vidMode.redBits() + vidMode.greenBits() + vidMode.blueBits(), vidMode.refreshRate());
    }
}

