/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import net.minecraft.class_1600;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCPatcherUtils {
    private static File minecraftDir;
    private static File gameDir;
    public static final String EXTENDED_HD = "Extended HD";
    public static final String HD_FONT = "HD Font";
    public static final String RANDOM_MOBS = "Random Mobs";
    public static final String CUSTOM_COLORS = "Custom Colors";
    public static final String CONNECTED_TEXTURES = "Connected Textures";
    public static final String BETTER_SKIES = "Better Skies";
    public static final String BETTER_GLASS = "Better Glass";
    public static final String CUSTOM_ITEM_TEXTURES = "Custom Item Textures";
    public static final String CUSTOM_ANIMATIONS = "Custom Animations";
    public static final String MIPMAP = "Mipmap";
    public static final String RENDER_PASS_CLASS = "com.prupe.mcpatcher.renderpass.RenderPass";
    public static final String BLANK_PNG_FORMAT = "blank_%08x.png";
    private static final Logger log;

    private MCPatcherUtils() {
    }

    public static File getMinecraftPath(String ... subdirs) {
        File f = minecraftDir;
        for (String s : subdirs) {
            f = new File(f, s);
        }
        return f;
    }

    public static File getGamePath(String ... subdirs) {
        File f = gameDir;
        for (String s : subdirs) {
            f = new File(f, s);
        }
        return f;
    }

    public static String getStringProperty(Properties properties, String key, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        return properties.getProperty(key, defaultValue).trim();
    }

    public static int getIntProperty(Properties properties, String key, int defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getHexProperty(Properties properties, String key, int defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).isEmpty()) {
            try {
                return Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim().toLowerCase()).isEmpty()) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static float getFloatProperty(Properties properties, String key, float defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).isEmpty()) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleProperty(Properties properties, String key, double defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).isEmpty()) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static void setMinecraft(File gameDir) {
        minecraftDir = class_1600.method_2965().field_3762;
        MCPatcherUtils.gameDir = gameDir == null || !gameDir.isDirectory() ? minecraftDir : gameDir.getAbsoluteFile();
        log.info("MCPatcherUtils initialized:");
    }

    public static int[] getImageRGB(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rgb = new int[width * height];
        image.getRGB(0, 0, width, height, rgb, 0, width);
        return rgb;
    }

    public static int[] parseIntegerList(String list, int minValue, int maxValue) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        Pattern p = Pattern.compile("(\\d*)-(\\d*)");
        for (String token : list.replace(',', ' ').split("\\s+")) {
            try {
                if (token.matches("\\d+")) {
                    tmpList.add(Integer.parseInt(token));
                    continue;
                }
                Matcher m = p.matcher(token);
                if (!m.matches()) continue;
                String a = m.group(1);
                String b = m.group(2);
                int min = a.isEmpty() ? minValue : Integer.parseInt(a);
                int max = b.isEmpty() ? maxValue : Integer.parseInt(b);
                for (int i = min; i <= max; ++i) {
                    tmpList.add(i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (minValue <= maxValue) {
            int i = 0;
            while (i < tmpList.size()) {
                if ((Integer)tmpList.get(i) < minValue || (Integer)tmpList.get(i) > maxValue) {
                    tmpList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        int[] a = new int[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Integer)tmpList.get(i);
        }
        return a;
    }

    static {
        log = LogManager.getLogger();
    }
}

