/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import java.util.Comparator;
import java.util.regex.Pattern;
import net.minecraft.class_1653;
import net.minecraft.class_1655;

public class IdentifierWithSource
extends class_1653 {
    private final class_1655 source;
    private final int order;
    private final boolean isDirectory;

    public IdentifierWithSource(class_1655 source, class_1653 resource) {
        super(resource.method_5891(), resource.method_5890().replaceFirst("/$", ""));
        this.source = source;
        this.order = ResourceList.getResourcePackOrder(source);
        this.isDirectory = resource.method_5890().endsWith("/");
    }

    public class_1655 getSource() {
        return this.source;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    static class Comparator1
    implements Comparator<IdentifierWithSource> {
        private final boolean bySource;
        private final String suffixExpr;

        Comparator1() {
            this(false, null);
        }

        Comparator1(boolean bySource, String suffix) {
            this.bySource = bySource;
            this.suffixExpr = MCPatcherUtils.isNullOrEmpty(suffix) ? null : Pattern.quote(suffix) + "$";
        }

        @Override
        public int compare(IdentifierWithSource o1, IdentifierWithSource o2) {
            String f2;
            String f1;
            String n2;
            int result;
            if (this.bySource && (result = o1.getOrder() - o2.getOrder()) != 0) {
                return result;
            }
            String n1 = o1.method_5891();
            result = n1.compareTo(n2 = o2.method_5891());
            if (result != 0) {
                return result;
            }
            String p1 = o1.method_5890();
            String p2 = o2.method_5890();
            if (this.suffixExpr != null && (result = (f1 = p1.replaceAll(".*/", "").replaceFirst(this.suffixExpr, "")).compareTo(f2 = p2.replaceAll(".*/", "").replaceFirst(this.suffixExpr, ""))) != 0) {
                return result;
            }
            return p1.compareTo(p2);
        }
    }
}

