/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1653;

public final class PropertiesFile {
    private final MCLogger logger;
    private final class_1653 resource;
    private final String prefix;
    private final Properties properties;
    private int errorCount;

    public static PropertiesFile get(MCLogger logger, class_1653 resource) {
        Properties properties = TexturePackAPI.getProperties(resource);
        if (properties == null) {
            return null;
        }
        return new PropertiesFile(logger, resource, properties);
    }

    public static PropertiesFile getNonNull(MCLogger logger, class_1653 resource) {
        PropertiesFile propertiesFile = PropertiesFile.get(logger, resource);
        if (propertiesFile == null) {
            return new PropertiesFile(logger, resource, new Properties());
        }
        return propertiesFile;
    }

    public PropertiesFile(MCLogger logger, class_1653 resource) {
        this(logger, resource, new Properties());
    }

    public PropertiesFile(MCLogger logger, class_1653 resource, Properties properties) {
        this.logger = logger;
        this.resource = resource;
        this.prefix = resource == null ? "" : (String.valueOf(resource) + ": ").replace("%", "%%");
        this.properties = properties;
    }

    public String getString(String key, String defaultValue) {
        return MCPatcherUtils.getStringProperty(this.properties, key, defaultValue);
    }

    public class_1653 getIdentifier(String key, String defaultValue) {
        String value = this.getString(key, defaultValue);
        return TexturePackAPI.parseIdentifier(this.resource, value);
    }

    public int getInt(String key, int defaultValue) {
        return MCPatcherUtils.getIntProperty(this.properties, key, defaultValue);
    }

    public int getHex(String key, int defaultValue) {
        return MCPatcherUtils.getHexProperty(this.properties, key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return MCPatcherUtils.getFloatProperty(this.properties, key, defaultValue);
    }

    public double getDouble(String key, double defaultValue) {
        return MCPatcherUtils.getDoubleProperty(this.properties, key, defaultValue);
    }

    public int[] getIntList(String key, int minValue, int maxValue, String defaultValue) {
        String value = this.getString(key, defaultValue);
        if (value == null) {
            return null;
        }
        return MCPatcherUtils.parseIntegerList(value, minValue, maxValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return MCPatcherUtils.getBooleanProperty(this.properties, key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void finer(String format, Object ... params) {
        this.logger.finer(this.prefix + format, params);
    }

    public void fine(String format, Object ... params) {
        this.logger.fine(this.prefix + format, params);
    }

    public void config(String format, Object ... params) {
        this.logger.config(format, params);
    }

    public void warning(String format, Object ... params) {
        this.logger.warning(this.prefix + format, params);
    }

    public boolean error(String format, Object ... params) {
        this.logger.error(this.prefix + format, params);
        ++this.errorCount;
        return false;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public boolean valid() {
        return this.getErrorCount() == 0;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.properties.entrySet();
    }

    public class_1653 getResource() {
        return this.resource;
    }

    public String toString() {
        return this.resource.toString();
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof PropertiesFile)) {
            return false;
        }
        return this.resource.equals((Object)((PropertiesFile)that).resource);
    }
}

