/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.IdentifierWithSource;
import dev.vexor.radium.mcpatcher.ex.AbstractTextureExpansion;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.class_1532;
import net.minecraft.class_1533;
import net.minecraft.class_1600;
import net.minecraft.class_1636;
import net.minecraft.class_1646;
import net.minecraft.class_1653;
import net.minecraft.class_1654;
import net.minecraft.class_1655;
import net.minecraft.class_1660;
import net.minecraft.class_314;
import net.minecraft.class_319;
import org.apache.commons.io.IOUtils;

public class TexturePackAPI {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.TEXTURE_PACK);
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String MCPATCHER_SUBDIR = "mcpatcher/";
    public static final class_1653 ITEMS_PNG = new class_1653("textures/atlas/items.png");
    private static final String ASSETS = "assets/";

    public static List<class_1655> getResourcePacks(String namespace) {
        ArrayList<class_1655> resourcePacks = new ArrayList<class_1655>();
        class_1654 resourceManager = class_1600.method_2965().method_5571();
        if (resourceManager instanceof class_1660) {
            Set entrySet = ((class_1660)resourceManager).field_6630.entrySet();
            for (Map.Entry entry : entrySet) {
                List packs;
                if (namespace != null && !namespace.equals(entry.getKey()) || (packs = ((class_1646)entry.getValue()).field_6609) == null) continue;
                resourcePacks.removeAll(packs);
                resourcePacks.addAll(packs);
            }
        }
        return resourcePacks;
    }

    public static Set<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(DEFAULT_NAMESPACE);
        class_1654 resourceManager = class_1600.method_2965().method_5571();
        if (resourceManager instanceof class_1660) {
            class_1660 simpleReloadableResourceManager = (class_1660)resourceManager;
            namespaces.addAll(simpleReloadableResourceManager.field_6630.keySet());
        }
        return namespaces;
    }

    public static boolean isDefaultTexturePack() {
        return TexturePackAPI.getResourcePacks(DEFAULT_NAMESPACE).size() <= 1;
    }

    public static InputStream getInputStream(class_1653 resource) {
        try {
            if (resource instanceof IdentifierWithSource) {
                IdentifierWithSource identifierWithSource = (IdentifierWithSource)resource;
                try {
                    return identifierWithSource.getSource().method_5897(resource);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return resource == null ? null : class_1600.method_2965().method_5571().method_5893(resource).method_5888();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean hasResource(class_1653 resource) {
        if (resource == null) {
            return false;
        }
        if (resource.method_5890().endsWith(".png")) {
            return TexturePackAPI.getImage(resource) != null;
        }
        if (resource.method_5890().endsWith(".properties")) {
            return TexturePackAPI.getProperties(resource) != null;
        }
        InputStream is = TexturePackAPI.getInputStream(resource);
        MCPatcherUtils.close(is);
        return is != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasCustomResource(class_1653 resource) {
        boolean bl;
        InputStream pack;
        InputStream jar;
        block8: {
            boolean bl2;
            block7: {
                jar = null;
                pack = null;
                try {
                    pack = TexturePackAPI.getInputStream(resource);
                    jar = class_1600.method_2965().field_6276.method_5897(resource);
                    if (pack == null || jar == null) {
                        bl2 = false;
                        MCPatcherUtils.close(jar);
                        break block7;
                    }
                    bl = !Arrays.equals(IOUtils.toByteArray((InputStream)jar), IOUtils.toByteArray((InputStream)pack));
                    MCPatcherUtils.close(jar);
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            MCPatcherUtils.close(pack);
            return bl2;
        }
        MCPatcherUtils.close(pack);
        return bl;
        finally {
            MCPatcherUtils.close(jar);
            MCPatcherUtils.close(pack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImage(class_1653 resource) {
        if (resource == null) {
            return null;
        }
        InputStream input = TexturePackAPI.getInputStream(resource);
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e) {
                logger.error("could not read %s", resource);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    public static Properties getProperties(class_1653 resource) {
        Properties properties = new Properties();
        if (TexturePackAPI.getProperties(resource, properties)) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getProperties(class_1653 resource, Properties properties) {
        if (properties != null) {
            InputStream input = TexturePackAPI.getInputStream(resource);
            try {
                if (input != null) {
                    properties.load(input);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                logger.error("could not read %s", resource);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }

    public static class_1653 transformResourceLocation(class_1653 resource, String oldExt, String newExt) {
        return new class_1653(resource.method_5891(), resource.method_5890().replaceFirst(Pattern.quote(oldExt) + "$", newExt));
    }

    public static class_1653 parsePath(String path) {
        int slash;
        if (MCPatcherUtils.isNullOrEmpty(path)) {
            return null;
        }
        if ((path = path.replace(File.separatorChar, '/')).startsWith(ASSETS) && (slash = (path = path.substring(ASSETS.length())).indexOf(47)) > 0 && slash + 1 < path.length()) {
            return new class_1653(path.substring(0, slash), path.substring(slash + 1));
        }
        return null;
    }

    public static class_1653 parseIdentifier(class_1653 baseResource, String path) {
        int colon;
        if (MCPatcherUtils.isNullOrEmpty(path)) {
            return null;
        }
        boolean absolute = false;
        if (path.startsWith("%blur%")) {
            path = path.substring(6);
        }
        if (path.startsWith("%clamp%")) {
            path = path.substring(7);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
            absolute = true;
        }
        if (path.startsWith("assets/minecraft/")) {
            path = path.substring(17);
            absolute = true;
        }
        if ((colon = path.indexOf(58)) >= 0) {
            return new class_1653(path.substring(0, colon), path.substring(colon + 1));
        }
        class_1653 resource = path.startsWith("~/") ? new class_1653(baseResource.method_5891(), MCPATCHER_SUBDIR + path.substring(2)) : (path.startsWith("./") ? new class_1653(baseResource.method_5891(), baseResource.method_5890().replaceFirst("[^/]+$", "") + path.substring(2)) : (!absolute && !path.contains("/") ? new class_1653(baseResource.method_5891(), baseResource.method_5890().replaceFirst("[^/]+$", "") + path) : new class_1653(baseResource.method_5891(), path)));
        if (baseResource instanceof IdentifierWithSource) {
            resource = new IdentifierWithSource(((IdentifierWithSource)baseResource).getSource(), resource);
        }
        return resource;
    }

    public static class_1653 newMCPatcherResourceLocation(String path) {
        return new class_1653(MCPATCHER_SUBDIR + path.replaceFirst("^/+", ""));
    }

    public static int getTextureIfLoaded(class_1653 resource) {
        if (resource == null) {
            return -1;
        }
        class_319 texture = class_1600.method_2965().method_5570().method_5852(resource);
        return texture instanceof class_314 ? texture.method_5855() : -1;
    }

    public static boolean isTextureLoaded(class_1653 resource) {
        return TexturePackAPI.getTextureIfLoaded(resource) >= 0;
    }

    public static class_319 getTextureObject(class_1653 resource) {
        return class_1600.method_2965().method_5570().method_5852(resource);
    }

    public static void bindTexture(class_1653 resource) {
        if (resource != null) {
            class_1600.method_2965().method_5570().method_5847(resource);
        }
    }

    public static void unloadTexture(class_1653 resource) {
        class_1532 textureManager;
        class_319 texture;
        if (resource != null && (texture = (textureManager = class_1600.method_2965().method_5570()).method_5852(resource)) != null && !(texture instanceof class_1533) && !(texture instanceof class_1636)) {
            if (texture instanceof class_314) {
                ((AbstractTextureExpansion)texture).unloadGLTexture();
            }
            logger.finer("unloading texture %s", resource);
            textureManager.field_6575.remove(resource);
        }
    }

    public static void flushUnusedTextures() {
    }
}

