/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.compat.mojang.minecraft.math;

import net.minecraft.class_1146;
import net.minecraft.class_1167;
import net.minecraft.class_2552;
import net.minecraft.class_837;

public class SectionPos
extends class_1167 {
    public static final int SECTION_BITS = 4;
    public static final int SECTION_MAX_INDEX = 15;
    private static final long PACKED_X_MASK = 0x3FFFFFL;
    private static final long PACKED_Y_MASK = 1048575L;
    private static final long PACKED_Z_MASK = 0x3FFFFFL;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = 20;
    private static final int X_OFFSET = 42;

    SectionPos(int x, int y, int z) {
        super(x, y, z);
    }

    public static SectionPos of(int x, int y, int z) {
        return new SectionPos(x, y, z);
    }

    public static SectionPos of(class_2552 pos) {
        int x = SectionPos.blockToSectionCoord(pos.method_10572());
        int y = SectionPos.blockToSectionCoord(pos.method_10573());
        int z = SectionPos.blockToSectionCoord(pos.method_10574());
        return new SectionPos(x, y, z);
    }

    public static SectionPos of(class_1146 pos, int y) {
        return new SectionPos(pos.field_4507, y, pos.field_4508);
    }

    public static SectionPos of(long packed) {
        return new SectionPos(SectionPos.x(packed), SectionPos.y(packed), SectionPos.z(packed));
    }

    public static int posToSectionCoord(double d) {
        return SectionPos.blockToSectionCoord(class_837.method_2345((double)d));
    }

    public static int blockToSectionCoord(int n) {
        return n >> 4;
    }

    public static int sectionToBlockCoord(int n) {
        return n << 4;
    }

    public static int sectionToBlockCoord(int n, int n2) {
        return SectionPos.sectionToBlockCoord(n) + n2;
    }

    public static int x(long packed) {
        return (int)(packed >> 42 & 0x3FFFFFL);
    }

    public static int y(long packed) {
        return (int)(packed & 0xFFFFFL);
    }

    public static int z(long packed) {
        return (int)(packed >> 20 & 0x3FFFFFL);
    }

    public int x() {
        return this.method_10572();
    }

    public int y() {
        return this.method_10573();
    }

    public int z() {
        return this.method_10574();
    }

    public int minBlockX() {
        return SectionPos.sectionToBlockCoord(this.x());
    }

    public int minBlockY() {
        return SectionPos.sectionToBlockCoord(this.y());
    }

    public int minBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z());
    }

    public int maxBlockX() {
        return SectionPos.sectionToBlockCoord(this.x(), 15);
    }

    public int maxBlockY() {
        return SectionPos.sectionToBlockCoord(this.y(), 15);
    }

    public int maxBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z(), 15);
    }

    public class_2552 origin() {
        int x = SectionPos.sectionToBlockCoord(this.x());
        int y = SectionPos.sectionToBlockCoord(this.y());
        int z = SectionPos.sectionToBlockCoord(this.z());
        return new class_2552(x, y, z);
    }

    public class_1146 chunk() {
        return new class_1146(this.x(), this.z());
    }

    public static long asLong(int x, int y, int z) {
        long packed = 0L;
        packed |= ((long)x & 0x3FFFFFL) << 42;
        packed |= ((long)y & 0xFFFFFL) << 0;
        return packed |= ((long)z & 0x3FFFFFL) << 20;
    }

    public long asLong() {
        return SectionPos.asLong(this.x(), this.y(), this.z());
    }
}

