/*
 * Decompiled with CFR 0.152.
 */
package dev.vexor.radium.mixin.sodium.features.gui.hooks.debug;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.class_1442;
import net.minecraft.class_2294;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_2294.class})
public abstract class DebugScreenOverlayMixin {
    @Redirect(method={"method_9452()Ljava/util/List;"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList([Ljava/lang/Object;)Ljava/util/ArrayList;", remap=false))
    private ArrayList<String> redirectRightTextEarly(Object[] elements) {
        ArrayList strings = Lists.newArrayList((Object[])((String[])elements));
        strings.add("");
        strings.add("%sRadium Renderer (%s)".formatted(DebugScreenOverlayMixin.getVersionColor(), SodiumClientMod.getVersion()));
        SodiumWorldRenderer renderer = SodiumWorldRenderer.instanceNullable();
        if (renderer != null) {
            strings.addAll(renderer.getDebugStrings());
        }
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, DebugScreenOverlayMixin.getNativeMemoryString());
            break;
        }
        return strings;
    }

    @Unique
    private static class_1442 getVersionColor() {
        String version = SodiumClientMod.getVersion();
        class_1442 color = version.contains("-local") ? class_1442.field_5495 : (version.contains("-snapshot") ? class_1442.field_5496 : class_1442.field_5493);
        return color;
    }

    @Unique
    private static String getNativeMemoryString() {
        return "Off-Heap: +" + MathUtil.toMib(DebugScreenOverlayMixin.getNativeMemoryUsage()) + "MB";
    }

    @Unique
    private static long getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed() + NativeBuffer.getTotalAllocated();
    }
}

