/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.api.math;

import net.caffeinemc.mods.sodium.api.util.NormI8;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MatrixHelper {
    public static int transformNormal(Matrix3f mat, boolean skipNormalization, float x, float y, float z) {
        float nxt = MatrixHelper.transformNormalX(mat, x, y, z);
        float nyt = MatrixHelper.transformNormalY(mat, x, y, z);
        float nzt = MatrixHelper.transformNormalZ(mat, x, y, z);
        if (!skipNormalization) {
            float scalar = Math.invsqrt(Math.fma(nxt, nxt, Math.fma(nyt, nyt, nzt * nzt)));
            nxt *= scalar;
            nyt *= scalar;
            nzt *= scalar;
        }
        return NormI8.pack(nxt, nyt, nzt);
    }

    public static int transformSafeNormal(Matrix3f mat, float x, float y, float z) {
        float nxt = MatrixHelper.transformNormalX(mat, x, y, z);
        float nyt = MatrixHelper.transformNormalY(mat, x, y, z);
        float nzt = MatrixHelper.transformNormalZ(mat, x, y, z);
        return NormI8.pack(nxt, nyt, nzt);
    }

    public static int transformNormal(Matrix3f mat, boolean skipNormalization, int norm) {
        float x = NormI8.unpackX(norm);
        float y = NormI8.unpackY(norm);
        float z = NormI8.unpackZ(norm);
        return MatrixHelper.transformNormal(mat, skipNormalization, x, y, z);
    }

    public static float transformNormalX(Matrix3f mat, float x, float y, float z) {
        return mat.m00() * x + (mat.m10() * y + mat.m20() * z);
    }

    public static float transformNormalY(Matrix3f mat, float x, float y, float z) {
        return mat.m01() * x + (mat.m11() * y + mat.m21() * z);
    }

    public static float transformNormalZ(Matrix3f mat, float x, float y, float z) {
        return mat.m02() * x + (mat.m12() * y + mat.m22() * z);
    }

    public static float transformPositionX(Matrix4f mat, float x, float y, float z) {
        return mat.m00() * x + (mat.m10() * y + (mat.m20() * z + mat.m30()));
    }

    public static float transformPositionY(Matrix4f mat, float x, float y, float z) {
        return mat.m01() * x + (mat.m11() * y + (mat.m21() * z + mat.m31()));
    }

    public static float transformPositionZ(Matrix4f mat, float x, float y, float z) {
        return mat.m02() * x + (mat.m12() * y + (mat.m22() * z + mat.m32()));
    }
}

