/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.shader;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.gl.GlObject;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderParser;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderType;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderWorkarounds;
import net.minecraft.class_1653;
import net.minecraft.class_629;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final class_1653 name;

    public GlShader(ShaderType type, class_1653 name, ShaderParser.ParsedShader parsedShader) {
        int result;
        this.name = name;
        int handle = GL20.glCreateShader(type.id);
        ShaderWorkarounds.safeShaderSource(handle, parsedShader.src());
        GL20.glCompileShader(handle);
        String log = GL20.glGetShaderInfoLog(handle, 1000);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for {}: {}", new Object[]{this.name, log});
            LOGGER.warn("Include table: {}", new Object[]{Arrays.toString(parsedShader.includeIds())});
        }
        if ((result = class_629.method_7299((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
    }

    public class_1653 getName() {
        return this.name;
    }

    public void delete() {
        GL20.glDeleteShader(this.handle());
        this.invalidateHandle();
    }
}

