/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options;

import dev.vexor.radium.options.client.gui.OptionExtended;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.binding.GenericBinding;
import net.caffeinemc.mods.sodium.client.gui.options.binding.OptionBinding;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1982;
import org.apache.commons.lang3.Validate;

public class OptionImpl<S, T>
implements OptionExtended<T> {
    private final OptionStorage<S> storage;
    private final OptionBinding<S, T> binding;
    private final Control<T> control;
    private final EnumSet<OptionFlag> flags;
    private final class_1982 name;
    private final Function<T, class_1982> tooltip;
    private final OptionImpact impact;
    private T value;
    private T modifiedValue;
    private final BooleanSupplier enabled;
    private Dim2i parentDimension;
    private Dim2i dim2i;
    private boolean highlight;
    private boolean selected;

    private OptionImpl(OptionStorage<S> storage, class_1982 name, Function<T, class_1982> tooltip, OptionBinding<S, T> binding, Function<OptionImpl<S, T>, Control<T>> control, EnumSet<OptionFlag> flags, OptionImpact impact, BooleanSupplier enabled) {
        this.storage = storage;
        this.name = name;
        this.tooltip = tooltip;
        this.binding = binding;
        this.impact = impact;
        this.flags = flags;
        this.control = control.apply(this);
        this.enabled = enabled;
        this.reset();
    }

    @Override
    public class_1982 getName() {
        return this.name;
    }

    @Override
    public class_1982 getTooltip() {
        return this.tooltip.apply(this.modifiedValue);
    }

    @Override
    public OptionImpact getImpact() {
        return this.impact;
    }

    @Override
    public Control<T> getControl() {
        return this.control;
    }

    @Override
    public T getValue() {
        return this.modifiedValue;
    }

    @Override
    public void setValue(T value) {
        this.modifiedValue = value;
    }

    @Override
    public void reset() {
        this.value = this.binding.getValue(this.storage.getData());
        this.modifiedValue = this.value;
    }

    @Override
    public OptionStorage<?> getStorage() {
        return this.storage;
    }

    @Override
    public boolean isAvailable() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public boolean hasChanged() {
        return !this.value.equals(this.modifiedValue);
    }

    @Override
    public void applyChanges() {
        this.binding.setValue(this.storage.getData(), this.modifiedValue);
        this.value = this.modifiedValue;
    }

    @Override
    public Collection<OptionFlag> getFlags() {
        return this.flags;
    }

    public static <S, T> Builder<S, T> createBuilder(Class<T> type, OptionStorage<S> storage) {
        return new Builder(storage);
    }

    @Override
    public boolean isHighlight() {
        return this.highlight;
    }

    @Override
    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    @Override
    public Dim2i getDim2i() {
        return this.dim2i;
    }

    @Override
    public void setDim2i(Dim2i dim2i) {
        this.dim2i = dim2i;
    }

    @Override
    public Dim2i getParentDimension() {
        return this.parentDimension;
    }

    @Override
    public void setParentDimension(Dim2i dim2i) {
        this.parentDimension = dim2i;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static class Builder<S, T> {
        private final OptionStorage<S> storage;
        private class_1982 name;
        private Function<T, class_1982> tooltip;
        private OptionBinding<S, T> binding;
        private Function<OptionImpl<S, T>, Control<T>> control;
        private OptionImpact impact;
        private final EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        private BooleanSupplier enabled = () -> true;

        private Builder(OptionStorage<S> storage) {
            this.storage = storage;
        }

        public Builder<S, T> setName(class_1982 name) {
            Validate.notNull((Object)name, (String)"Argument must not be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Builder<S, T> setTooltip(class_1982 tooltip) {
            Validate.notNull((Object)tooltip, (String)"Argument must not be null", (Object[])new Object[0]);
            this.tooltip = t -> tooltip;
            return this;
        }

        public Builder<S, T> setTooltip(Function<T, class_1982> tooltip) {
            Validate.notNull(tooltip, (String)"Argument must not be null", (Object[])new Object[0]);
            this.tooltip = tooltip;
            return this;
        }

        public Builder<S, T> setBinding(BiConsumer<S, T> setter, Function<S, T> getter) {
            Validate.notNull(setter, (String)"Setter must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"Getter must not be null", (Object[])new Object[0]);
            this.binding = new GenericBinding<S, T>(setter, getter);
            return this;
        }

        public Builder<S, T> setBinding(OptionBinding<S, T> binding) {
            Validate.notNull(binding, (String)"Argument must not be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        public Builder<S, T> setControl(Function<OptionImpl<S, T>, Control<T>> control) {
            Validate.notNull(control, (String)"Argument must not be null", (Object[])new Object[0]);
            this.control = control;
            return this;
        }

        public Builder<S, T> setImpact(OptionImpact impact) {
            this.impact = impact;
            return this;
        }

        public Builder<S, T> setEnabled(BooleanSupplier value) {
            this.enabled = value;
            return this;
        }

        public Builder<S, T> setFlags(OptionFlag ... flags) {
            Collections.addAll(this.flags, flags);
            return this;
        }

        public OptionImpl<S, T> build() {
            Validate.notNull((Object)this.name, (String)"Name must be specified", (Object[])new Object[0]);
            Validate.notNull(this.tooltip, (String)"Tooltip must be specified", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"Option binding must be specified", (Object[])new Object[0]);
            Validate.notNull(this.control, (String)"Control must be specified", (Object[])new Object[0]);
            return new OptionImpl<S, T>(this.storage, this.name, this.tooltip, this.binding, this.control, this.flags, this.impact, this.enabled);
        }
    }
}

