/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import dev.vexor.radium.compat.mojang.minecraft.gui.Renderable;
import dev.vexor.radium.compat.mojang.minecraft.gui.input.CommonInputs;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_1982;
import org.jetbrains.annotations.NotNull;

public class FlatButtonWidget
extends AbstractWidget
implements Renderable {
    private final Dim2i dim;
    private final Runnable action;
    @NotNull
    private Style style = Style.defaults();
    private boolean selected;
    private boolean enabled = true;
    private boolean visible = true;
    private class_1982 label;

    public FlatButtonWidget(Dim2i dim, class_1982 label, Runnable action) {
        this.dim = dim;
        this.label = label;
        this.action = action;
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.hovered = this.dim.containsCursor(mouseX, mouseY);
        int backgroundColor = this.enabled ? (this.hovered ? this.style.bgHovered : this.style.bgDefault) : this.style.bgDisabled;
        int textColor = this.enabled ? this.style.textDefault : this.style.textDisabled;
        int strWidth = this.font.method_954(this.label.method_7472());
        this.drawRect(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), backgroundColor);
        this.drawString(this.label, this.dim.getCenterX() - strWidth / 2, this.dim.getCenterY() - 4, textColor);
        if (this.enabled && this.selected) {
            this.drawRect(this.dim.x(), this.dim.getLimitY() - 1, this.dim.getLimitX(), this.dim.getLimitY(), -7019309);
        }
        if (this.enabled && this.isFocused()) {
            this.drawBorder(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -1);
        }
    }

    public void setStyle(@NotNull Style style) {
        Objects.requireNonNull(style);
        this.style = style;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.enabled || !this.visible) {
            return false;
        }
        if (button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
            this.doAction();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, char scanCode) {
        if (!this.isFocused()) {
            return false;
        }
        if (CommonInputs.selected(keyCode)) {
            this.doAction();
            return true;
        }
        return false;
    }

    private void doAction() {
        this.action.run();
        this.playClickSound();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setLabel(class_1982 text) {
        this.label = text;
    }

    public class_1982 getLabel() {
        return this.label;
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        return this.dim.containsCursor(x, y);
    }

    public static class Style {
        public int bgHovered;
        public int bgDefault;
        public int bgDisabled;
        public int textDefault;
        public int textDisabled;

        public static Style defaults() {
            Style style = new Style();
            style.bgHovered = -536870912;
            style.bgDefault = -1879048192;
            style.bgDisabled = 0x60000000;
            style.textDefault = -1;
            style.textDisabled = -1862270977;
            return style;
        }
    }
}

