/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.color;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.color.DefaultColorProviders;
import net.minecraft.class_153;
import net.minecraft.class_1752;
import net.minecraft.class_197;

public class ColorProviderRegistry {
    private final Reference2ReferenceMap<class_197, ColorProvider> blocks = new Reference2ReferenceOpenHashMap<class_197, ColorProvider>();
    private final Reference2ReferenceMap<class_197, ColorProvider> fluids = new Reference2ReferenceOpenHashMap<class_197, ColorProvider>();

    public ColorProviderRegistry() {
        this.installOverrides();
        this.blocks.defaultReturnValue(DefaultColorProviders.BLOCK);
    }

    private void installOverrides() {
        this.registerBlocks(DefaultColorProviders.GRASS, new class_197[]{class_1752.field_7406, class_1752.field_9291, class_1752.field_7281, class_1752.field_7419});
        this.registerBlocks(DefaultColorProviders.FOLIAGE, new class_197[]{class_1752.field_7438, class_1752.field_7439, class_1752.field_7383});
        this.registerBlocks(DefaultColorProviders.WATER, new class_197[]{class_1752.field_9324});
        this.registerFluids(DefaultColorProviders.WATER, new class_153[]{class_1752.field_9324, class_1752.field_9323});
    }

    private void registerBlocks(ColorProvider provider, class_197 ... blocks) {
        for (class_197 block : blocks) {
            this.blocks.put(block, provider);
        }
    }

    private void registerFluids(ColorProvider provider, class_153 ... fluids) {
        for (class_153 fluid : fluids) {
            this.fluids.put((class_197)fluid, provider);
        }
    }

    public ColorProvider getColorProvider(class_197 block) {
        return (ColorProvider)this.blocks.get(block);
    }

    public ColorProvider getColorProvider(class_153 fluid) {
        return (ColorProvider)this.fluids.get(fluid);
    }
}

