/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.QuadSplittingMode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPBuildFailureException;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.AnyOrderData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.CombinedCameraPos;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicBSPData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicTopoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.NoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.PresentTranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.StaticNormalRelativeData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.StaticTopoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.FullTQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.RegularTQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.GeometryPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.minecraft.class_837;

public class TranslucentGeometryCollector {
    private final SectionPos sectionPos;
    private final QuadSplittingMode quadSplittingMode;
    private final SortBehavior sortBehavior;
    private boolean hasUnaligned;
    private int untrackedUnalignedNormalCount;
    private int alignedFacingBitmap;
    private final float[] extents;
    private boolean alignedExtentsMultiple;
    private final float[] alignedExtremes;
    private int unalignedANormal;
    private float unalignedADistance1;
    private float unalignedADistance2;
    private int unalignedBNormal;
    private float unalignedBDistance1;
    private float unalignedBDistance2;
    private ReferenceArrayList<TQuad>[] quadLists;
    private final int[] meshFacingCounts;
    private TQuad[] quads;
    private SortType sortType;
    private boolean quadHashPresent;
    private int quadHash;
    private static final int[] STATIC_TOPO_SORT_ATTEMPT_LIMITS = new int[]{-1, -1, 250, 100, 50, 30};
    public static final int STATIC_TOPO_UNKNOWN_FALLBACK_LIMIT = STATIC_TOPO_SORT_ATTEMPT_LIMITS[STATIC_TOPO_SORT_ATTEMPT_LIMITS.length - 1];

    public TranslucentGeometryCollector(SectionPos sectionPos, SortBehavior sortBehavior) {
        this.quadSplittingMode = SodiumClientMod.options().performance.quadSplittingMode;
        this.hasUnaligned = false;
        this.untrackedUnalignedNormalCount = 0;
        this.alignedFacingBitmap = 0;
        this.extents = new float[]{Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY};
        this.alignedExtentsMultiple = false;
        this.alignedExtremes = new float[]{Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY};
        this.unalignedANormal = -1;
        this.unalignedADistance1 = Float.NaN;
        this.unalignedADistance2 = Float.NaN;
        this.unalignedBNormal = -1;
        this.unalignedBDistance1 = Float.NaN;
        this.unalignedBDistance2 = Float.NaN;
        this.quadLists = new ReferenceArrayList[ModelQuadFacing.COUNT];
        this.meshFacingCounts = new int[ModelQuadFacing.COUNT];
        this.quadHashPresent = false;
        this.quadHash = 0;
        this.sectionPos = sectionPos;
        this.sortBehavior = sortBehavior;
    }

    public boolean appendQuad(ChunkVertexEncoder.Vertex[] vertices, ModelQuadFacing facing, int packedNormal) {
        RegularTQuad quad = this.isSplittingQuads() ? FullTQuad.fromVertices(vertices, facing, packedNormal) : RegularTQuad.fromVertices(vertices, facing, packedNormal);
        if (quad == null) {
            return true;
        }
        int direction = facing.ordinal();
        ReferenceArrayList<TQuad> quadList = this.quadLists[direction];
        if (quadList == null) {
            this.quadLists[direction] = quadList = new ReferenceArrayList();
        }
        quadList.add(quad);
        if (facing.isAligned()) {
            if (!this.hasUnaligned) {
                int i;
                float[] quadExtents = quad.getExtents();
                for (i = 0; i < 3; ++i) {
                    this.extents[i] = Math.max(this.extents[i], quadExtents[i]);
                }
                for (i = 3; i < 6; ++i) {
                    this.extents[i] = Math.min(this.extents[i], quadExtents[i]);
                }
            }
            float extreme = this.alignedExtremes[direction];
            float distance = quad.getAccurateDotProduct();
            float existingExtreme = this.alignedExtremes[direction];
            if (!this.alignedExtentsMultiple && !Float.isInfinite(existingExtreme) && existingExtreme != distance) {
                this.alignedExtentsMultiple = true;
            }
            this.alignedExtremes[direction] = facing.getSign() > 0 ? Math.max(extreme, distance) : Math.min(extreme, distance);
        } else {
            this.hasUnaligned = true;
            float distance = quad.getAccurateDotProduct();
            if (packedNormal == this.unalignedANormal) {
                if (Float.isNaN(this.unalignedADistance1)) {
                    this.unalignedADistance1 = distance;
                } else {
                    this.unalignedADistance2 = distance;
                }
            } else if (packedNormal == this.unalignedBNormal) {
                if (Float.isNaN(this.unalignedBDistance1)) {
                    this.unalignedBDistance1 = distance;
                } else {
                    this.unalignedBDistance2 = distance;
                }
            } else if (this.unalignedANormal == -1) {
                this.unalignedANormal = packedNormal;
                this.unalignedADistance1 = distance;
            } else if (this.unalignedBNormal == -1) {
                this.unalignedBNormal = packedNormal;
                this.unalignedBDistance1 = distance;
            } else {
                ++this.untrackedUnalignedNormalCount;
            }
        }
        return false;
    }

    public boolean isSplittingQuads() {
        return this.quadSplittingMode.allowsSplitting();
    }

    private static SortType filterSortType(SortType sortType, SortBehavior sortBehavior) {
        switch (sortBehavior) {
            case OFF: {
                return SortType.NONE;
            }
            case STATIC: {
                if (sortType == SortType.STATIC_NORMAL_RELATIVE || sortType == SortType.STATIC_TOPO) {
                    return sortType;
                }
                return SortType.NONE;
            }
        }
        return sortType;
    }

    private SortType sortTypeHeuristic() {
        int attemptLimitIndex;
        int alignedDirection;
        if (this.quads.length <= 1) {
            return SortType.NONE;
        }
        if (this.sortBehavior.getSortMode() == SortBehavior.SortMode.NONE) {
            return SortType.NONE;
        }
        int alignedNormalCount = Integer.bitCount(this.alignedFacingBitmap);
        int planeCount = this.getPlaneCount(alignedNormalCount);
        int unalignedNormalCount = this.untrackedUnalignedNormalCount;
        if (this.unalignedANormal != -1) {
            ++unalignedNormalCount;
        }
        if (this.unalignedBNormal != -1) {
            ++unalignedNormalCount;
        }
        int normalCount = alignedNormalCount + unalignedNormalCount;
        if (planeCount <= 1) {
            return SortType.NONE;
        }
        if (!this.hasUnaligned) {
            boolean opposingAlignedNormals = ModelQuadFacing.bitmapIsOpposingAligned(this.alignedFacingBitmap);
            if (planeCount == 2 && opposingAlignedNormals) {
                return SortType.NONE;
            }
            if (!this.alignedExtentsMultiple) {
                boolean passesBoundingBoxTest = true;
                for (int direction = 0; direction < ModelQuadFacing.DIRECTIONS; ++direction) {
                    int sign;
                    float extreme = this.alignedExtremes[direction];
                    if (Float.isInfinite(extreme)) continue;
                    int n = sign = direction < 3 ? 1 : -1;
                    if ((float)sign * extreme == this.extents[direction]) continue;
                    passesBoundingBoxTest = false;
                    break;
                }
                if (passesBoundingBoxTest) {
                    return SortType.NONE;
                }
            }
            if (opposingAlignedNormals || alignedNormalCount == 1) {
                return SortType.STATIC_NORMAL_RELATIVE;
            }
        } else if (alignedNormalCount == 0 ? unalignedNormalCount == 1 || unalignedNormalCount == 2 && NormI8.isOpposite(this.unalignedANormal, this.unalignedBNormal) : planeCount == 2 && NormI8.isOpposite(this.unalignedANormal, ModelQuadFacing.PACKED_ALIGNED_NORMALS[alignedDirection = Integer.numberOfTrailingZeros(this.alignedFacingBitmap)])) {
            return SortType.STATIC_NORMAL_RELATIVE;
        }
        if (this.quads.length <= STATIC_TOPO_SORT_ATTEMPT_LIMITS[attemptLimitIndex = class_837.method_2339((int)normalCount, (int)2, (int)(STATIC_TOPO_SORT_ATTEMPT_LIMITS.length - 1))]) {
            return SortType.STATIC_TOPO;
        }
        return SortType.DYNAMIC;
    }

    private int getPlaneCount(int alignedNormalCount) {
        int alignedPlaneCount = alignedNormalCount;
        if (this.alignedExtentsMultiple) {
            alignedPlaneCount = 100;
        }
        int unalignedPlaneCount = 0;
        if (!Float.isNaN(this.unalignedADistance1)) {
            ++unalignedPlaneCount;
        }
        if (!Float.isNaN(this.unalignedADistance2)) {
            ++unalignedPlaneCount;
        }
        if (!Float.isNaN(this.unalignedBDistance1)) {
            ++unalignedPlaneCount;
        }
        if (!Float.isNaN(this.unalignedBDistance2)) {
            ++unalignedPlaneCount;
        }
        return alignedPlaneCount + unalignedPlaneCount;
    }

    public SortType finishRendering() {
        int totalQuadCount = 0;
        for (ReferenceArrayList<TQuad> quadList : this.quadLists) {
            if (quadList == null) continue;
            totalQuadCount += quadList.size();
        }
        this.quads = new TQuad[totalQuadCount];
        int quadIndex = 0;
        for (int direction = 0; direction < ModelQuadFacing.COUNT; ++direction) {
            ReferenceArrayList<TQuad> quadList = this.quadLists[direction];
            if (quadList == null) continue;
            this.meshFacingCounts[direction] = quadList.size();
            for (TQuad quad : quadList) {
                this.quads[quadIndex++] = quad;
            }
            if (direction >= ModelQuadFacing.DIRECTIONS) continue;
            this.alignedFacingBitmap |= 1 << direction;
        }
        this.quadLists = null;
        this.sortType = TranslucentGeometryCollector.filterSortType(this.sortTypeHeuristic(), this.sortBehavior);
        return this.sortType;
    }

    private TranslucentData makeNewTranslucentData(CombinedCameraPos cameraPos, TranslucentData oldData) {
        if (this.sortType == SortType.NONE) {
            return AnyOrderData.fromMesh(this.quads, this.sectionPos);
        }
        if (this.sortType == SortType.STATIC_NORMAL_RELATIVE) {
            boolean isDoubleUnaligned = this.alignedFacingBitmap == 0;
            return StaticNormalRelativeData.fromMesh(this.meshFacingCounts, this.quads, this.sectionPos, isDoubleUnaligned);
        }
        if (this.sortType == SortType.STATIC_TOPO) {
            StaticTopoData result = StaticTopoData.fromMesh(this.quads, this.sectionPos, this.isSplittingQuads());
            if (result != null) {
                return result;
            }
            this.sortType = SortType.DYNAMIC;
        }
        this.sortType = TranslucentGeometryCollector.filterSortType(this.sortType, this.sortBehavior);
        if (this.sortType == SortType.NONE) {
            return AnyOrderData.fromMesh(this.quads, this.sectionPos);
        }
        if (this.sortType == SortType.DYNAMIC) {
            try {
                return DynamicBSPData.fromMesh(cameraPos, this.quads, this.sectionPos, oldData, this.quadSplittingMode);
            }
            catch (BSPBuildFailureException e) {
                GeometryPlanes geometryPlanes = GeometryPlanes.fromQuadLists(this.sectionPos, this.quads);
                return DynamicTopoData.fromMesh(cameraPos, this.quads, this.sectionPos, geometryPlanes);
            }
        }
        throw new IllegalStateException("Unknown sort type: " + String.valueOf((Object)this.sortType));
    }

    public int getQuadHash() {
        if (this.quadHashPresent) {
            return this.quadHash;
        }
        TQuad[] quads = this.quads;
        for (int i = 0; i < quads.length; ++i) {
            TQuad quad = quads[i];
            this.quadHash = this.quadHash * 31 + quad.getQuadHash() + i * 3;
        }
        this.quadHashPresent = true;
        return this.quadHash;
    }

    public TranslucentData getTranslucentData(TranslucentData oldData, CombinedCameraPos cameraPos) {
        if (this.quads.length == 0) {
            return NoData.forNoTranslucent(this.sectionPos);
        }
        if (oldData != null && oldData.oldDataMatches(this, this.sortType, this.quads)) {
            return oldData;
        }
        TranslucentData newData = this.makeNewTranslucentData(cameraPos, oldData);
        if (newData instanceof PresentTranslucentData) {
            PresentTranslucentData presentData = (PresentTranslucentData)newData;
            presentData.setQuadHash(this.getQuadHash());
        }
        return newData;
    }
}

