/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree;

import dev.vexor.radium.compat.mojang.minecraft.math.SectionPos;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.QuadSplittingMode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPResult;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPSortState;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPWorkspace;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.InnerPartitionBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.LeafDoubleBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.LeafSingleBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TopoGraphSorting;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.TQuad;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import org.joml.Vector3fc;

public abstract class BSPNode {
    abstract void collectSortedQuads(BSPSortState var1, Vector3fc var2);

    public void collectSortedQuads(NativeBuffer nativeBuffer, Vector3fc cameraPos) {
        this.collectSortedQuads(new BSPSortState(nativeBuffer), cameraPos);
    }

    public static BSPResult buildBSP(TQuad[] quads, SectionPos sectionPos, BSPNode oldRoot, boolean prepareNodeReuse, QuadSplittingMode quadSplittingMode) {
        InnerPartitionBSPNode.validateQuadCount(quads.length);
        BSPWorkspace workspace = new BSPWorkspace(quads, sectionPos, prepareNodeReuse, quadSplittingMode);
        int[] initialIndexes = new int[quads.length];
        for (int i = 0; i < quads.length; ++i) {
            initialIndexes[i] = i;
        }
        IntArrayList allIndexes = new IntArrayList(initialIndexes);
        BSPNode rootNode = BSPNode.build(workspace, allIndexes, -1, oldRoot);
        BSPResult result = workspace.result;
        result.setRootNode(rootNode);
        result.setUpdatedQuadIndexes(workspace.getFinalizedUpdatedQuads());
        return result;
    }

    private static boolean doubleLeafPossible(TQuad quadA, TQuad quadB, boolean failOnIntersection) {
        ModelQuadFacing facingA = quadA.getFacing();
        ModelQuadFacing facingB = quadB.getFacing();
        if (!facingA.isAligned() || !facingB.isAligned()) {
            int packedNormalB;
            int packedNormalA = quadA.getPackedNormal();
            return NormI8.isOpposite(packedNormalA, packedNormalB = quadB.getPackedNormal()) || packedNormalA == packedNormalB && quadA.getAccurateDotProduct() == quadB.getAccurateDotProduct();
        }
        if (quadA.getExtents()[facingA.ordinal()] == quadB.getExtents()[facingB.ordinal()]) {
            return true;
        }
        if (facingA == facingB.getOpposite()) {
            return true;
        }
        return !TopoGraphSorting.orthogonalQuadVisibleThrough(quadA, quadB, failOnIntersection) && !TopoGraphSorting.orthogonalQuadVisibleThrough(quadB, quadA, failOnIntersection);
    }

    static BSPNode build(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode) {
        ++depth;
        if (indexes.isEmpty()) {
            return null;
        }
        if (indexes.size() == 1) {
            return new LeafSingleBSPNode(indexes.getInt(0));
        }
        if (indexes.size() == 2) {
            TQuad quadB;
            int quadIndexA = indexes.getInt(0);
            int quadIndexB = indexes.getInt(1);
            TQuad quadA = (TQuad)workspace.get(quadIndexA);
            if (BSPNode.doubleLeafPossible(quadA, quadB = (TQuad)workspace.get(quadIndexB), workspace.canSplitQuads())) {
                return new LeafDoubleBSPNode(quadIndexA, quadIndexB);
            }
        }
        return InnerPartitionBSPNode.build(workspace, indexes, depth, oldNode);
    }
}

